/*

Project Name : GTASC TileMap Maker
GTASC is a GTA adaptation for TI Calculators


Programmed by : Olivier SANGALA
Version : 1.0
License : Free under GNU General Public License ( see "gpl.txt" )
Release Date : January 8,2007
Platform : Windows 9x/Me/XP
Website : http://olivier.sangala.free.fr
Email : olivier_sangala@hotmail.com


----------
License
----------

    Copyright (C) 2006-2007 Olivier SANGALA

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
//---------------------------------------------------------------------------

#ifndef maindlgH
#define maindlgH
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <Dialogs.hpp>
#include <ExtCtrls.hpp>
#include <Menus.hpp>
#include <ActnList.hpp>
//---------------------------------------------------------------------------


// Tile Definitions


// STREET TILES - DRIVE WAYS :

/*

00h = CLEAR - LEFT
01h = CLEAR - RIGHT
02h = CLEAR - DOWN
03h = CLEAR - UP
04h = LINE - LEFT
05h = LINE - RIGHT
06h = LINE - DOWN
07h = LINE - UP
08h = CROSSROADS
09h = NO WAY STREET TILE

*/


#define TILE_STREET_INDEX       (0x00)

#define TILE_WATER (0x0A)

#define TILE_SB_LINE       (0x20)
#define TILE_SB_CURVE      (0x24)

#define TILE_SIDEWALK      (0x10)

#define TILE_MANHOLE (0x19)

#define TILE_PAVING_INDEX     (0x1A)
#define TILE_PAVING_COUNT (4)

#define TILE_GRASS_INDEX    (0x1E)
#define TILE_GRASS_COUNT (2)

#define TILE_BB_INDEX      (0x20)
#define TILE_COUNT_BB        (8)

#define TILE_BI_INDEX      (0x60)
#define TILE_COUNT_BI       (44)

#define TILE_WALL (0x67)

#define TILE_BI_OBSTACLE   (0xA7)

#define TILE_TREE       (0x94) // 2 * 2
#define TILE_PHONEBOX      (0xA6)

//---------------------------------------------------------------------------

#define IsTileSideWalk(t) ((t)==TC_STREET || (t)==TC_CROSSROADS)

//---------------------------------------------------------------------------

#define ISTILE_STREET(t)         ((t)<=0x09)
#define ISTILE_PVT(t)        ((t)>=0x20 && (t)<=0x3F)
#define ISTILE_BLDG(t)       ((t)>=0x40 && (t)<=0xEF)

//--------------------------------------------------------------------------

enum {
TC_SIDEWALK,
TC_STREET,
TC_CROSSROADS,
TC_GRASS,
TC_WATER,
TC_PAVING,
TC_BUILDING,
TC_WALL,
TC_TREE,
TC_MANHOLE,
TC_PHONEBOX,
};

//---------------------------------------------------------------------------

int IsTopLeft(int y, int x);
void GetBottomRight(int x1, int y1, int *x2, int *y2);

//---------------------------------------------------------------------------

class TMainWnd : public TForm
{
__published:	// Composants grs par l'EDI
        TMainMenu *MainMenu1;
        TMenuItem *File1;
        TMenuItem *Open1;
        TOpenDialog *OpenDialog1;
        TSaveDialog *SaveDialog1;
        TMenuItem *Quit1;
        TMemo *Memo1;
        TMenuItem *N2;
        TMenuItem *About1;
        TActionList *ActionList1;
        TAction *Step1;
        TAction *Step2;
        TMenuItem *SaveToBinary1;
        void __fastcall Open1Click(TObject *Sender);
        void __fastcall FormCreate(TObject *Sender);
        void __fastcall FormDestroy(TObject *Sender);
        void __fastcall Quit1Click(TObject *Sender);
        void __fastcall About1Click(TObject *Sender);
        void __fastcall Step1Execute(TObject *Sender);
        void __fastcall Step2Execute(TObject *Sender);
        void __fastcall SaveToBinary1Click(TObject *Sender);
private:	// Dclarations utilisateur
public:		// Dclarations utilisateur
        __fastcall TMainWnd(TComponent* Owner);
};
//---------------------------------------------------------------------------
extern PACKAGE TMainWnd *MainWnd;
//---------------------------------------------------------------------------
#endif


