/*

Project Name : GTASC TileMap Maker
GTASC is a GTA adaptation for TI Calculators


Programmed by : Olivier SANGALA
Version : 1.0
License : Free under GNU General Public License ( see "gpl.txt" )
Release Date : January 8,2007
Platform : Windows 9x/Me/XP
Website : http://olivier.sangala.free.fr
Email : olivier_sangala@hotmail.com


----------
License
----------

    Copyright (C) 2006-2007 Olivier SANGALA

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "maindlg.h"
#include "aboutdlg.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TMainWnd *MainWnd;
//---------------------------------------------------------------------------

byte TileMap1[256][256];
byte TileMap2[256][256];

byte TMSizeX=128;
byte TMSizeY=128;

Graphics::TBitmap* bmp;

//---------------------------------------------------------------------------

int IsTopLeft(int y, int x)
{

byte tn = TileMap1[y][x];

int top = ( y==0 || TileMap1[y-1][x]!=tn ) ;
int left = ( x==0 || TileMap1[y][x-1]!=tn ) ;

return (top&left);

}

//---------------------------------------------------------------------------


void GetBottomRight(int x1, int y1, int *x2, int *y2)
{

byte tn = TileMap1[y1][x1];

(*x2) = x1;
(*y2) = y1;

while ((*x2)<(TMSizeX-1) && TileMap1[y1][(*x2)+1]==tn)
(*x2)++;

while ((*y2)<(TMSizeY-1) && TileMap1[(*y2)+1][x1]==tn)
(*y2)++;

}
//---------------------------------------------------------------------------


__fastcall TMainWnd::TMainWnd(TComponent* Owner)
        : TForm(Owner)
{
}
//---------------------------------------------------------------------------

void __fastcall TMainWnd::Open1Click(TObject *Sender)
{


if (OpenDialog1->Execute())
{


// load bitmap
bmp->LoadFromFile(OpenDialog1->FileName);

// force bitmap pixel format
bmp->PixelFormat = pf24bit;

TMSizeY=bmp->Height;
TMSizeX=bmp->Width;

AnsiString str;

str.sprintf("File opened : %s",OpenDialog1->FileName);
Memo1->Lines->Add(str);

str.sprintf("Size : Y=%d X=%d",TMSizeY,TMSizeX);
Memo1->Lines->Add(str);

}


}
//---------------------------------------------------------------------------

void __fastcall TMainWnd::FormCreate(TObject *Sender)
{

// create bitmap
bmp = new Graphics::TBitmap();

}
//---------------------------------------------------------------------------

void __fastcall TMainWnd::FormDestroy(TObject *Sender)
{

// delete bitmap
delete bmp;


}
//---------------------------------------------------------------------------

void __fastcall TMainWnd::Quit1Click(TObject *Sender)
{
Close();
}
//---------------------------------------------------------------------------


void __fastcall TMainWnd::About1Click(TObject *Sender)
{
AboutBox->ShowModal();
}
//---------------------------------------------------------------------------

void __fastcall TMainWnd::Step1Execute(TObject *Sender)
{



for (int y=0;y<TMSizeY;y++)
{

byte*ptr=(byte*)bmp->ScanLine[y];

for (int x=0;x<TMSizeX;x++)
{

// warning : RGB order inversed
byte b=*ptr++;
byte g=*ptr++;
byte r=*ptr++;

byte tn=0;

if (r==255 && g==255 && b==255)
tn=TC_SIDEWALK;
else if (r==0 && g==0 && b==0)
tn=TC_STREET;
else if (r==192 && g==192 && b==192)
tn=TC_CROSSROADS;
else if (r==0 && g==255 && b==0)
tn=TC_GRASS;
else if (r==0 && g==0 && b==255)
tn=TC_WATER;
else if (r==64 && g==64 && b==64)
tn=TC_PAVING;
else if (r==255 && g==0 && b==0)
tn=TC_BUILDING;
else if (r==255 && g==0 && b==255)
tn=TC_WALL;
else if (r==0 && g==128 && b==0)
tn=TC_TREE;
else if (r==255 && g==128 && b==64)
tn=TC_MANHOLE;
else if (r==0 && g==255 && b==255)
tn=TC_PHONEBOX;


TileMap1[y][x] = tn;

}
}

}
//---------------------------------------------------------------------------

void __fastcall TMainWnd::Step2Execute(TObject *Sender)
{


// init random for tm creation
randomize();

// TC_SIDEWALK
// TC_STREET
// TC_CROSSROADS
// TC_WATER
// TC_WALL
// TC_MANHOLE
// TC_PHONEBOX

for (int y=0;y<TMSizeY;y++)
for (int x=0;x<TMSizeX;x++)
{

if (TileMap1[y][x]==TC_SIDEWALK)
TileMap2[y][x]=TILE_SIDEWALK+8;

if (TileMap1[y][x]==TC_STREET)
TileMap2[y][x]=TILE_STREET_INDEX+9;

if (TileMap1[y][x]==TC_CROSSROADS)
TileMap2[y][x]=TILE_STREET_INDEX+8;

if (TileMap1[y][x]==TC_WATER)
TileMap2[y][x]=TILE_WATER;

if (TileMap1[y][x]==TC_WALL)
TileMap2[y][x]=TILE_WALL;

if (TileMap1[y][x]==TC_MANHOLE)
TileMap2[y][x]=TILE_MANHOLE;

if (TileMap1[y][x]==TC_PHONEBOX)
TileMap2[y][x]=TILE_PHONEBOX;



}

// ***** TC_TREE *****

for (int y=0;y<TMSizeY;y++)
for (int x=0;x<TMSizeX;x++)
if (TileMap1[y][x]==TC_TREE)
if (IsTopLeft(y,x))
{

TileMap2[y][x]=TILE_TREE;
TileMap2[y][x+1]=TILE_TREE+1;
TileMap2[y+1][x]=TILE_TREE+16;
TileMap2[y+1][x+1]=TILE_TREE+16+1;

}

// ***** TC_GRASS *****


for (int y=0;y<TMSizeY;y++)
for (int x=0;x<TMSizeX;x++)
if (TileMap1[y][x]==TC_GRASS)
if (IsTopLeft(y,x))
{

byte tn = TILE_GRASS_INDEX+random(TILE_GRASS_COUNT);

int x1=x;
int y1=y;
int x2=0;
int y2=0;

GetBottomRight(x1,y1,&x2,&y2);

for (int yy=y1;yy<=y2;yy++)
for (int xx=x1;xx<=x2;xx++)
if (TileMap1[yy][xx]==TC_GRASS)
TileMap2[yy][xx]=tn;

}


// ***** TC_PAVING *****


for (int y=0;y<TMSizeY;y++)
for (int x=0;x<TMSizeX;x++)
if (TileMap1[y][x]==TC_PAVING)
if (IsTopLeft(y,x))
{

byte tn = TILE_PAVING_INDEX+random(TILE_PAVING_COUNT);

int x1=x;
int y1=y;
int x2=0;
int y2=0;

GetBottomRight(x1,y1,&x2,&y2);

for (int yy=y1;yy<=y2;yy++)
for (int xx=x1;xx<=x2;xx++)
if (TileMap1[yy][xx]==TC_PAVING)
TileMap2[yy][xx]=tn;

}



// ***** TC_BUILDING *****


for (int y=0;y<TMSizeY;y++)
for (int x=0;x<TMSizeX;x++)
if (TileMap1[y][x]==TC_BUILDING)
if (IsTopLeft(y,x))
{

byte tnb=TILE_BB_INDEX+8*random(TILE_COUNT_BB);
byte tni=TILE_BI_INDEX+random(TILE_COUNT_BI);

int x1=x;
int y1=y;
int x2=0;
int y2=0;

GetBottomRight(x1,y1,&x2,&y2);

for (int yy=y1;yy<=y2;yy++)
for (int xx=x1;xx<=x2;xx++)
{


int u = (yy==y1);
int r = (xx==x2);
int d = (yy==y2);
int l = (xx==x1);


byte t=8;

     if (u==1 && d==0 && r==0 && l==1) t=0;
else if (u==1 && d==0 && r==0 && l==0) t=1;
else if (u==1 && d==0 && r==1 && l==0) t=2;
else if (u==0 && d==0 && r==0 && l==1) t=3;
else if (u==0 && d==0 && r==1 && l==0) t=4;
else if (u==0 && d==1 && r==0 && l==1) t=5;
else if (u==0 && d==1 && r==0 && l==0) t=6;
else if (u==0 && d==1 && r==1 && l==0) t=7;

if (t==8)
TileMap2[yy][xx]=tni;
else
TileMap2[yy][xx]=tnb+t;


}

}


// ***** TC_SIDEWALK *****

for (int y=0;y<TMSizeY;y++)
for (int x=0;x<TMSizeX;x++)
if (TileMap1[y][x]==TC_SIDEWALK)
{

int u = (y>0 && IsTileSideWalk(TileMap1[y-1][x]));
int r = (x<(TMSizeX-1) && IsTileSideWalk(TileMap1[y][x+1]));
int d = (y<(TMSizeY-1) && IsTileSideWalk(TileMap1[y+1][x]));
int l = (x>0 && IsTileSideWalk(TileMap1[y][x-1]));

byte t=8;

     if (u==1 && d==0 && r==0 && l==1) t=0;
else if (u==1 && d==0 && r==0 && l==0) t=1;
else if (u==1 && d==0 && r==1 && l==0) t=2;
else if (u==0 && d==0 && r==0 && l==1) t=3;
else if (u==0 && d==0 && r==1 && l==0) t=4;
else if (u==0 && d==1 && r==0 && l==1) t=5;
else if (u==0 && d==1 && r==0 && l==0) t=6;
else if (u==0 && d==1 && r==1 && l==0) t=7;

if (t!=8)
TileMap2[y][x]=(TILE_SIDEWALK+t);

}

// ***** TC_STREET *****


/*

streets ways :

1 :

none

2 :

<-
->

---------------------
- - - - - - - - - - -
---------------------

3 :

<-
->
->

---------------------
---------------------
- - - - - - - - - - -
---------------------

4 :

<-
<-
->
->

---------------------
- - - - - - - - - - -
---------------------
- - - - - - - - - - -
---------------------

*/




for (int y=0;y<TMSizeY;y++)
for (int x=0;x<TMSizeX;x++)
if (TileMap1[y][x]==TC_STREET)
if (IsTopLeft(y,x))
{

int x1=x;
int y1=y;
int x2=0;
int y2=0;

GetBottomRight(x1,y1,&x2,&y2);

// size

int sx=x2-x1+1;
int sy=y2-y1+1;

// ways

int wu = (TileMap1[y1-1][x1]==TC_CROSSROADS);
int wd = (TileMap1[y2+1][x1]==TC_CROSSROADS);
int wl = (TileMap1[y1][x1-1]==TC_CROSSROADS);
int wr = (TileMap1[y1][x2+1]==TC_CROSSROADS);

// vert / horiz

int sh = (wl || wr);
int sv = (wu || wd);


for (int yy=y1;yy<=y2;yy++)
for (int xx=x1;xx<=x2;xx++)
{

byte tn=0;

if (sh)
{

int m2=((xx&1)==0);
int rm=yy-y1;

if (sy==1)
tn=9;
else if (sy==2)
tn=(m2?(rm==0?4:1):(rm==0?0:1));
else if (sy==3)
tn=(m2?(rm==0?4:rm==1?5:1):(rm==0?4:rm==1?1:1));
else if (sy==4)
tn=(m2?(rm==0?4:rm==1?4:rm==2?5:1):(rm==0?0:rm==1?4:rm==2?1:1));

}
else if (sv)
{

int m2=((yy&1)==0);
int rm=xx-x1;

if (sx==1)
tn=9;
else if (sx==2)
tn=(m2?(rm==0?6:3):(rm==0?2:3));
else if (sx==3)
tn=(m2?(rm==0?6:rm==1?7:3):(rm==0?6:rm==1?3:3));
else if (sx==4)
tn=(m2?(rm==0?6:rm==1?6:rm==2?7:3):(rm==0?2:rm==1?6:rm==2?3:3));

}

TileMap2[yy][xx]=TILE_STREET_INDEX+tn;


}






}




}
//---------------------------------------------------------------------------

void __fastcall TMainWnd::SaveToBinary1Click(TObject *Sender)
{

if (SaveDialog1->Execute())
{

// bitmap -> tilemap1
Step1Execute(NULL);

// tilemap1 -> tilemap2

//memcpy(TileMap2,TileMap1,256*256);
Step2Execute(NULL);


// tilemap2 -> file

AnsiString FileName= ChangeFileExt(SaveDialog1->FileName,".bin");

int fh = FileCreate(FileName);

FileWrite(fh,&TMSizeY,1);
FileWrite(fh,&TMSizeX,1);

for (int y=0;y<TMSizeY;y++)
FileWrite(fh,&TileMap2[y][0],TMSizeX);

FileClose(fh);

AnsiString str;

str.sprintf("File saved : %s",FileName);
Memo1->Lines->Add(str);

}



}
//---------------------------------------------------------------------------

