;-------------------------------------------
; 4 - level grayscale titlescreen displayer
; Picture is compressed with RLE
; Picture is stored as binary file
; By Matt Johnson, Assembly Coder's Zenith
;-------------------------------------------

#include "ti86asm.inc"

.org _asm_exec_ram

 call _clrLCD				; clear the screen
 call _flushallmenus		; close any open menus
 call _runindicoff			; turn off the run indicator

 ; Copy planes to appropiate areas

 ld hl,Pic+715 			; point to RLE picture to display
 ld de,$fc00				; display picture in video memory
 call DispRLE				; decode and display the picture

 ld hl,Pic+0				; point to RLE picture to display
 ld de,$ca00				; display picture in video memory
 call DispRLE				; decode and display the picture

Loop:

 ld a,$0a
 out (0),a

 halt

 ld a,$3c
 out (0),a

 halt
 halt

 ld a,%00111111
 out (1),a
 in a,(1)
 bit 5,a
 jr z, Finish

 jp Loop

Finish:

 ld a,$3C
 out (0),a	; screen now shows $100*($C0+$3C) = $FC00, normal

 ret

#include "rle.asm"			; include RLE picture displayer

Pic:
.incbin "2levRLE.bin"	    ; RLE compressed, 4-shades
							; Image Studio told me the two ending
							; byte offsets for each layer

.end
