; Displays a simple monochrome RLE compressed picture, with the picture as a binary file

#include "ti86asm.inc"

.org _asm_exec_ram

 call _clrLCD				; clear the screen
 call _flushallmenus		; close any open menus
 call _runindicoff			; turn off the run indicator

 ld hl,Pic					; point to RLE picture to display
 ld de,$fc00				; display picture in video memory
 call DispRLE				; decode and display the picture

 call _getkey				; wait for a key to be pressed
 call _clrLCD				; clear the display
 ret 						; return to TI-OS or a shell

#include "rle.asm"			; include RLE picture displayer

Pic:
.incbin "1LevRLE.bin"		; monochrome picture

.end
