;-------------------------------------------
; 8 - level grayscale titlescreen displayer
; Picture is compressed with RLE
; Picture is stored as binary file
; By Matt Johnson, Assembly Coder's Zenith
;-------------------------------------------

#include "ti86asm.inc"

.org _asm_exec_ram

 call _clrLCD				; clear the screen
 call _flushallmenus		; close any open menus
 call _runindicoff			; turn off the run indicator

 ; Copy planes to appropiate areas

 ld hl,Pic+2048			; point to RLE picture to display
 ld de,$fc00
 ld bc,1024
 ldir

 ld hl, Pic+1024
 ld de,$ca00				; point to RLE picture to display
 ld bc,1024
 ldir

 ld hl,Pic
 ld de,$f700
 ld bc,1024
 ldir

Loop:

 ld a,$37
 out (0),a

 halt

 ld a,$0A
 out (0),a

 halt
 halt

 ld a,$3C
 out (0),a

; check if CLEAR is pressed
 ld a,%00111111
 out (1),a
 in a,(1)
 bit 5,a
 jr z, Finish

 halt
 halt
 halt
 halt

 jp Loop

Finish:

 ld a,$3C
 out (0),a	; screen now shows $100*($C0+$3C) = $FC00, normal

 ret

Pic:
.incbin "3lev.bin"


.end
