#include "stdafx.h"
#include "z80table.h"

#include "func.h"



void z80Table::readfile (ifstream& fin)
{
	int fieldnum;
	string line;
	string field;
	uchar instH,instL;
	z80Inst i;
	while (fin.good())
	{
		i=z80Inst();
		getline(fin,line);
		fieldnum=0;
		if (line.size()>3)
		{
			switch (line[0])
			{
			case '/':
			case '"':
				break;
			default:
				{
					int pos=0;
					int fieldnum=0;
					string field;
					while (fieldnum<8 && getField(pos,line,field))
					{
						switch (fieldnum)
						{
						case 0: //name
							i.name=field;
							break;
						case 1: //args
							{
								if (field[0]!='"')
								{
									int argpos=0;
									string arg;
									while (getArg(argpos,field,arg))
									{
										i.args.push_back(arg);
									}
								}
							}
							break;
						case 2: //instruction code
							{
								hexto2bytes(field,instH,instL);
							}
							break;
						case 3: //size
							{
								i.size=str2int(field);
							}
							break;
						case 4: //special
							{
								if (!field.compare("NOP"))
								{
									i.special=NOP;
								}
								if (!field.compare("ZBIT"))
								{
									i.special=ZBIT;
								}
								if (!field.compare("ZIX"))
								{
									i.special=ZIX;
								}
								if (!field.compare("R1"))
								{
									i.special=R1;
								}
							}
							break;
						case 6: //shift
							{
								i.shift=str2int(field);
							}
							break;
						case 7: //or
							{
								uchar h,l;
								hexto2bytes(field,h,l);
								i.or=(h<<8)+l;
							}
							break;
						}
						fieldnum++;
					}
					switch (instH)
					{
						//CB DD ED FD DDCB FDCB
					case 0xCB:
						tabCB[instL]=i;
						break;
					case 0xDD:
						if (instL==0xCB)
							tabDDCB[i.or&0xFF]=i;
						else
							tabDD[instL]=i;
						break;
					case 0xED:
						tabED[instL]=i;
						break;
					case 0xFD:
						if (instL==0xCB)
							tabFDCB[i.or&0xFF]=i;
						else
							tabFD[instL]=i;
						break;
					case 0:
						tab[instL]=i;
						break;
					default:
						throw logic_error("BAD THING");
						break;
					}
				}
			}
		}
	}
}


const z80Inst* z80Table::execute(const uchar* pc)
{
	z80Inst *inst;
	int numbyte=2;
	uchar bytenum;
	//CB DD ED FD DDCB FDCB
	switch (pc[0])
	{
		case 0xCB:
			bytenum=pc[1];
			if (bytenum&0xC0)
			{
				bytenum&=0xC7;  //set, res, bit...
			}
			inst=&tabCB[bytenum];
			break;
		case 0xDD:
			if (pc[1]==0xCB)
			{
				numbyte=3;
				bytenum=pc[3];
				if (bytenum&0xC0)
					bytenum&=0xC7;  //set, res, bit...
				else
					bytenum&=0x3F;  //shifts and rotations
				inst=&tabDDCB[bytenum];
			}
			else
				inst=&tabDD[pc[1]];
			break;
		case 0xED:
			inst=&tabED[pc[1]];
			break;
		case 0xFD:
			if (pc[1]==0xCB)
			{
				numbyte=3;
				uchar bytenum=pc[3];
				if (bytenum&0xC0)
					bytenum&=0xC7;  //set, res, bit...
				else
					bytenum&=0x3F;  //shifts and rotations
				inst=&tabFDCB[bytenum];
			}
			else
				inst=&tabFD[pc[1]];
			break;
		default:
			inst=&tab[pc[0]];
			numbyte=1;
	}
	inst->numbyte=numbyte;

	if (inst->special==DB)
	{
		inst->size=numbyte;
	}

	return inst;
}
