#ifndef __Z80PROJECT_H_
#define __Z80PROJECT_H_

#include "z80table.h"
#include "z80memory.h"
#include "equates.h"

const int DATA_PER_LINE = 16;

class z80Project
{
	z80Table tab;
	Equates bcalls;
	ushort start,end;
public:
	z80Memory mem;
	Equates equ;
	bool lowercase;
	bool hidedata;
	bool listfile;
	bool rom_call;
	u16 romcall_addr;
	z80Project()
	{
		lowercase=true;
		hidedata=false;
		listfile=false;
		rom_call=false;
		romcall_addr=0;
	}
	bool addlabel(ushort addr);
	void addlabel(ushort addr,const string& name);
	bool loadtable(const char *filename);
	bool loadequates(const char *filename);
	bool loadbcalls(const char *filename);
	void loadvector(vector<uchar> &v, ushort newstart=0x9D93);
	bool loadprogram(const char *filename, ushort newstart = 0x9D93);
	void findcode(ushort pc);
	void findlabels(ushort pc);
	void output(ostream& out);
	void outcode(ostream& out);
	void savefile(const char *filename);
	void findtext();
	void findtext(u16 startaddr, u16 nextaddr=0xFFFF);
	void terminate_data(int currentdatatype,ostream& out);
	void start_data(int lastdatatype,int currentdatatype,int consecutivedata,u16 pc,ostream& out);
	void disp_data(int lastdatatype,int currentdatatype,int consecutivedata,u16 &pc,ostream& out);
	int datatype(int pc);
	bool updatelabel(ushort addr);

};


#endif
