#include "stdafx.h"
#include "z80project.h"

#include "func.h"

bool z80Project::loadtable(const char *filename)
{
	ifstream fin(filename);
	if (fin.good())
	{
		tab.readfile(fin);
		fin.close();
		fin.clear();
		return true;
	}
	else
	{
		fin.close();
		fin.clear();
		return false;
	}
}
void readequates(Equates& e, istream& fin)
{
	int fieldnum;
	string line;
	string field;
	string name;
	ushort addr;
	while (fin.good())
	{
		getline(fin,line);
		fieldnum=0;
		if (line.size()>3)
		{
			switch (line[0])
			{
			case ';':
				break;
			default:
				{
					int pos=0;
					int fieldnum=0;
					string field;
					while (fieldnum<3 && getField(pos,line,field))
					{
						switch (fieldnum)
						{
						case 0: //name
							name=field;
							break;
						case 1: //separator
							break;
						case 2:
							addr=hextoushort(field);
							break;
						}
						fieldnum++;
					}
					if (fieldnum==3)
					{
						e.add(Equate(addr,name,false,true));
					}
				}
			}
		}
	}
}


bool loadequates(Equates& e,const char* filename)
{
	ifstream fin(filename);
	if (fin.good())
	{
		readequates(e,fin);
		fin.close();
		fin.clear();
		return true;
	}
	else
	{
		fin.close();
		fin.clear();
		return false;
	}

}
bool z80Project::loadequates(const char *filename)
{
	return ::loadequates(equ,filename);
}
bool z80Project::loadbcalls(const char *filename)
{
	return ::loadequates(bcalls,filename);
}
bool z80Project::loadprogram(const char *filename,ushort newstart)
{
	bool success=false;
	ifstream fin;
	int filesize;
	fin.open(filename,ios::binary);
	if (fin.good())
	{
		fin.seekg(0,ios::end);
		filesize=fin.tellg();
		fin.seekg(0,ios::beg);
		start=newstart;
		mem.resize(start,filesize);

		end=start+filesize;
		equ.prog_end=end;

		fin.read((char*)mem.getFirstByte(),filesize);
		success=true;
	}
	else
	{
		success=false;
	}
	fin.close();
	fin.clear();
	return success;

}
void z80Project::loadvector(vector<uchar> &v,ushort newstart)
{
	start=newstart;
	end=start+v.size();
	equ.prog_end=end;
	mem.stealvector(v);
	mem.setorg(newstart);
}
void z80Project::findcode(ushort pc)
{
	do
	{
		if (mem.isCode(pc) || pc<start || pc>=end)
		{
			return;
		}
		ushort oldpc=pc;
		ushort destaddr;
		const z80Inst *i;
		i=tab.execute(&mem[pc]);
		mem.markCode(pc,i->size);
		pc+=i->size;
		if (!i->name.compare("RET") && i->args.size()==0)
		{
			return;
		}
		else if (!i->name.compare("RETI") || !i->name.compare("RETN"))
		{
			return;
		}
		else if (!i->name.compare("JP"))
		{
			destaddr=mem.getWord(oldpc+1);
			if (i->args.size()==1)
				pc=destaddr;
			else
				findcode(destaddr);
		}
		else if (!i->name.compare("JR"))
		{
			destaddr=pc+mem.getSignedByte(oldpc+1);
			if (i->args.size()==1)
				pc=destaddr;
			else
				findcode(destaddr);
		}
		else if (!i->name.compare("CALL"))
		{
			destaddr=mem.getWord(oldpc+1);
			//rom_call hack
			if (!(rom_call && destaddr==romcall_addr) )
			{
				findcode(destaddr);
			}
			else
			{
				mem.markAddr(pc);
				mem.markData(pc,2);
				pc+=2;
			}
		}
		else if (!i->name.compare("DJNZ"))
		{
			destaddr=pc+mem.getSignedByte(oldpc+1);
			findcode(destaddr);
		}
	} while (1);
}
bool z80Project::addlabel(ushort addr)
{
	if (!equ.isdefined(addr) && addr>=start && addr<end)
	{
		if (mem.isData(addr))
		{
			equ.add(Equate(addr,string("data")+inttohex(addr),true));
		} else {
			equ.add(Equate(addr,string("l")+inttohex(addr),true));
		}
		return true;
	}
	return false;
}

bool z80Project::updatelabel(ushort addr)
{
	if (equ.isdefined(addr) && addr>=start && addr<end && equ.withaddr(addr).automade)
	{
		if (mem.isText(addr))
		{
			equ.withaddr(addr).name=string("text")+inttohex(addr);
		}
		return true;
	}
	return false;
}


void z80Project::addlabel(ushort addr, const string& name)
{
	equ.add(Equate(addr,name));
}

void z80Project::findlabels(ushort pc)
{
	addlabel(pc);
	do
	{
		if (mem.isVisited(pc) || pc<start || pc>=end)
		{
			return;
		}
		ushort oldpc=pc;
		ushort destaddr;
		const z80Inst *i;
		i=tab.execute(&mem[pc]);
		mem.markVisited(pc,i->size);
		pc+=i->size;
		//all 16 bit LD's become labels
		if (!i->name.compare("LD"))
		{
			if (i->numbyte>1)
			{
				if (i->size>3 && i->special!=ZIX)
				{
					destaddr=mem.getWord(oldpc+2);
					addlabel(destaddr);
				}
			} else {
				if (i->size>2)
				{
					destaddr=mem.getWord(oldpc+1);
					addlabel(destaddr);
				}
			}
		}
		else if (!i->name.compare("RET") && i->args.size()==0)
		{
			return;
		}
		else if (!i->name.compare("RETI") || !i->name.compare("RETN"))
		{
			return;
		}
		else if (!i->name.compare("JP"))
		{
			destaddr=mem.getWord(oldpc+1);
			if (i->args.size()==1)
				addlabel(pc=destaddr);
			else
				findlabels(destaddr);
		}
		else if (!i->name.compare("JR"))
		{
			destaddr=pc+mem.getSignedByte(oldpc+1);
			if (i->args.size()==1)
				addlabel(pc=destaddr);
			else
				findlabels(destaddr);
		}
		else if (!i->name.compare("CALL"))
		{
			destaddr=mem.getWord(oldpc+1);
			//rom_call hack
			if (!(rom_call && destaddr==romcall_addr))
			{
				findlabels(destaddr);
			}
			else
			{
				pc+=2;
			}
		}
		else if (!i->name.compare("DJNZ"))
		{
			destaddr=pc+mem.getSignedByte(oldpc+1);
			findlabels(destaddr);
		}
	} while (1);	
}

void z80Project::terminate_data(int currentdatatype,ostream& out)
{
	//0=code
	//1=hex data
	//2=string
	//3=binary
	//4=decimal
	if (currentdatatype==2)
		out << "\"";
}
void z80Project::start_data(int lastdatatype,int currentdatatype,int consecutivedata,u16 pc,ostream& out)
{
	//0=code
	//1=hex data
	//2=string
	//3=binary
	//4=decimal
	if (consecutivedata==0)
	{
		if (listfile)
		{
			out << " $"<<hex4(pc)<<": ";
		}
	}
	switch (currentdatatype)
	{
	case 0:
		break; //do nothing
	case 1:
	case 3:
	case 4:
		if (consecutivedata==0)
		{
			out << " .db ";
		}
		else
		{
			out << ",";
		}		
		break;
	case 5:
		if (consecutivedata==0)
		{
			out << " .dw ";
		}
		else
		{
			out << ",";
		}		
		break;
	case 2:
		if (consecutivedata==0)
		{
			out << " .db \"";
		}
		else
		{
			if (lastdatatype!=currentdatatype)
			{
				out << ",\"";
			}
		}

		break;
	}
}
void z80Project::disp_data(int lastdatatype,int currentdatatype,int consecutivedata,u16 &pc,ostream& out)
{
	//0=code
	//1=hex data
	//2=string
	//3=binary
	//4=decimal
	//5=address
	uchar data=mem[pc];
	int bit;
	switch (currentdatatype)
	{
	case 0:
		break; //do nothing
	case 1:
		out << "$" << hex2(data);
		//out << "0" << hex2(data) << "h";
		break;
	case 2:
		switch (data)
		{
		case '\"':
			out << "\\\"";
			break;
		case '\\':
			out << "\\\\";
			break;
		default:
			out << data;
		}
		break;
	case 3:
		out << "%";
		for (bit=0x80;bit!=0;bit>>=1)
		{
			if (data&bit)
			{
				out << "1";
			}
			else
			{
				out << "0";
			}
		}
		//out << "b";
		break;
	case 4:
		out << int(mem[pc]);
		break;
	case 5:
		out << equ.lookup(mem.getWord(pc));
		pc++;
		break;
	}
}

int z80Project::datatype(int pc)
{
	if (mem.isData(pc))
	{
		if (mem.isText(pc))
			return 2;
		if (mem.isAddr(pc))
			return 5;
		return 1;
	}
	else
	{
		return 0;
	}
	
}


void z80Project::output(ostream& out)
{
	
	u16 pc,oldpc;
	u16 temppc;
	int consecutivedata=0; //number of consecutive data bytes
	int currentdatatype=0;
	int lastdatatype=0;

#define terminatedata() terminate_data(currentdatatype,out);
#define terminateline() terminatedata(); out << endl; consecutivedata=0;
#define startdata() start_data(lastdatatype,currentdatatype,consecutivedata,pc,out);
#define dispdata() disp_data(lastdatatype,currentdatatype,consecutivedata,pc,out);

	const z80Inst *i;

	pc=start;
	oldpc=start-1;
	while (pc<end)
	{
		for (temppc=oldpc+1;temppc<=pc;temppc++)
		{
			if (equ.isdefined(temppc))
			{
				if (!(hidedata && mem.isData(pc)))
				{
					if (mem.isData(oldpc))
					{
						terminateline();
					}
					out <<  endl;
					if (temppc==pc)
					{
						out << equ.lookup(pc) << ":" << endl;
					}
					else
					{
						out << equ.lookup(temppc) << " = $-" << pc-temppc << endl;
					}
				}
			}
		}
		if (mem.isData(pc))
		{
			if (hidedata)
			{
				oldpc=pc;
				pc++;
			}
			else
			{
				if (currentdatatype!=datatype(pc))
				{
					if (currentdatatype==2)
					{
						consecutivedata=DATA_PER_LINE-1;
					}
					if (consecutivedata==DATA_PER_LINE)
					{
						terminateline();
					}
					else
					{
						terminatedata();
					}
					currentdatatype=datatype(pc);
				}
				if (consecutivedata>=DATA_PER_LINE && currentdatatype!=2)
				{
					terminateline();
				}
				startdata();
				dispdata();
				consecutivedata++;
				oldpc=pc;
				pc++;
				lastdatatype=currentdatatype;
			}
		}
		else
		{
			if (consecutivedata)
			{
				terminateline();
			}
			currentdatatype=0;
			i=tab.execute(&mem[pc]);
			oldpc=pc;
			pc+=i->size;
			
			if (i->special==DB)
			{
				pc=oldpc;
				mem.markData(pc,i->size);
				out << " ;Illegal instruction" << endl;
			}
			else
			{
				if (listfile)
				{
					out << " $"<<hex4(oldpc)<<":  ";
					ushort temppc;
					for (temppc=oldpc;temppc<pc;temppc++)
					{
						out << hex2(mem[temppc]) << " ";
					}
					for (temppc=pc;temppc<oldpc+4;temppc++)
					{
						out << "   ";
					}					
				}
				//ROM_CALL hack
				if ((rom_call && mem.getWord(oldpc+1)==romcall_addr && !(i->name.compare("CALL"))))
				{
					out << " ROM_CALL(" << equ.lookup(mem.getWord(oldpc+3)) <<")" <<endl;
					pc+=2;
				}
				else
				{

					string arg;
					if (!lowercase)
						arg=toUpper(i->name);
					else
						arg=toLower(i->name);
					out << " " << arg;
					int pos=0;
					if (i->args.size())
					{
						out << " ";
					}
					while (pos<i->args.size())
					{
						if (!lowercase)
							arg=toUpper(i->args[pos]);
						else
							arg=toLower(i->args[pos]);
						int starpos=arg.find("*");
						if (starpos!=-1)
						{
							int datasize;
							int dataaddr;
							ushort worddata=0x1234;
							uchar bytedata;
							signed char signedbytedata;
							signed char ixoffset;

	//						if (!i->name.compare("SRL") && i->special==ZIX)
	//						{
	//							out.flush();
	//						}

							string blank;
							datasize=i->size-i->numbyte;
							dataaddr=oldpc+i->numbyte;

							if (i->special==ZIX || (i->special==ZBIT && (mem[oldpc]==0xFD || mem[oldpc]==0xDD)))
							{
								datasize--;
								if (i->special==ZBIT)
								{
									dataaddr--;
								}
								if (i->size==4 && i->special==ZIX && datasize==0)
								{
									dataaddr--;
								}
								ixoffset=mem.getSignedByte(dataaddr);
								dataaddr++;
							}
							if (datasize==1)
							{
								bytedata=mem.getByte(dataaddr);
								signedbytedata=(signed char)bytedata;
							}
							else if (datasize==2)
							{
								worddata=mem.getWord(dataaddr);
							}
							else if (datasize==3)
							{
								cerr << "Weirdness: Instruction has a data size of 3?" << endl;
	//							throw logic_error("data size 3?");
							}
							
							if (!i->args[pos].compare("(IX*)")||!i->args[pos].compare("(IY*)"))
							{
								if (i->special==ZIX || (i->special==ZBIT && (mem[oldpc]==0xFD || mem[oldpc]==0xDD)))
								{
									if (ixoffset>=0)
									{
										blank="+";
									}
									blank+=inttostring(ixoffset);
								}
								else
								{
									cerr << "Weirdness: ZIX instruction doesn't have IX in it!" << endl;
								}
							}
							else if (!i->name.compare("B_CALL"))
							{
								blank=bcalls.lookup(worddata);
							}
							else if (i->special==R1)
							{
								worddata=pc+signedbytedata;
								blank=equ.lookup(worddata);
							}
							else if (i->special==ZBIT)
							{
								if (i->size<=2)
								{
									dataaddr--;
								}
								bytedata=mem[dataaddr];
								bytedata&=0x38;
								bytedata>>=3;
								blank=inttostring(bytedata);
							}



							else if (!i->name.compare("LD"))
							{
								if (datasize==1)
								{
									blank="$";
									blank+=hex2(bytedata);
								}
								else if (datasize==2)
								{
									if (worddata<0x8000 && worddata<start || worddata>=0xFF00)
									{
										blank="$";
										blank+=inttohex(worddata);
									}
									else
									{
										blank=equ.lookup(worddata);
									}
								}
							}
							else  //general
							{
								if (datasize==1)
								{
									blank="$";
									blank+=hex2(bytedata);
								}
								else if (datasize==2)
								{
									blank=equ.lookup(worddata);
								}

							}
	//						else if (!i->name.compare("LD"))
	//						{




							
							
							
							//blank="foo";
							arg=arg.substr(0,starpos)+blank+arg.substr(starpos+1);
						}
						out << arg;
						pos++;
						if (pos!=i->args.size())
						{
							out << ",";
						}
					}
					out << endl;
				}

			}
		}
	}
	if (consecutivedata)
	{
		terminateline();
	}
}
void z80Project::outcode(ostream& out)
{
	
}
void z80Project::savefile(const char *filename)
{
	
}
void z80Project::findtext()
{
	int index;
	u16 startaddr,addr, nextaddr;
	for (index=0;index<equ.equates.size();index++)
	{
		addr=equ.equates[index].addr;
		if (index+1<equ.equates.size())
		{
			nextaddr=equ.equates[index+1].addr;
		}
		else
		{
			nextaddr=0xFFFF;
		}
		findtext(addr,nextaddr);
/*
		startaddr=addr;
		//crappy text finding algorithm!
		while (mem.inbounds(addr) && mem.isData(addr))// && addr<nextaddr)
		{
			if (mem[addr]==0 && addr>startaddr)
			{
				mem.markText(startaddr,addr-startaddr);
				updatelabel(startaddr);
				startaddr=addr+1;
				//break;
			}
			else if (mem[addr]<32 || mem[addr]>=128)
			{
				break;
			}
			addr++;
		}
*/
	}
}
void z80Project::findtext(u16 startaddr, u16 nextaddr)
{
	u16 addr;
	int index;
	addr=startaddr;
	//crappy text finding algorithm!
	while (mem.inbounds(addr) && mem.isData(addr))// && addr<nextaddr)
	{
		if (mem[addr]==0 && addr>startaddr)
		{
			mem.markText(startaddr,addr-startaddr);
			updatelabel(startaddr);
			startaddr=addr+1;
			//break;
		}
		else if (mem[addr]<32 || mem[addr]>=128)
		{
			break;
		}
		addr++;
	}
}
