#ifndef __Z80MEMORY_H_
#define __Z80MEMORY_H_

class z80Memory
{
	uchar* mem;
	uchar* codeflag;
	int lbound,size;
	void init0(int first, int last);
	void init0(int first=0);
public:
	z80Memory();
	z80Memory(int LBound,int MaxSize);
	void clear();
	void resize(int LBound,int MaxSize);
	bool testbit(int addr, uchar bit) const;
	bool isCode(int addr) const   { return  testbit(addr,1<<0); }
	bool isData(int addr) const   { return !testbit(addr,1<<0); }
	bool isText(int addr) const   { return  testbit(addr,1<<2); }
	bool isSprite(int addr) const { return  testbit(addr,1<<3); }
	bool isAddr(int addr) const   { return  testbit(addr,1<<4); }
	bool isVisited(int addr, uchar flag=1<<1) const {  return testbit(addr,flag);  }

//	uchar* detachmem();
//	void attachmem(uchar* newmem, int newsize);
//	uchar* detachcodeflag();
//	void attachcodeflag(uchar* newcodeflag, int newsize);
//	void clearcodeflag();
	void stealvector(vector<uchar> &v);
	void setorg(int newLbound);

	void markBits(int addr, int length=1, uchar flag=2);
	void unmarkBits(int addr, int length=1, uchar flag=2);

	void markCode(int addr, int length=1)      {   markBits(addr,length,0); }
	void markData(int addr, int length=1)      { unmarkBits(addr,length,0); }
	void markVisited(int addr, int length=1)   {   markBits(addr,length,1); }
	void unmarkVisited(int addr, int length=1) { unmarkBits(addr,length,1); }
	void markText(int addr, int length=1)      {   markBits(addr,length,2); }
	void unmarkText(int addr, int length=1)    { unmarkBits(addr,length,2); }
	void markSprite(int addr, int length=1)    {   markBits(addr,length,3); }
	void unmarkSprite(int addr, int length=1)  { unmarkBits(addr,length,3); }
	void markAddr(int addr, int length=2)	   {   markBits(addr,length,4); }
	void unmarkAddr(int addr, int length=2)	   { unmarkBits(addr,length,4); }

	uchar* getFirstByte();
	uchar& operator[](int addr);
	uchar operator[](int addr) const;
	ushort getWord(int addr) const;
	uchar getByte(int addr) const;
	signed char getSignedByte(int addr) const;

	bool inbounds(int addr) const;
};


#endif
