#include "stdafx.h"
#include "z80memory.h"

void z80Memory::init0(int first, int last)
{
	int index;
	for (index=first;index<last;index++)
	{
		mem[index]=0;
		codeflag[index]=0;
	}
}
void z80Memory::init0(int first)
{
	int index;
	for (index=first;index<size;index++)
	{
		mem[index]=0;
		codeflag[index]=0;
	}
}
z80Memory::z80Memory()
{
	mem=NULL;
	codeflag=NULL;
	lbound=0;size=0;
}
z80Memory::z80Memory(int LBound,int MaxSize)
{
	mem=new uchar[MaxSize];
	codeflag = new uchar[MaxSize];
	size=MaxSize;
	lbound=LBound;
	init0();
}
void z80Memory::clear()
{
	delete [] mem;
	delete [] codeflag;
	mem=NULL;
	codeflag=NULL;
	lbound=0;size=0;
}
void z80Memory::resize(int LBound,int MaxSize)
{
	uchar *newmem, *newcodeflag;
	//allocate
	newmem=new uchar[MaxSize];
	newcodeflag=new uchar[MaxSize];
	//copy
	int index;
	int oldsize=size;
	for (index=0;index<MaxSize&&index<size;index++)
	{
		newmem[index]=mem[index];
		newcodeflag[index]=codeflag[index];
	}
	//delete old, remap
	delete [] mem;
	delete [] codeflag;
	mem=newmem;
	codeflag=newcodeflag;
	size=MaxSize;
	lbound=LBound;
	init0(oldsize);
}

bool z80Memory::testbit(int addr, uchar bit) const
{
	if (inbounds(addr))
	{
		return (codeflag[addr-lbound]&bit)==bit;
	}
	else
	{
		return false;
	}	
}

/*
bool z80Memory::isVisited(int addr, uchar flag) const
{
	return testbit(addr,flag);
//
//	if (addr<lbound || addr>=size+lbound)
//	{
//		return false;
//	} else {
//		return (codeflag[addr-lbound]&flag)==2;
//	}
}
bool z80Memory::isCode(int addr) const
{
	if (addr<lbound || addr>=size+lbound)
	{
		return false;
	} else {
		return (codeflag[addr-lbound]&1)==1;
	}
}
bool z80Memory::isData(int addr) const
{
	return !isCode(addr);
}
*/




void z80Memory::markBits(int addr, int length, uchar flag)
{
	flag=1<<flag;
	int i;
	for (i=addr;i<addr+length;i++)
	{
		codeflag[i-lbound]|=flag;
	}
}
void z80Memory::unmarkBits(int addr, int length, uchar flag)
{
	flag=~(1<<flag);
	int i;
	for (i=addr;i<addr+length;i++)
	{
		codeflag[i-lbound]&=flag;
	}
}
uchar* z80Memory::getFirstByte()
{
	return mem;
}
uchar& z80Memory::operator[](int addr)
{
	static uchar junk;
	if (inbounds(addr))
	{
		return mem[addr-lbound];
	}
	else
	{
		return junk;
	}
}
uchar z80Memory::operator[](int addr) const
{
	if (inbounds(addr))
	{
		return mem[addr-lbound];
	}
	else
	{
		return 0xFF;
	}
}
ushort z80Memory::getWord(int addr) const
{
	return getByte(addr)+(getByte(addr+1)<<8);
}
uchar z80Memory::getByte(int addr) const
{
	return (*this)[addr];
}
signed char z80Memory::getSignedByte(int addr) const
{
	return static_cast<signed char>((*this)[addr]);
}

/*
uchar* z80Memory::detachmem()
{
	uchar* oldmem=mem;
	mem=NULL;
	if (!codeflag)
	{
        size=0;
	}
}

void z80Memory::attachmem(uchar* newmem, int newsize)
{
	delete [] mem;
	mem=newmem;
	if (size!=newsize)
	{

	
}

uchar* z80Memory::detachcodeflag()
{

}

void z80Memory::attachcodeflag(uchar* newcodeflag, int newsize)
{

}

void z80Memory::clearcodeflag()
{

}
*/


bool z80Memory::inbounds(int addr) const
{
	return (addr>=lbound && addr<size+lbound);
}

void z80Memory::stealvector(vector<uchar> &v)
{
	clear();
	vector <uchar> *temp;
	temp=new vector<uchar>;
	temp->swap(v);
	size=temp->size();
	mem=&(*temp)[0];
	codeflag=new uchar[size];
	if (codeflag)
	{
		memset(codeflag,0,size*sizeof(char));
	}
	free(temp);
}

void z80Memory::setorg(int newLbound)
{
	lbound=newLbound;
}

