#include "stdafx.h"
#include "progload.h"

bool findvec(const vector<uchar> &v, const char* str, int l)
{
	int x;
	if (l>v.size())
		return false;
	for (x=0;x<l;x++)
	{
		if (v[x]!=((uchar*)str)[x])
		{
			return false;
		}
	}
	return true;
}


int load83pfile(const char* filename, vector<Byte> &contents, char *progname)
//progname is 9 chars long
{
	int filesize;
	int progsize;
	int first;
	bool isBin=false;
	const int headsize=0x4A;
	char signiture[9];

	vector<Byte> filehead;

	ifstream fin;
	fin.open(filename,ios::in|ios::binary);
	if (!fin.good())
	{
		fin.close();
		return 0;
	}
	fin.seekg(0,ios::end);
	filesize=fin.tellg();
	fin.seekg(0,ios::beg);
	if (filesize<headsize)
	{
		if (filesize<4)
		{
			fin.close();
			return 0;
		}
		//file is too small
		isBin=true;
		//fin.close();
		//return 0;
	}
	else
	{
		//read file
		filehead.resize(headsize);
		fin.read((char*)&filehead[0],headsize);
		
		if (progname!=NULL)
		{
			strncpy(progname,(char*)&filehead[0x3C],8);
			progname[8]='\0';
		}
		
		strncpy(signiture,(char*)&filehead[0x00],8);
		signiture[8]='\0';

		if (filehead[0x44]==0 && (filehead[0x45] ==0 || filehead[0x45]==0x80))
		{
			first=0x4A;
		}
		else
		{
			first=0x48;
		}
		if ((strcmp(signiture,"**TI83**")==0
			|| strcmp(signiture,"**TI82**")==0
			|| strcmp(signiture,"**TI83F*")==0
			|| strcmp(signiture,"**TI83P*")==0) )
		{
			isBin=false;
		}
		else
		{
			isBin=true;
		}
	}
	if (!isBin)
	{
		progsize=filesize-2-first;
	}
	else
	{
		first=0x00;
		progsize=filesize;
	}

	filehead.clear();
	if (progsize>0)
	{
		contents.resize(progsize);
		fin.seekg(first,ios::beg);
		fin.read((char*)&contents[0],progsize);
	}
	fin.close();
	return 1;
}

bool loadprog(const char* filename, z80Project &p)
{
	vector <uchar> progcontent;
	if (!load83pfile(filename,progcontent,NULL))
	{
		return false;
	}
	if (progcontent.size()>4)
	{
		if(findvec(progcontent,"\xBB\x6D\xC9\x30",4) 
			|| findvec(progcontent,"\xBB\x6D\xAF\x30",4)
			|| findvec(progcontent,"\xBB\x06\xC9\x30",4)
			|| findvec(progcontent,"\xBB\x06\xAF\x30",4) ) //ion 83+
		{
			cerr << "Input file " << filename << " is a TI-83+ Ion program."<<endl;
			loadion83p(p,progcontent);
		}
		else if(findvec(progcontent,"\xC9\x30",2)
			|| findvec(progcontent,"\xAF\x30",2)) //ion 83
		{
			cerr << "Input file " << filename << " is a TI-83 Ion program."<<endl;
			loadion83(p,progcontent);
		}
		else if(findvec(progcontent,"\x00\x18",2)) //ASHELL 83
		{
			cerr << "Input file " << filename << " is a TI-83 AShell program."<<endl;
			loadashell83(p,progcontent);
		}
		else if(findvec(progcontent,"\x3F\x18",2)
			|| findvec(progcontent,"\x3F\x28",2)
			|| findvec(progcontent,"\xAF\x18",2)
			|| findvec(progcontent,"\xAF\x28",2)) //SOS 83
		{
			cerr << "Input file " << filename << " is a TI-83 SOS program (disassembler has incomplete lib support)"<<endl;
			loadsos83(p,progcontent);
		}
		else if(findvec(progcontent,"\xE7""9_[V?\x01\x30",8)) //Venus 83
		{
			cerr << "Input file " << filename << " is a TI-83 Venus program."<<endl;
			loadvenus83(p,progcontent);
		}
		else if(findvec(progcontent,"\xD5\x00\x11",3)) //CrASH 82
		{
			cerr << "Input file " << filename << " is a TI-82 CrASH program."<<endl;
			loadcrash82(p,progcontent);
		}
		else if(findvec(progcontent,"\xD5\x00\xA0",3)) //ACE 82
		{
			cerr << "Input file " << filename << " is a TI-82 ACE program."<<endl;
			loadace82(p,progcontent);
		}
		else if(findvec(progcontent,"\xD9\x00\x30",3)) //ASH 82
		{
			cerr << "Input file " << filename << " is a TI-82 ASH program."<<endl;
			loadcrash82(p,progcontent);
		}
//		else if(findvec(progcontent,"SNG",3)) //SNG 82
//		{
//			cerr << "Input file " << filename << " is a TI-82 SNG program."<<endl;
//			loadsng82(p,progcontent);
//		}
		else if(findvec(progcontent,"\xBB\x6D\xC9\x01",4)
			|| findvec(progcontent,"\xBB\x6D\xC9\x01",4))//mirage 83+
		{
			cerr << "Input file " << filename << " is a TI-83+ MirageOS program."<<endl;
			loadmirage83p(p,progcontent);
		}
		else if(findvec(progcontent,"\xBB\x6D",2)) //Nostub 83+
		{
			cerr << "Input file " << filename << " is a TI-83+ Asm( program."<<endl;
			loadnostub83p(p,progcontent);
		}
		else //nostub 83
		{
			cerr << "Input file " << filename << " is a squished TI-83 Asm program."<<endl;
			loadnostub83(p,progcontent);
		}
	}
	return true;
}

void loadion83p(z80Project &p, vector<uchar> &v)
{
	int i;
	u16 mem_start=0x9D93;
	u16 startaddr;
	if (options.useloadaddr)
	{
		mem_start=options.loadaddr;
	}
	p.loadtable("bcalltab.dat");  //support b_call
	p.loadequates("ti83plus.dat");
	p.loadequates("ionmirage.dat");
	p.loadbcalls("ti83pbcall.dat");

	p.loadvector(v,mem_start);

	p.mem.markCode(0x9D95,3);
	p.mem.markData(0x9D93,2);
	startaddr=0x9D98+p.mem[0x9D97];
	p.addlabel(startaddr,"lblStart");
	p.addlabel(0x9D98,"tTitle");
	
	for (i=0;i<options.addequatelist.size();i++)
	{
		p.addlabel(options.addequatelist[i].addr,options.addequatelist[i].name);
	}
	options.addequatelist.clear();

	p.findcode(startaddr);
	p.findlabels(startaddr);
	for (i=0;i<options.findcodelist.size();i++)
	{
		p.findcode(options.findcodelist[i]);
		p.findlabels(options.findcodelist[i]);
	}
	p.findtext();
	for (i=0;i<options.findtextlist.size();i++)
	{
		p.findtext(options.findtextlist[i]);
	}
}

void loadnostub83p(z80Project &p, vector<uchar> &v)
{
	int i;
	u16 mem_start=0x9D93;
	u16 startaddr;
	if (options.useloadaddr)
	{
		mem_start=options.loadaddr;
	}
	p.loadtable("bcalltab.dat");  //support b_call
	p.loadequates("ti83plus.dat");
	p.loadbcalls("ti83pbcall.dat");

	p.loadvector(v,mem_start);

	startaddr=0x9D95;
	p.addlabel(startaddr,"lblStart");

	for (i=0;i<options.addequatelist.size();i++)
	{
		p.addlabel(options.addequatelist[i].addr,options.addequatelist[i].name);
	}
	options.addequatelist.clear();
	
	p.findcode(startaddr);
	p.findlabels(startaddr);
	for (i=0;i<options.findcodelist.size();i++)
	{
		p.findcode(options.findcodelist[i]);
		p.findlabels(options.findcodelist[i]);
	}
	p.findtext();
	for (i=0;i<options.findtextlist.size();i++)
	{
		p.findtext(options.findtextlist[i]);
	}
}

void loadmirage83p(z80Project &p, vector<uchar> &v)
{
	int i;
	u16 mem_start=0x9D93;
	u16 startaddr;
	if (options.useloadaddr)
	{
		mem_start=options.loadaddr;
	}
	p.loadtable("bcalltab.dat");  //support b_call
	p.loadequates("ti83plus.dat");
	p.loadequates("ionmirage.dat");
	p.loadbcalls("ti83pbcall.dat");

	p.loadvector(v,mem_start);

	p.mem.markCode(0x9D95,1);
	p.mem.markData(0x9D93,2);
	p.mem.markData(0x9D96,1+30);
	p.addlabel(0x9D97,"icon");
	u16 addr=0x9D97+30;
	if (p.mem[0x9D96]==3)
	{
		p.addlabel(p.mem.getWord(addr),"quitaddr");
		p.mem.markAddr(addr);
		addr+=2;
	}
	p.addlabel(addr,"tTitle");
	while (p.mem[addr]!=0)
	{
		addr++;
	}
	addr++;
	p.addlabel(addr,"lblStart");
	startaddr=addr;

	for (i=0;i<options.addequatelist.size();i++)
	{
		p.addlabel(options.addequatelist[i].addr,options.addequatelist[i].name);
	}
	options.addequatelist.clear();

	p.findcode(startaddr);
	p.findlabels(startaddr);
	for (i=0;i<options.findcodelist.size();i++)
	{
		p.findcode(options.findcodelist[i]);
		p.findlabels(options.findcodelist[i]);
	}
	p.findtext();
	for (i=0;i<options.findtextlist.size();i++)
	{
		p.findtext(options.findtextlist[i]);
	}
}


void loadion83(z80Project &p, vector<uchar> &v)
{
	int i;
	u16 mem_start=0x9327;
	u16 startaddr;
	if (options.useloadaddr)
	{
		mem_start=options.loadaddr;
	}

	p.loadequates("ti83.dat");
	p.loadequates("ion83.dat");

	p.loadvector(v,mem_start);

	p.mem.markCode(0x9327,3);
	startaddr=0x932A+p.mem[0x9329];
	p.addlabel(startaddr,"lblStart");
	p.addlabel(0x932A,"tTitle");

	for (i=0;i<options.addequatelist.size();i++)
	{
		p.addlabel(options.addequatelist[i].addr,options.addequatelist[i].name);
	}
	options.addequatelist.clear();
	
	p.findcode(startaddr);
	p.findlabels(startaddr);
	for (i=0;i<options.findcodelist.size();i++)
	{
		p.findcode(options.findcodelist[i]);
		p.findlabels(options.findcodelist[i]);
	}
	p.findtext();
	for (i=0;i<options.findtextlist.size();i++)
	{
		p.findtext(options.findtextlist[i]);
	}
}

void loadvenus83(z80Project &p, vector<uchar> &v)
{
	int i;
	u16 mem_start=0x9329;
	u16 startaddr;
	if (options.useloadaddr)
	{
		mem_start=options.loadaddr;
	}
	p.loadequates("ti83.dat");
	p.loadequates("venus83.dat");

	p.loadvector(v,mem_start);

	p.mem.markCode(0x9330,2);
	startaddr=0x9332+p.mem[0x9331];
	p.addlabel(startaddr,"lblStart");
	p.addlabel(0x9332,"tTitle");

	for (i=0;i<options.addequatelist.size();i++)
	{
		p.addlabel(options.addequatelist[i].addr,options.addequatelist[i].name);
	}
	options.addequatelist.clear();

	p.findcode(startaddr);
	p.findlabels(startaddr);
	for (i=0;i<options.findcodelist.size();i++)
	{
		p.findcode(options.findcodelist[i]);
		p.findlabels(options.findcodelist[i]);
	}
	p.findtext();
	for (i=0;i<options.findtextlist.size();i++)
	{
		p.findtext(options.findtextlist[i]);
	}
}

void loadashell83(z80Project &p, vector<uchar> &v)
{
	int i;
	u16 mem_start=0x9327;
	u16 startaddr;
	if (options.useloadaddr)
	{
		mem_start=options.loadaddr;
	}

	p.loadequates("ti83.dat");

	p.loadvector(v,mem_start);

	p.mem.markCode(0x9327,3);
	p.mem.markAddr(0x932A); //0000
	p.mem.markAddr(0x932C); //description pointer
	p.mem.markAddr(0x932E); //icon
	p.mem.markAddr(0x9330); //0000
	p.addlabel(p.mem.getWord(0x932C),"tTitle");
	p.addlabel(p.mem.getWord(0x932E),"Icon");

	startaddr=0x932A+p.mem[0x9329];
	p.addlabel(startaddr,"lblStart");

	for (i=0;i<options.addequatelist.size();i++)
	{
		p.addlabel(options.addequatelist[i].addr,options.addequatelist[i].name);
	}
	options.addequatelist.clear();
	
	p.findcode(startaddr);
	p.findlabels(startaddr);
	for (i=0;i<options.findcodelist.size();i++)
	{
		p.findcode(options.findcodelist[i]);
		p.findlabels(options.findcodelist[i]);
	}
	p.findtext();
	for (i=0;i<options.findtextlist.size();i++)
	{
		p.findtext(options.findtextlist[i]);
	}

}

void loadsos83(z80Project &p, vector<uchar> &v)
{
	int i;
	u16 mem_start=0x9327;
	u16 startaddr;
	if (options.useloadaddr)
	{
		mem_start=options.loadaddr;
	}

	p.loadequates("ti83.dat");
	p.loadequates("ion83.dat");

	p.loadvector(v,mem_start);

	p.mem.markCode(0x9327,3);
	startaddr=0x932A+p.mem[0x9329];
	p.addlabel(startaddr,"lblStart");

	p.mem.markAddr(0x932A); //libs
	p.mem.markAddr(0x932C); //description pointer
	p.addlabel(p.mem.getWord(0x932C),"tTitle");
	p.addlabel(p.mem.getWord(0x932A)+0x9327,"Libraries");
	
	for (i=0;i<options.addequatelist.size();i++)
	{
		p.addlabel(options.addequatelist[i].addr,options.addequatelist[i].name);
	}
	options.addequatelist.clear();
	
	p.findcode(startaddr);
	p.findlabels(startaddr);
	for (i=0;i<options.findcodelist.size();i++)
	{
		p.findcode(options.findcodelist[i]);
		p.findlabels(options.findcodelist[i]);
	}
	p.findtext();
	for (i=0;i<options.findtextlist.size();i++)
	{
		p.findtext(options.findtextlist[i]);
	}
}



void loadnostub83(z80Project &p, vector<uchar> &v)
{
	int i;
	u16 mem_start=0x9327;
	u16 startaddr;
	if (options.useloadaddr)
	{
		mem_start=options.loadaddr;
	}
	
	p.loadequates("ti83.dat");

	p.loadvector(v,mem_start);

	startaddr=0x9327;
	p.addlabel(startaddr,"lblStart");

	for (i=0;i<options.addequatelist.size();i++)
	{
		p.addlabel(options.addequatelist[i].addr,options.addequatelist[i].name);
	}
	options.addequatelist.clear();
	
	p.findcode(startaddr);
	p.findlabels(startaddr);
	for (i=0;i<options.findcodelist.size();i++)
	{
		p.findcode(options.findcodelist[i]);
		p.findlabels(options.findcodelist[i]);
	}
	p.findtext();
	for (i=0;i<options.findtextlist.size();i++)
	{
		p.findtext(options.findtextlist[i]);
	}

}

void loadcrash82(z80Project &p, vector<uchar> &v)
{
	int i;
	u16 mem_start=0x9101;
	u16 addr;
	if (options.useloadaddr)
	{
		mem_start=options.loadaddr;
	}

	p.loadequates("crash82.dat");
	p.loadvector(v,mem_start);
	p.rom_call=true;
	p.romcall_addr=0x8D74;

	p.mem.markData(0x9101,3);
	addr=0x9104;
	p.addlabel(addr,"tTitle");
	while (p.mem[addr]!=0)
	{
		addr++;
	}
	addr++;
	p.addlabel(addr,"lblStart");

	for (i=0;i<options.addequatelist.size();i++)
	{
		p.addlabel(options.addequatelist[i].addr,options.addequatelist[i].name);
	}
	options.addequatelist.clear();
	
	p.findcode(addr);
	p.findlabels(addr);
	for (i=0;i<options.findcodelist.size();i++)
	{
		p.findcode(options.findcodelist[i]);
		p.findlabels(options.findcodelist[i]);
	}
	p.findtext();
	for (i=0;i<options.findtextlist.size();i++)
	{
		p.findtext(options.findtextlist[i]);
	}
}

void loadace82(z80Project &p, vector<uchar> &v)
{
	int i;
	u16 mem_start=0x987D;
	u16 addr;
	if (options.useloadaddr)
	{
		mem_start=options.loadaddr;
	}

	p.loadequates("ace82.dat");
	p.loadvector(v,mem_start);

	p.mem.markData(0x987D,3);
	addr=0x9880;
	p.addlabel(addr,"tTitle");
	while (p.mem[addr]!=0)
	{
		addr++;
	}
	addr++;
	p.addlabel(addr,"lblStart");

	for (i=0;i<options.addequatelist.size();i++)
	{
		p.addlabel(options.addequatelist[i].addr,options.addequatelist[i].name);
	}
	options.addequatelist.clear();
	
	p.findcode(addr);
	p.findlabels(addr);
	for (i=0;i<options.findcodelist.size();i++)
	{
		p.findcode(options.findcodelist[i]);
		p.findlabels(options.findcodelist[i]);
	}
	p.findtext();
	for (i=0;i<options.findtextlist.size();i++)
	{
		p.findtext(options.findtextlist[i]);
	}
}
/*void loadion83(const char* filename, z80Project &p)
{
	p.loadprogram(filename,0x9327);

	p.mem.markCode(0x9327,3);
	ushort startaddr=0x932A+p.mem[0x9329];
	p.addlabel(startaddr,"lblStart");
	p.addlabel(0x932A,"tTitle");
	p.findcode(0xAF06);

	p.findcode(startaddr);
	p.findlabels(startaddr);
}

void loadion(const char* filename, z80Project &p)
{
	p.loadprogram(filename,0x9D93);

	p.mem.markCode(0x9D95,3);
	ushort startaddr=0x9D98+p.mem[0x9D97];
	p.addlabel(startaddr,"lblStart");
	p.addlabel(0x9d98,"tTitle");

	p.findcode(startaddr);
	p.findlabels(startaddr);
}

void loadnostub83(const char* filename, z80Project &p)
{
	p.loadprogram(filename,0x9327);

	ushort startaddr=0x9327;
	p.addlabel(startaddr,"lblStart");

	p.findcode(startaddr);
	p.findlabels(startaddr);
}

void loadtios(const char* filename,z80Project &p)
{
	vector<ushort>startaddrs;
	startaddrs.push_back(0x59);
	startaddrs.push_back(0x5C);
	p.loadprogram(filename,0x0000);
	
	int index;
	for (index=0;index<startaddrs.size();index++)
	{
		p.findcode(startaddrs[index]);
	}
	for (index=0;index<startaddrs.size();index++)
	{
		p.findlabels(startaddrs[index]);
	}
}


void loadmirageos(const char* filename, z80Project &p)
{
	vector<ushort>startaddrs;
	startaddrs.push_back(p.equ.withname(string("sendbytetios")));
	startaddrs.push_back(p.equ.withname(string("getbytetios")));
	startaddrs.push_back(0x4616);
//gettext               = $4125
//gettextv              = $4128

//	startaddrs.push_back(p.equ.withname(string("pointoffc")));
//	startaddrs.push_back(p.equ.withname(string("fastrectangle")));
//	startaddrs.push_back(p.equ.withname(string("fastrectangle_save")));
//	startaddrs.push_back(p.equ.withname(string("filledrectangle")));
//	startaddrs.push_back(p.equ.withname(string("filledrectangle_save")));
//	startaddrs.push_back(p.equ.withname(string("fastline")));
//	startaddrs.push_back(p.equ.withname(string("fastlined")));
//	startaddrs.push_back(p.equ.withname(string("fastlinew")));
//	startaddrs.push_back(p.equ.withname(string("fastlinex")));
//	startaddrs.push_back(p.equ.withname(string("fastlineb")));

	p.loadprogram(filename,0x4000);
	
//	p.mem.markCode(p.mem.getWord(0x4152+1),1);
//	p.mem.markCode(p.mem.getWord(0x4101+1),1);
//	p.mem.markCode(p.mem.getWord(0x40AD+1),1);
//	p.mem.markCode(p.mem.getWord(0x40BC+1),1);
//	p.mem.markCode(p.mem.getWord(0x4122+1),1);
//	p.mem.markCode(p.mem.getWord(0x413D+1),1);
//	p.mem.markCode(p.mem.getWord(0x417F+1),1);
//	p.mem.markCode(p.mem.getWord(0x4092+1),1);
//	p.mem.markCode(p.mem.getWord(0x408F+1),1);
//	p.mem.markCode(p.mem.getWord(0x4089+1),1);
//	p.mem.markCode(p.mem.getWord(0x4191+1),1);
//	p.mem.markCode(p.mem.getWord(0x412E+1),1);
	
	int index;
	for (index=0;index<startaddrs.size();index++)
	{
		p.findcode(startaddrs[index]);
	}
	for (index=0;index<startaddrs.size();index++)
	{
		p.findlabels(startaddrs[index]);
	}

//	p.mem.markData(p.mem.getWord(0x4152+1),1);
//	p.mem.markData(p.mem.getWord(0x4101+1),1);
//	p.mem.markData(p.mem.getWord(0x40AD+1),1);
//	p.mem.markData(p.mem.getWord(0x40BC+1),1);
//	p.mem.markData(p.mem.getWord(0x4122+1),1);
//	p.mem.markData(p.mem.getWord(0x413D+1),1);
//	p.mem.markData(p.mem.getWord(0x417F+1),1);
//	p.mem.markData(p.mem.getWord(0x4092+1),1);
//	p.mem.markData(p.mem.getWord(0x408F+1),1);
//	p.mem.markData(p.mem.getWord(0x4089+1),1);
//	p.mem.markData(p.mem.getWord(0x4191+1),1);
//	p.mem.markData(p.mem.getWord(0x412E+1),1);

	
//	p.findcode(startaddr);
//	p.findcode(startaddr2);
//	p.findlabels(startaddr);
//	p.findlabels(startaddr2);
	
	//extra mirageos labels...
	int raddr,addr;
	for (raddr=0x4083;raddr<=0x41D3;raddr+=3)
	{
		p.addlabel(p.mem.getWord(raddr+1),string("_")+p.equ.lookup(raddr));
	}
	

}


*/

