#include "stdafx.h"

#include "main.h"
#include "progload.h"
#include "func.h"

//Z80 Disassembler version 1.0 by Dan Weiss
//http://dwedit.home.comcast.net/
//public domain

//TODO:
//Names for IY bits and offsets
//Find pointer tables
//Flash Applications
//
//maybe: (far future)
//
//Self modify jumps
//stack modify calls
//TIOS?

Options options;

int main( int argc, char *argv[ ], char *envp[ ] )
{
	char *file1=NULL, *file2=NULL, *arg;
	char currentoption;
	int i;
	bool syntaxerror=true;
	int insidearg=0;
	z80Project p;
	string labname;
	
	for (i=1;i<argc;i++)
	{
		arg=argv[i];
		if (arg)
		{
			if (insidearg)
			{
				switch (currentoption)
				{
				case 's':
					insidearg=0;
					options.loadaddr=hextoushort(arg);
					options.useloadaddr=true;
					break;
				case 'c':
					insidearg=0;
					options.findcodelist.push_back(hextoushort(arg));
					break;
				case 't':
					insidearg=0;
					options.findtextlist.push_back(hextoushort(arg));
					break;
				case 'l':
					if (insidearg==1)
					{
						labname=arg;
						insidearg++;
					}
					else if (insidearg==2)
					{
						options.addequatelist.push_back(Equate(hextoushort(arg),labname));
						labname=string();
						insidearg=0;
					}
					break;
				case 'e':
					insidearg=0;
					options.exportfile=arg;
					break;
				}



			}
			else if (arg[0]!='-')
			{
				if (!file1)
				{
					file1=arg;
					syntaxerror=false;
				}
				else
				{
					if (!file2)
					{
						file2=arg;
						syntaxerror=false;
					}
					else
					{
						syntaxerror=true;
					}
					
				}
			}
			else
			{
				currentoption=arg[1];
				insidearg=1;
				switch (currentoption)
				{
				case 'L':
					p.listfile=true;
					insidearg=0;
					break;
				case 'H':
					p.hidedata=true;
					insidearg=0;
					break;
				case 'E':
					options.exportallequates=true;
					insidearg=0;
					break;
				}
			}
		}
	}
	if (insidearg)
	{
		syntaxerror=true;
	}
	
	if (syntaxerror)
	{
		cout << "Z80 Disassembler 1.0 by Dan Weiss\n"
				"Syntax:\n"
		        "  " << argv[0] << " filein.8xp [fileout.z80]\n"
		        "  If you don't give a second file, it outputs to stdout\n"
		        "  Supports the following program types:\n"
		        "    TI-82 CrASH, ACE\n"
		        "    TI-83 ZASMLOAD, Ion, Venus, AShell, SOS (partial)\n"
		        "    TI-83+ ASM, Ion, MirageOS\n"
		        "  Available Options: (can be placed anywhere in command line)\n"
			    "    -s #### set start address in memory\n"
				"    -c #### look for code at that address (can be used multiple times)\n"
				"    -t #### look for text at that address (can be used multiple times)\n"
				"    -l name #### defines a label at the address with name\n"
				"    -L generate a list file instead of a source file\n"
				"    -H hides data from disassembled output\n"
				"    -e filename exports all equates to filename\n"
				"    -E also export equates loaded from shell .dat files\n"
//				"    -d Don't disassemble, just output lots of .db's\n"
		;
		cout << endl;
		return 1;
	}
	
	p.loadtable("z80tab.dat");
	
	if (!loadprog(file1,p))
	{
		cerr << "Cannot open input file "<<file1<<"!" << endl;
		return 2;
	}




	if (file2)
	{
		ofstream out(file2);
		if (out.good())
		{
			p.output(out);
			cerr << "Successfully created output file " <<file2<<"." << endl;
		}
		else
		{
			cerr << "Cannot create output file "<<file2<<"!"<<endl;
		}
	}
	else
	{
		p.output(cout);
	}
	
	if (options.exportfile)
	{
		exportequates(options.exportfile,p,options.exportallequates);
	}

//	p.loadtable("bcalltab.dat");
//	p.loadequates("ti83plus.dat");
//	p.loadequates("ti83.dat");
//	p.loadequates("ion83.dat");
//	p.loadequates("ionmirage.dat");
//	p.loadbcalls("ti83pbcall.dat");
	

//	loadion83("dkion.bin",p);
//	loadnostub83("narkemen.bin",p);
//	loadtios("bank0.rom",p);
//	loadmirageos("mirageos.bin",p);
//	loadion("lotus.bin",p);

//	p.hidedata=true;
	
//	p.listfile=true;
//	p.output(cout);

	return 0;
}



bool exportequates(char * filename, z80Project& p, bool exportall)
{
	ofstream fout;
	fout.open(filename);
	if (!fout.good())
	{
		return false;
	}
	int i;
	for (i=0;i<p.equ.equates.size();i++)
	{
		if (!p.equ.equates[i].sysequate || exportall)
		{
			fout<<pad(p.equ.equates[i].name,20,' ') << " = $" << hex4(p.equ.equates[i].addr)<<endl;
		}
	}
	return true;
}
