#include "stdafx.h"
#include "func.h"

string toLower(const string& str)
{
	string retval(str);
	int index;
	for (index=0;index<retval.length();index++)
	{
		retval[index]=tolower(retval[index]);
	}
	return retval;
}

string toUpper(const string& str)
{
	string retval(str);
	int index;
	for (index=0;index<retval.length();index++)
	{
		retval[index]=toupper(retval[index]);
	}
	return retval;
}



string inttostring(int number)
{
	char numstr[20];
	char *pos=numstr+19;
	bool neg=false;
	*pos='\0';
	if (number<0)
	{
		neg=true;
		number=-number;
	}
	do
	{
		--pos;
		*pos=(number%10)+'0';
		number/=10;
	} while (number);
	if (neg)
	{
		--pos;
		*pos='-';
	}
	return string(pos);	
}
string inttohex(ushort number)
{
	char numstr[20];
	static const char hextable[17]="0123456789ABCDEF";
	char *pos=numstr+19;
	*pos='\0';
	do
	{
		pos--;
		*pos=hextable[number&0xF];
		number>>=4;
	} while (number);
	return string(pos);
}

string hex4(ushort num)
{
	string retval=inttohex(num);
	while (retval.length()<4)
	{
		retval="0"+retval;
	}
	return retval;
}

string hex2(uchar num)
{
	string retval=inttohex(num);
	if (retval.length()&1)
	{
		retval="0"+retval;
	}
	return retval;
}

uchar hexchartoint(char hexchar)
{
	uchar a;
	a=hexchar-'0';
	if (a>9) a-=('A'-'9'-1);
	return a;
}

ushort hextoushort(const string& hexvalue)
{
	ushort result=0;
	uchar hexchar;
	int index;
	for (index=0;index<hexvalue.size();index++)
	{
		hexchar=toupper(hexvalue[index]);
		if ((hexchar>='0' && hexchar<='9') || (hexchar>='A' && hexchar<='F'))
		{
			result<<=4;
			result+=hexchartoint(hexchar);
		}
	}
	return result;
}





bool getArg(int &pos, const string& line, string& field)
{
	//inside a space?
	while (line[pos]==',' && pos<line.length())
	{
		pos++;
	}
	//starting at the end?
	if (pos>=line.length())
	{
		return false;
	}
	int start=pos;
	//get next space
	while (line[pos]!=',' && pos<line.length())
	{
		pos++;
	}
	field=line.substr(start,pos-start);
	return true;
}

bool getField(int &pos, const string& line, string& field)
{
	//inside a space?
	while (isspace(line[pos]) && pos<line.length())
	{
		pos++;
	}
	//starting at the end?
	if (pos>=line.length())
	{
		return false;
	}
	int start=pos;
	//get next space
	while (!isspace(line[pos]) && pos<line.length())
	{
		pos++;
	}
	field=line.substr(start,pos-start);
	return true;
}

int str2int(const string& number)
{
	int val=0;
	int pos=0;
	while (pos<number.length())
	{
		val*=10;
		val+=number[pos]-'0';
		pos++;
	}
	return val;
}

uchar hextobyte(char nibh, char nibl)
{
	int a;
	int b;
	a=nibh-'0';
	if (a>9) a-=('A'-'9'-1);
	b=a;
	a=nibl-'0';
	if (a>9) a-=('A'-'9'-1);
	return a+(b<<4);
}

void hexto2bytes(const string& hexchars, uchar& h, uchar& l)
{
	h=0;
	l=0;
	if (hexchars.length()<1) return;
	if (hexchars.length()<3)
	{
		l=hextobyte(toupper(hexchars[0]),toupper(hexchars[1]));
	} else {
		h=hextobyte(toupper(hexchars[2]),toupper(hexchars[3]));
		l=hextobyte(toupper(hexchars[0]),toupper(hexchars[1]));
	}
}

/*
u16 hextoword(const string& hexchars)
{
	u16 retval;
	h=0;
	l=0;
	if (hexchars.length()<1) return 0;
	if (hexchars.length()<3)
	{
		retval=hextobyte(toupper(hexchars[0]),toupper(hexchars[1]));
	} else {
		retval=(hextobyte(toupper(hexchars[2]),toupper(hexchars[3])) << 8)
			| hextobyte(toupper(hexchars[0]),toupper(hexchars[1]));
	}
	return retval;
}
*/

string pad(string padthis, int size, char padchar)
{
	while (padthis.size()<size)
	{
		padthis+=padchar;
	}
	return padthis;
}
