#include "stdafx.h"
#include "equates.h"
#include "func.h"

bool Equates::binarysearch(int &result,ushort key) const
{
	result=0;
	if (equates.empty())
	{
		return false;
	}
	int bottom=0,top=equates.size(),mid;
	while (top>bottom)
	{
		mid=(bottom+top)>>1;
		if (key<equates[mid].addr)
		{
			top=mid;
		}
		else if (key>equates[mid].addr)
		{
			bottom=mid+1;
		}
		else if (key==equates[mid].addr)
		{
			result=mid;
			return true;
		}
	}
	result=(bottom+top)>>1;
	return false;
}
bool Equates::add(const Equate& e)
{
	int insertionpoint;
	if (!binarysearch(insertionpoint,e.addr))
	{
		equates.insert(equates.begin()+insertionpoint,e);
		return true;
	}
	else
	{
		equates[insertionpoint]=e;
		return false;
	}
}
string Equates::lookup(ushort addr) const
{
	int lookuppoint;
	if (addr>max_addr || addr<min_addr)
	{
		string retstring="$";
		retstring+=inttohex(addr);
		return retstring;
	}
	if (binarysearch(lookuppoint,addr))
	{
		return equates[lookuppoint].name;
	}
	else
	{
		if (lookuppoint>0 && addr<prog_end)
		{
			lookuppoint--;
			string retstring;
			retstring=equates[lookuppoint].name;
			ushort difference=addr-equates[lookuppoint].addr;
			retstring+="+";
			retstring+=inttostring(difference);
			return retstring;
		}
		else
		{
			string retstring="$";
			retstring+=inttohex(addr);
			return retstring;
		}
	}
}
bool Equates::isdefined(ushort addr) const
{
	int junk;
	return binarysearch(junk,addr);
}

ushort Equates::withname(string lookfor) const
{
	lookfor=toLower(lookfor);
	for (int index=0; index<equates.size();index++)
	{
		if (!toLower(lookfor).compare(toLower(equates[index].name)))
		{
			return equates[index].addr;
		}
	}
	return 0;
}

ushort Equates::withname(const char *lookfor) const
{
	return withname(string(lookfor));
}

Equate& Equates::withaddr(ushort addr)
{
	int index;
	static Equate junk;
	if (binarysearch(index,addr))
	{
		return equates[index];
	}
	else
	{
		return junk;
	}
}

const Equate& Equates::withaddr(ushort addr) const
{
	int index;
	static Equate junk;
	if (binarysearch(index,addr))
	{
		return equates[index];
	}
	else
	{
		return junk;
	}
}