VERSION 5.00
Object = "{F9043C88-F6F2-101A-A3C9-08002B2F49FB}#1.2#0"; "comdlg32.ocx"
Begin VB.Form frmFrontend 
   Caption         =   "Z80Disassembler Frontend"
   ClientHeight    =   9000
   ClientLeft      =   165
   ClientTop       =   735
   ClientWidth     =   13170
   LinkTopic       =   "Form1"
   OLEDropMode     =   1  'Manual
   ScaleHeight     =   9000
   ScaleWidth      =   13170
   StartUpPosition =   3  'Windows Default
   Begin VB.CommandButton cmdUpdate 
      Caption         =   "Refresh Code"
      Enabled         =   0   'False
      Height          =   375
      Left            =   0
      OLEDropMode     =   1  'Manual
      TabIndex        =   14
      Top             =   6600
      Width           =   1335
   End
   Begin VB.CommandButton cmdClearLookFor 
      Caption         =   "Clear"
      Height          =   375
      Left            =   2760
      OLEDropMode     =   1  'Manual
      TabIndex        =   13
      Top             =   360
      Width           =   600
   End
   Begin VB.CommandButton cmdAddLookFor 
      Caption         =   "Add"
      Height          =   375
      Left            =   2160
      OLEDropMode     =   1  'Manual
      TabIndex        =   11
      Top             =   360
      Width           =   600
   End
   Begin VB.TextBox txtLookFor 
      Height          =   285
      Left            =   1320
      OLEDropMode     =   1  'Manual
      TabIndex        =   9
      Text            =   "0000"
      Top             =   360
      Width           =   735
   End
   Begin VB.ListBox lstLookFor 
      Height          =   1035
      Left            =   0
      OLEDropMode     =   1  'Manual
      TabIndex        =   8
      Top             =   720
      Width           =   3375
   End
   Begin VB.TextBox txtOverride 
      Height          =   285
      Left            =   2160
      OLEDropMode     =   1  'Manual
      TabIndex        =   7
      Text            =   "9327"
      Top             =   0
      Width           =   735
   End
   Begin VB.CheckBox chkOverride 
      Caption         =   "&Override origin address:"
      Height          =   255
      Left            =   0
      OLEDropMode     =   1  'Manual
      TabIndex        =   6
      Top             =   0
      Width           =   2055
   End
   Begin MSComDlg.CommonDialog cmd 
      Left            =   9120
      Top             =   0
      _ExtentX        =   847
      _ExtentY        =   847
      _Version        =   393216
      CancelError     =   -1  'True
      DefaultExt      =   "8xp"
      Filter          =   $"frontend.frx":0000
   End
   Begin VB.ListBox lstCode 
      BeginProperty Font 
         Name            =   "Terminal"
         Size            =   9
         Charset         =   255
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   6540
      IntegralHeight  =   0   'False
      Left            =   3480
      OLEDropMode     =   1  'Manual
      TabIndex        =   5
      Top             =   240
      Width           =   6135
   End
   Begin VB.TextBox txtAddress 
      Appearance      =   0  'Flat
      BeginProperty Font 
         Name            =   "Terminal"
         Size            =   9
         Charset         =   255
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   270
      Left            =   2520
      OLEDropMode     =   1  'Manual
      TabIndex        =   3
      Top             =   2040
      Width           =   840
   End
   Begin VB.TextBox txtName 
      Appearance      =   0  'Flat
      BeginProperty Font 
         Name            =   "Terminal"
         Size            =   9
         Charset         =   255
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   270
      Left            =   0
      OLEDropMode     =   1  'Manual
      TabIndex        =   1
      Top             =   2040
      Width           =   2520
   End
   Begin VB.ListBox lstLabels 
      BeginProperty Font 
         Name            =   "Terminal"
         Size            =   9
         Charset         =   255
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   4110
      IntegralHeight  =   0   'False
      Left            =   0
      OLEDropMode     =   1  'Manual
      TabIndex        =   4
      Top             =   2310
      Width           =   3360
   End
   Begin VB.Label Label3 
      AutoSize        =   -1  'True
      Caption         =   "&Disassembled Code:   (Double click on label names to edit)"
      Height          =   195
      Left            =   3480
      OLEDropMode     =   1  'Manual
      TabIndex        =   12
      Top             =   0
      Width           =   4140
   End
   Begin VB.Label lblLookForCode 
      AutoSize        =   -1  'True
      Caption         =   "&Look for code at:"
      Height          =   195
      Left            =   0
      OLEDropMode     =   1  'Manual
      TabIndex        =   10
      Top             =   360
      Width           =   1215
   End
   Begin VB.Label Label2 
      AutoSize        =   -1  'True
      Caption         =   "&Address:"
      Height          =   195
      Left            =   2520
      OLEDropMode     =   1  'Manual
      TabIndex        =   2
      Top             =   1800
      Width           =   615
   End
   Begin VB.Label Label1 
      AutoSize        =   -1  'True
      Caption         =   "Label &Name:"
      Height          =   195
      Left            =   0
      OLEDropMode     =   1  'Manual
      TabIndex        =   0
      Top             =   1800
      Width           =   900
   End
   Begin VB.Menu mnuFile 
      Caption         =   "&File"
      Begin VB.Menu mnuOpen 
         Caption         =   "&Open Program..."
      End
      Begin VB.Menu mnuSaveAs 
         Caption         =   "&Save As..."
         Enabled         =   0   'False
      End
      Begin VB.Menu mnusep3 
         Caption         =   "-"
      End
      Begin VB.Menu mnuRefresh 
         Caption         =   "&Refresh Code"
         Enabled         =   0   'False
      End
      Begin VB.Menu mnuesep2 
         Caption         =   "-"
      End
      Begin VB.Menu mnuImport 
         Caption         =   "&Import equates file..."
      End
      Begin VB.Menu mnuExport 
         Caption         =   "&Export equates file..."
      End
      Begin VB.Menu mnuFileSep1 
         Caption         =   "-"
      End
      Begin VB.Menu mnuExit 
         Caption         =   "E&xit"
      End
   End
End
Attribute VB_Name = "frmFrontend"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private Declare Function ExpandEnvironmentStrings Lib "kernel32" Alias "ExpandEnvironmentStringsA" (ByVal lpSrc As String, ByVal lpDst As String, ByVal nSize As Long) As Long
Private Declare Function GetSystemDirectory Lib "kernel32" Alias "GetSystemDirectoryA" (ByVal lpBuffer As String, ByVal nSize As Long) As Long
Private Declare Function GetWindowsDirectory Lib "kernel32" Alias "GetWindowsDirectoryA" (ByVal lpBuffer As String, ByVal nSize As Long) As Long

Private Type StatusType
    OnDir As Long
    TotalDirs As Long
    FilesCopied As Long
    DupeFiles As Long
    Mode As Long
End Type

Dim Status As StatusType


Private Declare Function OpenProcess Lib "kernel32" _
(ByVal dwDesiredAccess As Long, ByVal bInheritHandle As Long, _
ByVal dwProcessId As Long) As Long

Private Declare Function GetExitCodeProcess Lib "kernel32" _
(ByVal hProcess As Long, lpExitCode As Long) As Long

Private Const STATUS_PENDING = &H103&
Private Const PROCESS_QUERY_INFORMATION = &H400



Private Type Equate
    Name As String
    Address As Long
End Type

Dim ProgLocked As Boolean

Dim EquateList() As Equate
Dim NumEquates As Long
Dim TextLocked As Boolean
Dim LoadedFile As String

Dim LoadProgramFilter As String
Dim SaveSourceFilter As String
Dim EquatesFilter As String


'this function is copyrighted to some internet guide somewhere... blah
Function sTempDirectory() As String
    Dim sOut As String
    sOut = Space(260)
    ExpandEnvironmentStrings "%TEMP%", sOut, 260
    sOut = Left(sOut, InStr(sOut, Chr(0)) - 1)
    sTempDirectory = sOut
End Function


Function Pad(ByVal padthis As String, ByVal numspaces As Long, Optional ByVal padchar As String = " ") As String
    Do While Len(padthis) < numspaces
        padthis = padthis + padchar
    Loop
    Pad = padthis
End Function

Function Hex4(num As Long) As String
    Dim ReturnVal As String
    ReturnVal = Hex$(num)
    Do While Len(ReturnVal) < 4
        ReturnVal = "0" + ReturnVal
    Loop
    Hex4 = ReturnVal
End Function

Sub UpdateEquate(Index As Long, Name As String, Address As Long)
    EquateList(Index).Name = Name
    EquateList(Index).Address = Address
    lstLabels.List(Index) = Pad(Name, 20) + "$" + Hex4(Address)
End Sub

Sub AddEquate(Name As String, Address As Long)
    NumEquates = NumEquates + 1
    ReDim Preserve EquateList(NumEquates - 1)
    EquateList(NumEquates - 1).Name = Name
    EquateList(NumEquates - 1).Address = Address
    lstLabels.AddItem (Pad(Name, 20) + "$" + Hex4(Address))
End Sub

Sub CreateSampleEquates()
    AddEquate "hello world", &H9D95&
    AddEquate "hello world", &H9D96&
    AddEquate "hello world", &H9D97&
    AddEquate "hello world", &H9D98&
    AddEquate "hello world", &H9D99&
End Sub


Private Sub cmdAddLookFor_Click()
    lstLookFor.AddItem txtLookFor.Text
End Sub

Private Sub cmdClearLookFor_Click()
    lstLookFor.Clear
End Sub

Private Sub cmdUpdate_Click()
    If ProgLocked Then Exit Sub
    Dim LastIndex As Long
    If LoadedFile = "" Then
        cmdUpdate.Enabled = False
        Exit Sub
    End If
    
    LastIndex = lstCode.ListIndex
    RefreshCode
    If lstCode.ListCount > LastIndex Then lstCode.ListIndex = LastIndex
End Sub

Private Sub Form_Load()
    LoadProgramFilter = "All TI-8x Programs|*.8?p;*.8?s|TI-83+ Programs (*.8xp)|*.8xp|TI-83 Programs (*.83p)|*.83p|TI-82 Programs (*.82p)|*.82p|All Files (*.*)|*.*"
    SaveSourceFilter = "Z80 Source Code (*.z80)|*.z80|ASM Source Code (*.asm)|*.asm|Header File (*.h)|*.h|Include File (*.inc)|*.inc|All Files (*.*)|*.*"
    EquatesFilter = "Export Files (*.exp)|*.exp|All Files (*.*)|*.*"
    
    ReDim EquateList(0)
    If Command$ <> "" Then OpenFile Command$
End Sub

Private Sub Form_Resize()
On Error Resume Next
    cmdUpdate.Top = Me.ScaleHeight - cmdUpdate.Height
    lstLabels.Height = Me.ScaleHeight - lstLabels.Top - cmdUpdate.Height
    lstCode.Height = Me.ScaleHeight - lstCode.Top
    lstCode.Width = Me.ScaleWidth - lstCode.Left
    
End Sub

Private Sub lstCode_DblClick()
    Dim Line As String
    With lstCode
        If .ListCount <= 0 Then Exit Sub
        Line = .List(.ListIndex)
    End With
    If Left(Line, 1) <> " " Then
        Dim Label As String
        Dim EndOfLine1 As Long
        Dim EndOfLine2 As Long
        Dim EndOfLine3 As Long
        Dim EndOfLine As Long
        
        EndOfLine1 = Len(Line) + 1
        EndOfLine2 = InStr(1, Line, ":")
        EndOfLine3 = InStr(1, Line, " =")
        
        EndOfLine = EndOfLine1
        If EndOfLine2 <> 0 And EndOfLine2 < EndOfLine Then EndOfLine = EndOfLine2
        If EndOfLine3 <> 0 And EndOfLine3 < EndOfLine Then EndOfLine = EndOfLine3
        
        Label = Left(Line, EndOfLine - 1)
        Dim I As Long
        For I = 0 To NumEquates - 1
            If Label = EquateList(I).Name Then
                lstLabels.ListIndex = I
                UpdateTextBoxes
                Exit For
            End If
        Next
    End If
End Sub

Private Sub lstCode_OLEDragDrop(Data As DataObject, Effect As Long, Button As Integer, Shift As Integer, X As Single, Y As Single)
    DragDrop Data, Effect, Button, Shift, X, Y
End Sub

Private Sub lstCode_OLEDragOver(Data As DataObject, Effect As Long, Button As Integer, Shift As Integer, X As Single, Y As Single, State As Integer)
    DragOver Data, Effect, Button, Shift, X, Y, State
End Sub

Private Sub lstLabels_Click()
    UpdateTextBoxes
End Sub

Private Sub lstLabels_KeyDown(Keycode As Integer, Shift As Integer)
    UpdateTextBoxes
End Sub

Private Sub mnuExit_Click()
    Unload Me
End Sub


Function MakeEquates() As String
    Dim EquatesString As String
    Dim I As Long
    For I = 0 To NumEquates - 1
        EquatesString = EquatesString + " -l " + EquateList(I).Name + " " + Hex4(EquateList(I).Address)
    Next
    
    For I = 0 To lstLookFor.ListCount - 1
        EquatesString = EquatesString + " -c " + lstLookFor.List(I)
    Next
    
    If chkOverride.Value = vbChecked Then
        EquatesString = EquatesString + " -s " + txtOverride.Text
    End If
    
    
    MakeEquates = EquatesString
End Function

Sub UpdateTitleBar()
    If LoadedFile <> "" Then
        Me.Caption = "Z80Disassembler Frontend - " + LoadedFile
    Else
        Me.Caption = "Z80Disassembler Frontend"
    End If
End Sub



Sub RefreshCode()
    On Error GoTo RefreshError
    'build command line
    Dim CommandLine As String
    Dim TempFile1 As String
    Dim TempFile2 As String
    
    TempFile1 = sTempDirectory + "\_z80dasm_temp.z80"
    TempFile2 = sTempDirectory + "\_z80dasm_temp.exp"
    lstCode.Clear
    lstCode.AddItem "Disassembling... Please wait..."
    UpdateTitleBar
    ChDir App.Path
    
    CommandLine = "z80disassembler.exe " + Chr(34) + LoadedFile + Chr(34) + " " + Chr(34) + TempFile1 + Chr(34) + " -e " + Chr(34) + TempFile2 + Chr(34) + MakeEquates + " -L"
'    Shell CommandLine
'    Shell "z80disassembler.exe"
    ProgLocked = True
    ShellandWait CommandLine
    
    Open TempFile1 For Input As #1
        Dim TextLine As String
        lstCode.Clear
        Do While Not EOF(1)
            Line Input #1, TextLine
            lstCode.AddItem (TextLine)
        Loop
        
    Close #1
    Open TempFile2 For Input As #1
        FlushLabels
        Dim EqualsPos As Long
        Dim Name As String, Addr As Long
        Do While Not EOF(1)
            Line Input #1, TextLine
            EqualsPos = InStr(1, TextLine, "= $")
            Name = Trim(Left(TextLine, EqualsPos - 1))
            Addr = Val("&H" + Mid(TextLine, EqualsPos + 3) + "&")
            AddEquate Name, Addr
        Loop
    Close #1
    ProgLocked = False
    
    UpdateButtons
    
    Kill TempFile1
    Kill TempFile2
    Exit Sub
RefreshError:
    lstCode.Clear
    LoadedFile = ""
    UpdateButtons
    MsgBox "An error occurred during disassembly."
    UpdateTitleBar
    UpdateButtons
    ProgLocked = False
    Exit Sub
End Sub


Sub FlushLabels()
    lstLabels.Clear
    'UpdateTextBox
    ReDim EquateList(0)
    NumEquates = 0
End Sub

Sub OpenFile(filename As String)
    LoadedFile = filename
    FlushLabels
    RefreshCode
End Sub

Sub OpenMenu()
    Dim filename As String
    On Error GoTo menuopenerror
        cmd.Filter = LoadProgramFilter
        cmd.DefaultExt = "8xp"
        cmd.ShowOpen
        filename = cmd.filename
    On Error GoTo 0
    OpenFile filename
    
  Exit Sub
menuopenerror:
  Exit Sub
End Sub


Private Sub mnuExport_Click()
    If ProgLocked Then Exit Sub
    ExportEquates
End Sub

Private Sub mnuImport_Click()
    If ProgLocked Then Exit Sub
    ImportEquates
End Sub

Private Sub mnuOpen_Click()
    If ProgLocked Then Exit Sub
    OpenMenu
End Sub

Private Sub mnuRefresh_Click()
    If ProgLocked Then Exit Sub
    Dim LastIndex As Long
    
    If LoadedFile = "" Then
        mnuRefresh.Enabled = False
        Exit Sub
    End If
    
    LastIndex = lstCode.ListIndex
    RefreshCode
    If lstCode.ListCount > LastIndex Then lstCode.ListIndex = LastIndex
    
End Sub

Private Sub mnuSaveAs_Click()
    If ProgLocked Then Exit Sub
    SaveAsMenu
End Sub

Private Sub txtAddress_KeyDown(Keycode As Integer, Shift As Integer)
    PressKey Keycode, Shift, 2
End Sub

Private Sub txtName_Change()
    If TextLocked Then Exit Sub
    UpdateListBox
End Sub

Private Sub txtName_GotFocus()
    If TextLocked Then Exit Sub
    txtName.SelStart = 0
    txtName.SelLength = Len(txtName.Text)
End Sub

Private Sub txtAddress_GotFocus()
    If TextLocked Then Exit Sub
    txtAddress.SelStart = 0
    txtAddress.SelLength = Len(txtAddress.Text)
End Sub

Sub UpdateTextBoxes(Optional textboxnumber = 0)
    TextLocked = True
    Dim Index As Long
    Index = lstLabels.ListIndex
    If Index < 0 Then
        txtName.Text = ""
        txtAddress.Text = ""
    Else
        txtName = EquateList(Index).Name
        txtAddress = Hex4(EquateList(Index).Address)
    End If
    TextLocked = False
    If textboxnumber = 2 Then
        txtAddress.SetFocus
        txtAddress_GotFocus
    Else
        txtName.SetFocus
        txtName_GotFocus
    End If
End Sub

Sub PressKey(Keycode As Integer, Shift As Integer, Optional textboxnumber = 0)
    Dim Index
    Index = lstLabels.ListIndex
    Select Case Keycode
        Case vbKeyDown
            Keycode = 0
            If Index < lstLabels.ListCount - 1 Then
                Index = Index + 1
                lstLabels.ListIndex = Index
            End If
            UpdateTextBoxes textboxnumber
        Case vbKeyUp
            Keycode = 0
            If Index > 0 Then
                Index = Index - 1
                lstLabels.ListIndex = Index
            End If
            UpdateTextBoxes textboxnumber
    End Select
End Sub

Private Sub txtName_KeyDown(Keycode As Integer, Shift As Integer)
    PressKey Keycode, Shift, 1
End Sub

Sub UpdateListBox()
    Dim Index As Long
    Index = lstLabels.ListIndex
    If Index < 0 Then Exit Sub
    UpdateEquate Index, txtName.Text, Val("&H" + txtAddress.Text + "&")
    
End Sub

Public Function ShellandWait(ExeFullPath As String, _
Optional TimeOutValue As Long = 0) As Boolean
    
    Dim lInst As Long
    Dim lStart As Long
    Dim lTimeToQuit As Long
    Dim sExeName As String
    Dim lProcessId As Long
    Dim lExitCode As Long
    Dim bPastMidnight As Boolean
    
    On Error GoTo ErrorHandler

    lStart = CLng(Timer)
    sExeName = ExeFullPath

    'Deal with timeout being reset at Midnight
    If TimeOutValue > 0 Then
        If lStart + TimeOutValue < 86400 Then
            lTimeToQuit = lStart + TimeOutValue
        Else
            lTimeToQuit = (lStart - 86400) + TimeOutValue
            bPastMidnight = True
        End If
    End If

    lInst = Shell(sExeName, vbMinimizedNoFocus)
    
lProcessId = OpenProcess(PROCESS_QUERY_INFORMATION, False, lInst)

    Do
        Call GetExitCodeProcess(lProcessId, lExitCode)
        DoEvents
        If TimeOutValue And Timer > lTimeToQuit Then
            If bPastMidnight Then
                 If Timer < lStart Then Exit Do
            Else
                 Exit Do
            End If
    End If
    Loop While lExitCode = STATUS_PENDING
    
    ShellandWait = True
   
ErrorHandler:
ShellandWait = False
Exit Function
End Function


Private Sub DragDrop(Data As DataObject, ByRef Effect As Long, Button As Integer, Shift As Integer, X As Single, Y As Single)
    If Data.GetFormat(vbCFFiles) Then
        If Data.Files.Count = 1 Then
            OpenFile Data.Files(1)
        End If
    End If
End Sub

Private Sub DragOver(Data As DataObject, Effect As Long, Button As Integer, Shift As Integer, X As Single, Y As Single, State As Integer)
    If Data.GetFormat(vbCFFiles) Then
        If Data.Files.Count <> 1 Then
            Effect = 0
        End If
    Else
        Effect = 0
    End If
    
End Sub

Sub SaveAsMenu()
    Dim filename As String
    On Error GoTo MenuSaveError
        cmd.Filter = SaveSourceFilter
        cmd.DefaultExt = "z80"
        cmd.Flags = cdlOFNOverwritePrompt
        cmd.ShowSave
        filename = cmd.filename
    On Error GoTo 0
    SaveFile filename
    
  Exit Sub
MenuSaveError:
  Exit Sub
End Sub

Sub SaveFile(filename As String)
    On Error GoTo SaveError
    'build command line
    Dim CommandLine As String
    ChDir App.Path
    CommandLine = "z80disassembler.exe " + Chr(34) + LoadedFile + Chr(34) + " " + Chr(34) + filename + Chr(34) + MakeEquates
    
    ProgLocked = True
    ShellandWait CommandLine
    ProgLocked = False
    
    Exit Sub
SaveError:
    lstCode.Clear
    LoadedFile = ""
    UpdateButtons
    MsgBox "An error occurred during disassembly."
    UpdateTitleBar
    UpdateButtons
    ProgLocked = False
    Exit Sub
    
End Sub

Sub UpdateButtons()
    If LoadedFile = "" Then
        cmdUpdate.Enabled = False
        mnuRefresh.Enabled = False
        mnuSaveAs.Enabled = False
    Else
        cmdUpdate.Enabled = True
        mnuRefresh.Enabled = True
        mnuSaveAs.Enabled = True
    End If
End Sub

Sub ImportEquates()
    Dim filename As String
    On Error GoTo MenuImportError
        cmd.Filter = EquatesFilter
        cmd.DefaultExt = "exp"
        cmd.ShowOpen
        filename = cmd.filename
    On Error GoTo 0
    LoadEquates filename
  Exit Sub
MenuImportError:
  Exit Sub
End Sub

Sub ExportEquates()
    Dim filename As String
    On Error GoTo MenuExportError
        cmd.Filter = EquatesFilter
        cmd.DefaultExt = "exp"
        cmd.ShowSave
        cmd.Flags = cdlOFNOverwritePrompt
        filename = cmd.filename
    On Error GoTo 0
    SaveEquates filename
  Exit Sub
MenuExportError:
  Exit Sub

End Sub

Private Sub Form_OLEDragDrop(Data As DataObject, Effect As Long, Button As Integer, Shift As Integer, X As Single, Y As Single)
    DragDrop Data, Effect, Button, Shift, X, Y
End Sub

Private Sub Form_OLEDragOver(Data As DataObject, Effect As Long, Button As Integer, Shift As Integer, X As Single, Y As Single, State As Integer)
    DragOver Data, Effect, Button, Shift, X, Y, State
End Sub

Private Sub lstLabels_OLEDragDrop(Data As DataObject, Effect As Long, Button As Integer, Shift As Integer, X As Single, Y As Single)
    DragDrop Data, Effect, Button, Shift, X, Y
End Sub

Private Sub lstLabels_OLEDragOver(Data As DataObject, Effect As Long, Button As Integer, Shift As Integer, X As Single, Y As Single, State As Integer)
    DragOver Data, Effect, Button, Shift, X, Y, State
End Sub

Private Sub lstLookFor_OLEDragDrop(Data As DataObject, Effect As Long, Button As Integer, Shift As Integer, X As Single, Y As Single)
    DragDrop Data, Effect, Button, Shift, X, Y
End Sub

Private Sub lstLookFor_OLEDragOver(Data As DataObject, Effect As Long, Button As Integer, Shift As Integer, X As Single, Y As Single, State As Integer)
    DragOver Data, Effect, Button, Shift, X, Y, State
End Sub

Private Sub txtname_OLEDragDrop(Data As DataObject, Effect As Long, Button As Integer, Shift As Integer, X As Single, Y As Single)
    DragDrop Data, Effect, Button, Shift, X, Y
End Sub

Private Sub txtname_OLEDragOver(Data As DataObject, Effect As Long, Button As Integer, Shift As Integer, X As Single, Y As Single, State As Integer)
    DragOver Data, Effect, Button, Shift, X, Y, State
End Sub

Private Sub txtaddress_OLEDragDrop(Data As DataObject, Effect As Long, Button As Integer, Shift As Integer, X As Single, Y As Single)
    DragDrop Data, Effect, Button, Shift, X, Y
End Sub

Private Sub txtaddress_OLEDragOver(Data As DataObject, Effect As Long, Button As Integer, Shift As Integer, X As Single, Y As Single, State As Integer)
    DragOver Data, Effect, Button, Shift, X, Y, State
End Sub

Private Sub cmdupdate_OLEDragDrop(Data As DataObject, Effect As Long, Button As Integer, Shift As Integer, X As Single, Y As Single)
    DragDrop Data, Effect, Button, Shift, X, Y
End Sub

Private Sub cmdupdate_OLEDragOver(Data As DataObject, Effect As Long, Button As Integer, Shift As Integer, X As Single, Y As Single, State As Integer)
    DragOver Data, Effect, Button, Shift, X, Y, State
End Sub

Private Sub chkoverride_OLEDragDrop(Data As DataObject, Effect As Long, Button As Integer, Shift As Integer, X As Single, Y As Single)
    DragDrop Data, Effect, Button, Shift, X, Y
End Sub

Private Sub chkoverride_OLEDragOver(Data As DataObject, Effect As Long, Button As Integer, Shift As Integer, X As Single, Y As Single, State As Integer)
    DragOver Data, Effect, Button, Shift, X, Y, State
End Sub

Private Sub cmdaddlookfor_OLEDragDrop(Data As DataObject, Effect As Long, Button As Integer, Shift As Integer, X As Single, Y As Single)
    DragDrop Data, Effect, Button, Shift, X, Y
End Sub

Private Sub cmdaddlookfor_OLEDragOver(Data As DataObject, Effect As Long, Button As Integer, Shift As Integer, X As Single, Y As Single, State As Integer)
    DragOver Data, Effect, Button, Shift, X, Y, State
End Sub

Private Sub cmdclearlookfor_OLEDragDrop(Data As DataObject, Effect As Long, Button As Integer, Shift As Integer, X As Single, Y As Single)
    DragDrop Data, Effect, Button, Shift, X, Y
End Sub

Private Sub cmdclearlookfor_OLEDragOver(Data As DataObject, Effect As Long, Button As Integer, Shift As Integer, X As Single, Y As Single, State As Integer)
    DragOver Data, Effect, Button, Shift, X, Y, State
End Sub

Private Sub txtlookfor_OLEDragDrop(Data As DataObject, Effect As Long, Button As Integer, Shift As Integer, X As Single, Y As Single)
    DragDrop Data, Effect, Button, Shift, X, Y
End Sub

Private Sub txtlookfor_OLEDragOver(Data As DataObject, Effect As Long, Button As Integer, Shift As Integer, X As Single, Y As Single, State As Integer)
    DragOver Data, Effect, Button, Shift, X, Y, State
End Sub

Private Sub txtoverride_OLEDragDrop(Data As DataObject, Effect As Long, Button As Integer, Shift As Integer, X As Single, Y As Single)
    DragDrop Data, Effect, Button, Shift, X, Y
End Sub

Private Sub txtoverride_OLEDragOver(Data As DataObject, Effect As Long, Button As Integer, Shift As Integer, X As Single, Y As Single, State As Integer)
    DragOver Data, Effect, Button, Shift, X, Y, State
End Sub

Private Sub label1_OLEDragDrop(Data As DataObject, Effect As Long, Button As Integer, Shift As Integer, X As Single, Y As Single)
    DragDrop Data, Effect, Button, Shift, X, Y
End Sub

Private Sub label1_OLEDragOver(Data As DataObject, Effect As Long, Button As Integer, Shift As Integer, X As Single, Y As Single, State As Integer)
    DragOver Data, Effect, Button, Shift, X, Y, State
End Sub

Private Sub label2_OLEDragDrop(Data As DataObject, Effect As Long, Button As Integer, Shift As Integer, X As Single, Y As Single)
    DragDrop Data, Effect, Button, Shift, X, Y
End Sub

Private Sub label2_OLEDragOver(Data As DataObject, Effect As Long, Button As Integer, Shift As Integer, X As Single, Y As Single, State As Integer)
    DragOver Data, Effect, Button, Shift, X, Y, State
End Sub

Private Sub label3_OLEDragDrop(Data As DataObject, Effect As Long, Button As Integer, Shift As Integer, X As Single, Y As Single)
    DragDrop Data, Effect, Button, Shift, X, Y
End Sub

Private Sub label3_OLEDragOver(Data As DataObject, Effect As Long, Button As Integer, Shift As Integer, X As Single, Y As Single, State As Integer)
    DragOver Data, Effect, Button, Shift, X, Y, State
End Sub

Private Sub lbllookforcode_OLEDragDrop(Data As DataObject, Effect As Long, Button As Integer, Shift As Integer, X As Single, Y As Single)
    DragDrop Data, Effect, Button, Shift, X, Y
End Sub

Private Sub lbllookforcode_OLEDragOver(Data As DataObject, Effect As Long, Button As Integer, Shift As Integer, X As Single, Y As Single, State As Integer)
    DragOver Data, Effect, Button, Shift, X, Y, State
End Sub




Sub LoadEquates(filename As String)
    Dim I As Long
    Dim ListSize As Long
    Dim TextLine As String
    Dim EqualsPoint As Long
    Open filename For Input As #1
        chkOverride.Value = vbUnchecked
        lstLookFor.Clear
        FlushLabels
        Do While Not EOF(1)
            Line Input #1, TextLine
            If Left(TextLine, 1) = ";" Then
                If TextLine = ";override=true" Then chkOverride.Value = vbChecked
                If Left(TextLine, 14) = ";overrideaddr=" Then
                    txtOverride.Text = Mid(TextLine, 15)
                End If
                If Left(TextLine, 17) = ";lookforlistsize=" Then
                    ListSize = Val(Mid(TextLine, 18))
                    lstLookFor.Clear
                    Line Input #1, TextLine
                    For I = 0 To ListSize - 1
                        If Left(TextLine, 1) <> ";" Then Exit For
                        lstLookFor.AddItem Mid(TextLine, 2)
                    Next
                End If
            Else
                Dim Name As String, Addr As Long
                EqualsPoint = InStr(1, TextLine, "= $")
                If EqualsPoint = 0 Then
                    EqualsPoint = InStr(1, TextLine, ".EQU  $")
                    If EqualsPoint > 0 Then
                        Name = Trim(Left(TextLine, EqualsPoint - 1))
                        Addr = Val("&H" + Trim(Mid(TextLine, EqualsPoint + 7)) + "&")
                        AddEquate Name, Addr
                    End If
                Else
                    If EqualsPoint > 0 Then
                        Name = Trim(Left(TextLine, EqualsPoint - 1))
                        Addr = Val("&H" + Trim(Mid(TextLine, EqualsPoint + 3)) + "&")
                        AddEquate Name, Addr
                    End If
                End If
            End If
        Loop
    Close #1
    
End Sub

Sub SaveEquates(filename As String)
    Dim I As Long
    Open filename For Output As #1
        If chkOverride.Value = vbChecked Then
            Print #1, ";override=true"
            Print #1, ";overrideaddr=" + txtOverride.Text
        End If
        If lstLookFor.ListCount > 0 Then
            Print #1, ";lookforlistsize=" + Trim(Str(lstLookFor.ListCount))
            For I = 0 To lstLookFor.ListCount - 1
                Print #1, ";" + lstLookFor.List(I)
            Next
        End If
        For I = 0 To NumEquates - 1
            Print #1, Pad(EquateList(I).Name, 32) + " = $" + Hex4(EquateList(I).Address)
        Next
    Close #1
    
End Sub
