/*
 * QUSOFT MICROSYSTMES
 * Moka
 * Copyright 2002 Frdric Brown
 */
 
/*
 *  This file is part of Moka API.
 *
 *  Moka API is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  Moka API is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Moka API; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package moka.x;

import moka.lang.Object;
import moka.x.Style;

/**
 * The Styled interface provides methods used to deal with styled
 * components.
 *
 * @author  Frdric Brown
 * @version 1.0, 2002-11-18
 * @since   MDK1.0a
 */
public interface Styled {	
	/** The style for this component.  Should be only read.*/
	public short style;
 	
 	/**
 	 * Sets the style of the component.
 	 *
 	 * @param style The style of the component.
 	 */
 	public void setStyle (short style) {
 		this.style = style;
 		
		this.repaint = true;
		if (this.visible && this.parent) {
			this.parent.onRefresh();
		}
 	}
}