/*
 * QUSOFT MICROSYSTMES
 * Moka
 * Copyright 2003 Frdric Brown
 */

/*
 *  This file is part of Moka API.
 *
 *  Moka API is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  Moka API is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Moka API; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package moka.x;

import moka.x.Captioned;
import moka.x.Menu;
import moka.event.EventListener;

/**
 * MenuItem class represents an item of a menu.
 * All items in a menu must belong to the class MenuItem, or one of its subclasses.
 *
 * @author  Frdric Brown
 * @version 1.0, 2003-10-12
 * @since   MDK2.1
 */
public class MenuItem extends EventListener {
	/** The caption of the MenuItem. Should be only read.*/
 	public String caption;

	/** The event listener for this MenuItem.*/
	public EventListener listen;

 	/** The menu this MenuItem belongs*/
 	//public Menu menu;

	/** The mnemonic associated with this MenuItem.*/
	public char mnemonic;

	/*
	 * Constructs a new MenuItem.
	 */
	public MenuItem () {
		this("");
	}

	/*
	 * Constructs a new MenuItem specifying its caption.
	 *
	 * @param caption the MenuItem's caption.
	 */
	public MenuItem (String caption) {
		this.caption = caption;
		//this.menu = null;
		this.listen = null;
		this.mnemonic = 0;
	}

 	/**
 	 * Sets the caption of the MenuItem.
 	 *
 	 * @param caption The caption of the MenuItem.
 	 */
 	public void setCaption (String caption) {
 		this.caption.finalize();
 		this.caption = caption;
 	}

	/**
	 * Frees the memory of system ressources used by this MenuItem
	 * object.
	 */
	public void finalize() {
		this.caption.finalize();

		super.finalize();
	}
}