/*
 * QUSOFT MICROSYSTMES
 * Moka
 * Copyright 2003 Frdric Brown
 */

/*
 *  This file is part of Moka API.
 *
 *  Moka API is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  Moka API is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Moka API; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package moka.x;

import moka.x.Container;
import moka.x.Menu;

/**
 * The MenuBar class represents a menu bar bound to a frame. In order to associate the menu bar with a Frame object, call the frame's setMenuBar method. 
 *
 * @author  Frdric Brown
 * @version 1.0, 2003-10-12
 * @since   MDK2.1
 */
public class MenuBar extends Container {
	/** Use to retain where to put a new element.*/
	//private short pos;

	/**
	 * Constructs a newly allocated MenuBar.
	 */
	public MenuBar () {
		super();
		//this.pos = 2;
	}
	
	/**
	 * Paints the foreground of the MenuBar.
	 */
	public native void paintForeground () {
		DrawLine(0, this->height-1, this->width-1, this->height-1, A_NORMAL);
	}

	/**
	 * Adds the specified Menu to this MenuBar.
	 *
	 * @param m the Menu to add to this MenuBar.
	 */
	public void add (Menu m) {
		this.add((Component)m);
		
		this.update();
	}
	/**
	 * Updates the disposition of the Menus on the Menubar.
	 */
	public void update () {
		short width;
		short pos = 0;
		Component c = this.child;
		Menu m;
		
		while (c) {
			if ((c instanceof Menu) && c.visible) {
				m = (Menu)c;
				width = GEM.getFontWidth(m.font) * native.strlen(m->caption->value);
		
				if (width > GEM.LCD_WIDTH-2) {
					width = GEM.LCD_WIDTH-3;
				}
				
				if (m.x != pos || m.y != 1 || m.width != (width + 2) || m.height != 13) {
					m.setBounds(pos, 1, width + 2, 13);
				}
				
				pos += width + 4;
			}
			c = c.next;
		}
	}
	
	/**
	 * Removes the specified Menu from this MenuBar.
	 *
	 * @param m the Menu to remove from this MenuBar
	 */
	public void remove (Menu m) {
		this.remove((Component)m);
		
		this.update();
	}
}