/*
 * QUSOFT MICROSYSTMES
 * Moka
 * Copyright 2002 Frdric Brown
 */
 
/*
 *  This file is part of Moka API.
 *
 *  Moka API is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  Moka API is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Moka API; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package moka.x;

import moka.x.GEM;
import moka.lang.Character;
import moka.x.CaptionedComponent;
import moka.x.Colored;

/**
 * Label is a text label component.
 *
 * @author  Frdric Brown
 * @version 1.0, 2002-11-14
 * @since   MDK1.0a
 */
public class Label extends CaptionedComponent implements Colored {

	/*
	 * Constructs a new label.
	 */
	public Label () {
		this("");
		
	}
	
	/*
	 * Constructs a new label specifying its caption.
	 *
	 * @param caption the label's caption.
	 */
	public Label (String caption) {
		super(caption);
		this.bgColor = Color.WHITE_COLOR;
		this.fgColor = Color.BLACK_COLOR;
		
	}
	
	/**
	 * Paints the label.
	 */
	public native void paint() {
		int h;
		int w;
		
		long int pos;
		long int len = strlen(this->caption->value);
		void* begin = this->caption->value;
		void* end = memchr(begin, this->mnemonic, len);
		
		if (!end) {
			end = memchr(begin, Character_toLowerCase_char(this->mnemonic), len);
		}
		
		if (this->font != Font_FONT_SYSTEM) {
			FontSetSys(this->font);
		}
		
		if (this->bgColor != Color_WHITE_COLOR) {
			ScrRectFill(&(SCR_RECT){{0, 0, this->width-1, this->height-1}}, GEM_vScrRect, this->bgColor);
		}
		
		DrawStr(0, 0, this->caption->value, A_NORMAL);
		
		if (this->fgColor == Color_WHITE_COLOR) {
			DrawStr(0, 0, this->caption->value, A_XOR);
		}
		
		
		if (end && this->enabled) {
			h = GEM_getFontHeight_short_int(this->font);
			w = GEM_getFontWidth_short_int(this->font);
			
			pos = (long int)((char*)end - (char*)begin);
			
			DrawLine(w * pos, 1 + h , w * (pos + 1), 1 + h, A_NORMAL);
		}
		
		if (this->font != Font_FONT_SYSTEM) {
			FontSetSys(GEM_gem->systemFont);
		}
	}
}