/*
 * QUSOFT MICROSYSTMES
 * Moka
 * Copyright 2002 Frdric Brown
 */

/*
 *  This file is part of Moka API.
 *
 *  Moka API is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  Moka API is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Moka API; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package moka.x;

import moka.x.CaptionedComponent;
import moka.x.List;

/**
 * List class is a list selection component.
 *
 * @author  Frdric Brown
 * @version 1.0, 2003-03-07
 * @since   MDK1.0a
 */
public class ComboBox extends List {

	/**
	 * Constructs a new ComboBox.
	 */
	public ComboBox () {
		super();
	}

	/**
	 * Paints the ComboBox.
	 */
	public native void paint() {
		TString* str;

		if (this->index >= 0) {
			if (this->font != Font_FONT_SYSTEM) {
				FontSetSys(this->font);
			}

			str = this->items->array[this->index]->toString_(this->items->array[this->index]);

			DrawStr(2, 2, str->value, A_NORMAL);

			str->finalize_(str);

			if (this->font != Font_FONT_SYSTEM) {
				FontSetSys(GEM_gem->systemFont);
			}
		}

		DrawClipRect (&(WIN_RECT){0, 0,  this->width - 1, this->height - 1}, GEM_vScrRect, A_NORMAL);

		DrawLine(this->width - 13, 1, this->width - 13, this->height - 2, A_NORMAL);

		Sprite8(this->width - 11, 2, 8, (unsigned char*)ICON_DNARROW, GEM_gem->port, SPRT_OR);
	}

	/**
	 * This method is invoked by the GEM when the user interacts
	 * with the ComboBox.
	 */
	public native void use () {
		short i;
		TContainer* ct = this->parent;
		short y = this->y;
		short x = this->x;
		short height = GEM_getFontHeight_short_int(this->font) + 1;
		short x0;
		short y0;
		short x1;
		short y1;
		short max;
		short key;
		TString* str;

		if (!this->enabled) {
			return;
		}

		while (ct) {
			y = y + ct->y;
			x = x + ct->x;
			ct = ct->parent;
		}

		if (this->items->size * height + y + this->height <= GEM_USABLE_HEIGHT) {
			x0 = x;
			y0 = y + this->height - 1;
			x1 = x + this->width - 1;
			y1 = y0 + this->items->size * height + 1;

		}
		else if (this->items->size * height - y < 0) {
			x0 = x;
			y0 = y - this->items->size * height - 2;
			x1 = x + this->width - 1;
			y1 = y;
		}
		else {
			x0 = x;
			y0 = 0;
			x1 = x + this->width - 1;
			y1 = this->items->size * height + 1;
		}

		ScrRectFill(&(SCR_RECT){{x0 + 1, y0 + 1, x1 - 1, y1 - 1}}, ScrRect, A_REVERSE);

		if (this->font != Font_FONT_SYSTEM) {
			FontSetSys(this->font);
		}

		max = (y1 - y0) / height;

		for (i = 0; i < this->items->size && i < max; i++) {
			str = this->items->array[i]->toString_(this->items->array[i]);

			DrawStr(x0 + 2, y0 + 2 + i * height, str->value, A_NORMAL);

			str->finalize_(str);
		}

		if (this->font != Font_FONT_SYSTEM) {
			FontSetSys(GEM_gem->systemFont);
		}

		//DrawClipRect (&(WIN_RECT){x0, y0,  x1, y1}, ScrRect, A_NORMAL);

		DrawLine ( x0 , y0 , x1 , y0 , A_NORMAL ) ;
		DrawLine ( x0 , y0 , x0 , y1 , A_NORMAL ) ;
		DrawLine ( x0 , y1 , x1 , y1 , A_NORMAL ) ;
		DrawLine ( x1 , y0 , x1 , y1 , A_NORMAL ) ;

		key = GEM_gem->useCursor_(GEM_gem);

		if (key == KEY_ENTER && GEM_gem->cursorY >= y0 && GEM_gem->cursorY <= y1 && GEM_gem->cursorX >= x0 && GEM_gem->cursorX <= x1) {
			i = (GEM_gem->cursorY - y0) / (GEM_getFontHeight_short_int(this->font) + 1);
			if (i < this->items->size && i != this->index) {
				this->setSelectedIndex_short_int(this, i);
			}
		}

		CaptionedComponent->use_((TCaptionedComponent*)this);

		GEM_gem->repaint = TRUE;
	}
}