/*
 * QUSOFT MICROSYSTMES
 * Moka
 * Copyright 2002 Frdric Brown
 */
 
/*
 *  This file is part of Moka API.
 *
 *  Moka API is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  Moka API is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Moka API; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package moka.x;

/**
 * Color class encapsulates colors.
 *
 * @author  Frdric Brown
 * @version 1.0, 2002-11-18
 * @since   MDK1.0a
 */
public abstract final class Color {
	/** Draw in black.*/
	public static final short BLACK_COLOR = A_NORMAL;
	/** Draw in white.*/
	public static final short WHITE_COLOR = A_REVERSE;
	/** Draw the invert color.*/
	public static final short INVERT_COLOR = A_XOR;
	/** Draw using a vertical shading pattern.*/
	public static final short SHADE_V_COLOR = A_SHADE_V;
	/** Draw using a horizontal shading pattern.*/
	public static final short SHADE_H_COLOR = A_SHADE_H;
	/** Draw using a negative slope diagonal shading pattern.*/
	public static final short SHADE_NS_COLOR = A_SHADE_NS;
	/** Draw using a positive slope diagonal shading pattern.*/
	public static final short SHADE_PS_COLOR = A_SHADE_PS;
}