/*
 * QUSOFT MICROSYSTMES
 * Moka
 * Copyright 2002 Frdric Brown
 */
 
/*
 *  This file is part of Moka API.
 *
 *  Moka API is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  Moka API is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Moka API; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package moka.x;

import moka.x.GEM;
import moka.lang.Character;
import moka.x.CaptionedComponent;

/**
 * CheckBox class is a check box component.
 *
 * @author  Frdric Brown
 * @version 1.0, 2002-11-18
 * @since   MDK1.0a
 */
public class CheckBox extends CaptionedComponent {
	/** Is the CheckBox Checked.  Should be only read.*/
	public boolean checked;
	
	/*
	 * Constructs a new CheckBox.
	 */
	public CheckBox () {
		this("");
	}
	
	/*
	 * Constructs a new CheckBox specifying its caption.
	 *
	 * @param caption the CheckBox's caption.
	 */
	public CheckBox (String caption) {
		super(caption);
		this.checked = false;
	}
	
	/**
	 * Paints the CheckBox.
	 */
	public native void paint() {
		int h;
		int w;
		long int pos;
		long int len = strlen(this->caption->value);
		short int mv;
		void* begin = this->caption->value;
		void* end = memchr(begin, this->mnemonic, len);
		
		if (!end) {
			end = memchr(begin, Character_toLowerCase_char(this->mnemonic), len);
		}
		
		DrawClipRect (&(WIN_RECT){0, 0,  9, 9}, GEM_vScrRect, A_NORMAL);
		
		if (this->checked) {
			Sprite8(1, 1, 8, (unsigned char*)ICON_CHECK, GEM_gem->port, SPRT_OR);
		}
		
		if (this->font != Font_FONT_SYSTEM) {
			FontSetSys(this->font);
		}
		
		w = GEM_getFontWidth_short_int(this->font);
		
		mv = ((int)(10 / w) + 1);
		
		DrawStr(mv * w, 2, this->caption->value, A_NORMAL);
		
		
		if (end && this->enabled) {
			h = GEM_getFontHeight_short_int(this->font);
			
			pos = (long int)((char*)end - (char*)begin) + mv;
			
			DrawLine ( w * pos , 3 + h , w * ( pos + 1 ) , 3 + h , A_NORMAL );
		}
		
		if (this->font != Font_FONT_SYSTEM) {
			FontSetSys(GEM_gem->systemFont);
		}
	}
	
	/**
	 * This method is invoked by the GEM when the user interacts
	 * with the CheckButton.
	 */
	public void use () {
		if (this.enabled) {
			this.setChecked((boolean)!this.checked);
		
			if (this.listen) {
				this.listen.eventTriggered(this);
			}
		}
	}
	
	/**
	 * Sets if the CheckBox is checked.
	 * 
	 * @param b true if the CheckBox should be checked, false otherwise.
	 */
	public void setChecked (boolean b) {
		this.checked = b;
		
		this.repaint = true;
		if (this.visible && this.parent) {
			this.parent.onRefresh();
		}
	}
}