/*
 * QUSOFT MICROSYSTMES
 * Moka
 * Copyright 2002 Frdric Brown
 */
 
/*
 *  This file is part of Moka API.
 *
 *  Moka API is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  Moka API is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Moka API; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package moka.x;

import moka.x.Captioned;
import moka.x.Component;

/**
 * The CaptionedComponent class represents a component that shows a caption.
 *
 * @author  Frdric Brown
 * @version 1.0, 2002-11-13
 * @since   MDK1.0a
 */
public abstract class CaptionedComponent extends Component implements Captioned {

	/*
	 * Constructs a new CaptionedComponent.
	 */
	public CaptionedComponent () {
		this("");
	}
	
	/*
	 * Constructs a new CaptionedComponent specifying its caption.
	 *
	 * @param caption the CaptionedComponent's caption.
	 */
	public CaptionedComponent (String caption) {
		super();
		this.caption = caption;
		this.font = Font.FONT_SYSTEM;
	}
	
    /**
     * Free the memory and system ressources used by this CaptionedComponent.
     */
	public void finalize () {
		this.caption.finalize();
		super.finalize();
	}
}