/*
 * QUSOFT MICROSYSTMES
 * Moka
 * Copyright 2002 Frdric Brown
 */
 
/*
 *  This file is part of Moka API.
 *
 *  Moka API is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  Moka API is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Moka API; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package moka.x;

import moka.x.GEM;
import moka.lang.Character;
import moka.x.CaptionedComponent;
import moka.x.Styled;

/**
 * Button class is a push button component.
 *
 * @author  Frdric Brown
 * @version 1.0, 2002-11-04
 * @since   MDK1.0a
 */
public class Button extends CaptionedComponent implements Styled {
	
	/*
	 * Constructs a new button.
	 */
	public Button () {
		this("");
	}
	
	/*
	 * Constructs a new button specifying its caption.
	 *
	 * @param caption the button's caption.
	 */
	public Button (String caption) {
		super(caption);
		this.style = Style.RAISED_STYLE;
	}
	
	/**
	 * Paints the button.
	 */
	public native void paint() {
		int h;
		int w;
		int x1 = this->width - 1;
		int y1 = this->height - 1;
		short style = this->style;
		long int pos;
		long int len = strlen(this->caption->value);
		void* begin = this->caption->value;
		void* end = memchr(begin, this->mnemonic, len);
		
		if (!end) {
			end = memchr(begin, Character_toLowerCase_char(this->mnemonic), len);
		}
		
		if (style == Style_RAISED_STYLE) {
			style = Style_NORMAL_STYLE;
			DrawLine(1, (y1-1), (x1-1), (y1-1), A_NORMAL);
			DrawLine((x1-1), (y1-2), (x1-1), 1, A_NORMAL);
		}
		
		DrawClipRect (&(WIN_RECT){0, 0,  x1, y1}, GEM_vScrRect, A_NORMAL | style);
		/*DrawLine(0, 0, x1, 0, A_NORMAL);
		DrawLine(0, y1, x1, y1, A_NORMAL);
		DrawLine(0, 1, 0, (y1-1), A_NORMAL);
		DrawLine(x1, 1, x1, (y1-1), A_NORMAL);*/
		
		if (this->font != Font_FONT_SYSTEM) {
			FontSetSys(this->font);
		}
		
		DrawStr(2, 2, this->caption->value, A_NORMAL);
		
		
		if (end && this->enabled) {
			h = GEM_getFontHeight_short_int(this->font);
			w = GEM_getFontWidth_short_int(this->font);
			
			pos = (long int)((char*)end - (char*)begin);
			
			DrawLine(2 + w * pos, 3 + h , 2 + w * (pos + 1), 3 + h, A_NORMAL);
		}
		
		if (this->font != Font_FONT_SYSTEM) {
			FontSetSys(GEM_gem->systemFont);
		}
	}
}