/*
 * QUSOFT MICROSYSTMES
 * Moka
 * Copyright 2002 Frdric Brown
 */
 
/*
 *  This file is part of Moka API.
 *
 *  Moka API is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  Moka API is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Moka API; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package moka.x;

import moka.x.Component;
import moka.x.Bordered;
import moka.x.Colored;

/**
 * Bevel class is a decorative Bevel.
 *
 * @author  Frdric Brown
 * @version 1.0, 2002-11-17
 * @since   MDK1.0a
 */
public class Bevel extends Component implements Bordered, Colored {	
	
	/*
	 * Constructs a new bevel.
	 */
	public Bevel () {
		super();
		this.bgColor = Color.WHITE_COLOR;
		this.border = Border.RAISED_BORDER;
	}
	
	/**
	 * Paints the bevel.
	 */
	public native void paint() {
		short x1 = this->width - 1;
		short y1 = this->height - 1;
		
		switch (this->border) {
			case Border_RAISED_BORDER : {
				DrawLine(x1, 0, x1, y1, A_NORMAL);
				DrawLine(0, y1, (x1-1), y1, A_NORMAL);
				x1 = x1 - 1;
				y1 = y1 - 1;
			}
			case Border_NORMAL_BORDER : {
				DrawClipRect (&(WIN_RECT){0, 0,  x1, y1}, GEM_vScrRect, A_NORMAL);
				x1 = x1 - 1;
				y1 = y1 - 1;
				break;
			}
		}
		
		if (this->bgColor != Color_WHITE_COLOR) {
			ScrRectFill(&(SCR_RECT){{1, 1, x1, y1}}, GEM_vScrRect, this->bgColor);
		}
	}
}