/*
 * QUSOFT MICROSYSTMES
 * Moka
 * Copyright 2002 Frdric Brown
 */
 
/*
 *  This file is part of Moka API.
 *
 *  Moka API is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  Moka API is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Moka API; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package moka.util;
 
import moka.lang.Object;
import moka.io.Serializable;
 
 /**
 * Class <code>SerialEntry</code> represents a SerialList entry.
 *
 * @author  Frdric Brown
 * @version 1.0, 2002-11-11
 * @since   MDK1.0a
 */
public class SerialEntry extends Serializable {
	/**  The object linked to this entry.*/
	protected Serializable element;
	/** The next entry in the LinkedList.*/
	protected SerialEntry next;

	/**
	 * Creates a new SerialEntry for the specified element.
	 * 
	 * @param element The specified element
	 * @param previous The previous entry
	 * @param next The next entry
	 */
	public SerialEntry (Serializable element, SerialEntry next) {
		this.element = element;
		this.next = next;
	}
}
 
 