/*
 * QUSOFT MICROSYSTMES
 * Moka
 * Copyright 2002 Frdric Brown
 */

/*
 *  This file is part of Moka API.
 *
 *  Moka API is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  Moka API is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Moka API; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
 package moka.util;

 import moka.lang.Object;
 import moka.util.Entry;

 /**
 * Class <code>Enumeration</code> represents an object generates a
 * series of elements, one at a time. Successive calls to the
 * <code>nextElement</code> method return successive elements of the
 * series.
 *
 * @author  Frdric Brown
 * @version 1.01, 2004-11-20
 * @since   MDK1.0a
 */
public class Enumeration {
	/** The first element of the enumeration.*/
	protected Entry first;
	/** The current element.*/
	protected Entry current;

	/**
     * Tests if this enumeration contains more elements.
     *
     * @return  <code>true</code> if and only if this enumeration object
     *           contains at least one more element to provide;
     *          <code>false</code> otherwise.
     */
	public boolean hasMoreElements() {
     	return this.current;
    }

    /**
     * Returns the next element of this enumeration if this enumeration
     * object has at least one more element to provide.
     *
     * @return     the next element of this enumeration or null if there is
     * no such element.
     */
	public Object nextElement() {
		Object elem;


		if (this.current) {
			elem = this.current.element;
			this.current = this.current.next;
		}

		else {
			elem = null;
		}

		return elem;
	}

    /**
     * Frees the memory used by this object.
     */
    public native void finalize () {
		TEntry *c = this->first;
		TEntry *n;

		while (c) {
			n = c->next;
			free(c);
			c = n;
		}

    	free(this);
    }
}