/*
 * QUSOFT MICROSYSTMES
 * Moka
 * Copyright 2004 Frdric Brown
 */

/*
 *  This file is part of Moka API.
 *
 *  Moka API is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  Moka API is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Moka API; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package moka.lang;

/**
 * When applied to the main class of a program, this interface disable the object instanciation support
 * to remove overhead. It means that only static members of the classes will be accessible. Such as many features
 * of Moka are implemented with object oriented desing (IOStreams, Moka's Strings, GEM), this will restrain the
 * API uses available.
 *
 * This interface can be useful to use benefits of Moka language extension over C (method overloading, removal of unused methods),
 * without adding any overhead. Again, as main Moka's features are OO, this will restrain the range
 * of available facilities.
 *
 * @author  Frdric Brown
 * @version 1.0, 2004-04-01
 * @since   MDK2.2
 */
public interface No_Instanciation {

}