/*
 * QUSOFT MICROSYSTMES
 * Moka
 * Copyright 2003 Frdric Brown
 */

/*
 *  This file is part of Moka API.
 *
 *  Moka API is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  Moka API is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Moka API; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
 
/*Alias for acos (a).*/
#define Math_acos_double(a) acos(a)
/*Alias for asin (a).*/
#define Math_asin_double(a) asin(a)
/*Alias for atan (a).*/
#define Math_atan_double(a) atan(a)
/*Alias for atan2 (a).*/
#define Math_atan2_double_double(x, y) atan2(x, y)
/*Alias for ceil (a).*/
#define Math_ceil_double(a) ceil(a)
/*Alias for cos (a).*/
#define Math_cos_double(a) cos(a)
/*Alias for exp (a).*/
#define Math_exp_double(a) exp(a)
/*Alias for floor (a).*/
#define Math_floor_double(a) floor(a)
/*Alias for log (a).*/
#define Math_log_double(a) log(a)
/*Alias for pow (a, b).*/
#define Math_pow_double_double(a, b) pow(a, b)
/*Alias for randomize ().*/
#define Math_randomize_() randomize()
/*Alias for random ().*/
#define Math_random_() rand() / ((double) RAND_MAX)
/*Alias for rand ().*/
#define Math_rand_() rand()
/*Alias for random (num).*/
#define Math_rand_short_int(num) random(num)
/*Alias for round (a).*/
#define Math_round_double(a) (long int)floor(a + 0.5)
/*Alias for sin (a).*/
#define Math_sin_double(a) sin(a)
/*Alias for sqrt (a).*/
#define Math_sqrt_double(a) sqrt(a)
/*Alias for tan (a).*/
#define Math_tan_double(a) tan(a)
/*Alias for angdeg / 180.0 * Math_PI.*/
#define Math_toRadians_double(angdeg) angdeg / 180.0 * Math_PI
/*Alias for angrad * 180.0 / Math_PI.*/
#define Math_toDegrees_double(angrad) angrad * 180.0 / Math_PI
