/*
 * QUSOFT MICROSYSTMES
 * Moka
 * Copyright 2003 Frdric Brown
 */
 
/*
 *  This file is part of Moka API.
 *
 *  Moka API is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  Moka API is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Moka API; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package moka.lang;

import moka.lang.Object;
import moka.lang.String;

/**
 * The Error class has been designed to deal with error handling.
 *
 * @author  Frdric Brown
 * @version 1.1, 2003-07-10
 * @since   MDK2.0
 */
public class Error {

	/** Used by the system for the error handling feature.*/
	private static volatile Error error = null;

	finally {
		if (Error.error) {
			Error.error.finalize();
		}
	}

	/**
	 * The error code.
	 */
	private short errCode;

    /**
     * Constructs a newly allocated <code>Error</code> object that
     * can be used in a try ... catch block.
     *
     * @param   errCode   a TI-Basic error number.
     */
    public Error(short errCode) {
		this.errCode = errCode;
    }
    
    /**
     * Constructs a newly allocated <code>Error</code> object that
     * can be used in a try ... catch block.
     *
     *@since MDK2.1
     */
    public Error() {
		this.errCode = native.UNKNOWN_TAG_ERROR;
    }
    
    /**
     * Returns a <code>String</code> object representing this
     * <code>Error</code>'s TI-Basic error message string.
     *
     * @return  a string representation of this object.
     */
    public String toString() {
		return new String((char[]) native.find_error_message (this->errCode));
    }
    
    
}