/*
 * QUSOFT MICROSYSTMES
 * Moka
 * Copyright 2002 Frdric Brown
 */
 
/*
 *  This file is part of Moka API.
 *
 *  Moka API is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  Moka API is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Moka API; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package moka.io;

import moka.io.IOStream;

/**
 * This class implements the hability to serialize
 * and write an object to a stream and interfaces the
 * hability to read and deserialize an object from a stream.
 *
 * @author  Frdric Brown
 * @version 1.0, 2002-10-02
 * @since   MDK1.0a
 */
public abstract class Serializable {

	/**
	 * Serializes and writes this object to a given stream.
	 * Since this method is an abstract one, subclasses of Serializable
	 * must overwrite this method.
	 *
	 @param ios The stream to write to
	 */
	public abstract void serialize (IOStream ios);
	
	/**
	 * Reads and deserializes an object from a given stream.
	 * Since this method is an abstract one, subclasses of Serializable
	 * must overwrite this method.
	 *
	 @param ios The stream to read from
	 @return The object read
	 */
	public abstract Object deserialize (IOStream ios);
}