/*
 * QUSOFT MICROSYSTMES
 * Moka
 * Copyright 2003 Frdric Brown
 */
 
/*
 *  This file is part of Moka API.
 *
 *  Moka API is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  Moka API is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Moka API; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package moka.io;

import moka.io.Graphics;

/**
 * Gray class encapsulates grayscale levels. Also it contains useful methods to deal with grayscale more efficiently than
 * by using class moka.io.Graphics.
 *
 * @author  Frdric Brown
 * @version 1.1, 2004-03-17
 * @since   MDK2.1
 */
public final class Gray {
	/** Draw in black.*/
	public static final short OFF = 0;
	/** Draw in black.*/
	public static final short BLACK = 1;
	/** Draw in light gray.*/
	public static final short LIGHT_GRAY = 2;
	/** Draw in dark gray.*/
	public static final short DARK_GRAY = 3;
	
	/** The light grayscale plane. */
	public static final short LIGHT_PLANE = native.LIGHT_PLANE;
	/** The dark grayscale plane. */
	public static final short DARK_PLANE = native.DARK_PLANE;
	
	private Gray() {}
	
	/**
	 * Forces graphics routines to use selected plane. 
	 * 
	 * GraySetAMSPlane forces all graphics routines (from moka.io.Graph class) to draw into the grayscale plane plane (valid values are Gray.LIGHT_PLANE and Gray.DARK_PLANE). 
	 *
	 * @param plane The grayscale plane
	 */
	/* Alias implemented for GraySetAMSPlane */
	public abstract static void setAMSPlane (short plane) ;
	
	/**	
	 * Deactivates grayscale mode. 
     *
 	 * GrayOff deactivates grayscale mode. If grayscale mode is not activated, this method does nothing. 
	 */
	public native static void off () {
		GrayOff();
		Graphics_graymode = FALSE;
	}
	
	/**
	 * Activates grayscale mode with four shades of gray. 
	 * GrayOn activates grayscale mode.
	 *
	 * @return false if there was an error in switching to grayscale mode, otherwise false.
	 */
	public native static boolean on () {
		GrayOn();
		Graphics_graymode = TRUE;
	}
	
	/**
	 * Checks whether grayscale mode is active. 
	 *
	 * @return true if grayscale mode is active, otherwise FALSE
	 */
	/* Alias implemented for GrayCheckRunning */
	public abstract static boolean checkRunning () ;
}