/*
 * QUSOFT MICROSYSTMES
 * Moka
 * Copyright 2002 Frdric Brown
 */

/*
 *  This file is part of Moka API.
 *
 *  Moka API is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  Moka API is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Moka API; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package moka.event;

import moka.lang.Object;

/**
 * The EventListener interfaces for receiving events.
 * The class that is interested in processing an event
 * implements this interface, and the object created with that
 * class is registered with an other object.  When the event
 * occurs, that object's <code>eventTriggered</code> method is
 * invoked.
 *
 * @author  Frdric Brown
 * @version 1.0, 2002-10-08
 * @since   MDK1.0a
 */
public abstract class EventListener {

    /**
     * Invoked when an event is triggered.
     *
     * @param sender The object who triggered the event.
     */
	public abstract void eventTriggered(Object sender) ;
}