#if MOKACLASS_MAINCLASS_IMPLEMENTSINTERFACE_Use_GarbageCollection || MOKAUSES_GarbageCollector

void ADT_GarbageCollector_init(ADT_GarbageCollector *this) {
	this->array = malloc(sizeof(void *) * ADT_GarbageCollector_INITIALCAPACITY);
	this->size  = 0;
	this->max   = ADT_GarbageCollector_INITIALCAPACITY;
}

/*void ADT_GarbageCollector_dispose(ADT_GarbageCollector *this) {
	free(this->array);
}*/

void * ADT_GarbageCollector_add(ADT_GarbageCollector *this, void *ptr) {
	if (this->size == this->max) {
		this->max += ADT_GarbageCollector_INCREMENT;
		this->array = realloc(this->array, (sizeof(void *) * this->max));
	}

	this->array[this->size++] = ptr;

	return ptr;
}

void * ADT_GarbageCollector_rem(ADT_GarbageCollector *this, void *ptr) {
	long int i = 0;

	while ((i < this->size) && (this->array[i] != ptr)) i++;

	if (i < this->size) {
		memmove(this->array + i, this->array + i + 1, (this->size - i - 1) * sizeof (void *));

		this->size--;
	}

	return ptr;
}

#if MOKASTATICMETHOD_System_malloc_long_int || MOKASTATICMETHOD_System_free_void_p
	void ADT_GarbageCollector_clearPtrs(ADT_GarbageCollector *this) {
		while (this->size) System_free_void_p(this->array[0]);

		free(this->array);
	}
#endif /* MOKASTATICMETHOD_System_malloc_long_int || MOKASTATICMETHOD_System_free_void_p */

void ADT_GarbageCollector_clearObjects(ADT_GarbageCollector *this) {
	#if MOKACLASS_MAINCLASS_IMPLEMENTSINTERFACE_Use_GarbageCollection
		while (this->size) ((TObject *)this->array[0])->finalize_((TObject *)this->array[0]);
	#else
		while (this->size--) ((TObject *)this->array[this->size])->finalize_((TObject *)this->array[this->size]);
	#endif /* MOKACLASS_MAINCLASS_IMPLEMENTSINTERFACE_Use_GarbageCollection */

	free(this->array);
}

#endif /* MOKACLASS_MAINCLASS_IMPLEMENTSINTERFACE_Use_GarbageCollection || MOKAUSES_GarbageCollector */
