/*
 * QUSOFT MICROSYSTMES
 * Moka
 * Copyright 2003 Frdric Brown
 */
 
/*
 *  This file is part of Moka API.
 *
 *  Moka API is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  Moka API is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Moka API; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package moka.lang;

/**
 * The Use_GarbageCollection is a limited implementation of the garbage collection feature.
 * When implemented by the main class of a project, Moka will install a garbage collector that will
 * finalize all un-finalized objects before the program returns. This feature will slow the program
 * and make it bigger. It can be usefull to somebody that don't want to worry about freeing its
 * unused ressources and is not worried about lacking memory.
 *
 * @author  Frdric Brown
 * @version 1.0, 2003-07-19
 * @since   MDK2.01
 */
public interface Use_GarbageCollection {	

}