/*
 * QUSOFT MICROSYSTMES
 * Moka
 * Copyright 2003 Frdric Brown
 */

/*
 *  This file is part of Moka API.
 *
 *  Moka API is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  Moka API is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Moka API; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <stdio.h>

/*Alias for printf("\n").*/
#define System_println_() printf("\n")
/*Alias for printf("%c", c).*/
#define System_print_char_p(s) printf(s)
#define System_println_char_p(s) printf(s)
#define System_print_char(c) printf("%c", c)
/*Alias for printf("%c\n", c).*/
#define System_println_char(c) printf("%c\n", c)
/*Alias for printf("%i", (short int)b).*/
#define System_print_byte(b) printf("%i", (short int)b)
/*Alias for printf("%i\n", (short int)b).*/
#define System_println_byte(b) printf("%i\n", (short int)b)
/*Alias for printf("%i", s).*/
#define System_print_short_int(s) printf("%i", s)
/*Alias for printf("%i\n", s).*/
#define System_println_short_int(s) printf("%i\n", s)
/*Alias for printf("%ld", i).*/
#define System_print_long_int(i) printf("%ld", i)
/*Alias for printf("%ld\n", i).*/
#define System_println_long_int(i) printf("%ld\n", i)
#if MOKACLASS_MAINCLASS_IMPLEMENTSINTERFACE_Use_GarbageCollection
	#define System_malloc_long_int(size) GarbageCollector_addPtr_void_p(malloc(size))
	#define System_free_void_p(ptr) free(GarbageCollector_remPtr_void_p(ptr))
#else
	#define System_malloc_long_int(size) malloc(size)
	#define System_free_void_p(ptr) free(ptr)
#endif /* MOKACLASS_MAINCLASS_IMPLEMENTSINTERFACE_Use_GarbageCollection */