/*
 * QUSOFT MICROSYSTMES
 * Moka
 * Copyright 2002 Frdric Brown
 */
 
/*
 *  This file is part of Moka API.
 *
 *  Moka API is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  Moka API is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Moka API; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package moka.lang;

import moka.lang.String;

/**
 * Class <code>Object</code> is the root of the class hierarchy. 
 * Every class has <code>Object</code> as a superclass. All objects
 * implement the methods of this class. 
 *
 * @author  Frdric Brown
 * @version 1.0, 2002-08-29
 * @since   MDK1.0a
 */
public class Object {
	
    /**
     * Returns a string representation of the object. In general, the 
     * <code>toString</code> method returns a string that 
     * "textually represents" this object. The result should 
     * be a concise but informative representation that is easy for a 
     * person to read.
     * It is recommended that all subclasses override this method.
     * <p>
     * The <code>toString</code> method for class <code>Object</code> 
     * returns a string consisting of the name of the class of which the 
     * object is an instance, the at-sign character `<code>@</code>', and 
     * the memory address of the object.
     *
     * @return  a string representation of the object.
     */
    public native String toString () {
    	char ptrStr[12];
    	TString* string;
    	int len = strlen(this->class);
    	char* buffer = malloc(len + strlen(ptrStr) + 2);
    	
    	sprintf(ptrStr, "%lp", this);
    	
    	strcpy(buffer, this->class);
    	strcat(buffer, "@");
    	strcat(buffer, ptrStr);
    	
    	string = TString_char_p_BOOL(buffer, FALSE);
    	
    	return string;
    }
    
    /**
     * Returns the class' name of an object.
     *
     * @return  the string that contains the class' name
     *          of the object.
     */
    public final native String getClassName() {
    	return TString_char_p(this->class);
    }
    
    /**
     * Returns the object's size in bytes.
     *
     * @return  the object's size in bytes.
     */
    /*public final native short getSizeOf() {
    	return this->size_of;
    }*/
    
    /**
     * Called on an object to free the memory or system ressources
     * used by this object.
     * A subclass overrides the <code>finalize</code> method to dispose of
     * system resources or to perform other cleanup.
     */
    public native void finalize() {
    	free(this);
    }
    
    /**
     * Indicates whether some other object is "equal to" this one.
     * <p>
     * The <code>equals</code> method implements an equivalence relation: 
     * <ul>
     * <li>It is <i>reflexive</i>: for any reference value <code>x</code>, 
     *     <code>x.equals(x)</code> should return <code>true</code>. 
     * <li>It is <i>symmetric</i>: for any reference values <code>x</code> and 
     *     <code>y</code>, <code>x.equals(y)</code> should return 
     *     <code>true</code> if and only if <code>y.equals(x)</code> returns 
     *     <code>true</code>. 
     * <li>It is <i>transitive</i>: for any reference values <code>x</code>, 
     *     <code>y</code>, and <code>z</code>, if <code>x.equals(y)</code>
     *     returns  <code>true</code> and <code>y.equals(z)</code> returns 
     *     <code>true</code>, then <code>x.equals(z)</code> should return 
     *     <code>true</code>. 
     * <li>It is <i>consistent</i>: for any reference values <code>x</code> 
     *     and <code>y</code>, multiple invocations of <tt>x.equals(y)</tt>
     *     consistently return <code>true</code> or consistently return 
     *     <code>false</code>, provided no information used in
     *     <code>equals</code> comparisons on the object is modified.
     * <li>For any non-null reference value <code>x</code>, 
     *     <code>x.equals(null)</code> should return <code>false</code>.
     * </ul>
     * <p>
     * The <tt>equals</tt> method for class <code>Object</code> implements 
     * the most discriminating possible equivalence relation on objects; 
     * that is, for any reference values <code>x</code> and <code>y</code>, 
     * this method returns <code>true</code> if and only if <code>x</code> and 
     * <code>y</code> refer to the same object (<code>x==y</code> has the 
     * value <code>true</code>). 
     *
     * @param   obj   the reference object with which to compare.
     * @return  <code>true</code> if this object is the same as the obj
     *          argument; <code>false</code> otherwise.
     */
    public boolean equals(Object obj) {
			return this == obj;
    }
}