(*
 * QUSOFT MICROSYSTMES
 * Moka
 * Copyright 2003 Frdric Brown
 *)

(*
 *  This file is part of Moka.
 *
 *  Moka is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.

 *  Moka is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with Moka; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *)

(*
 * Util unit defines some classes used in the conversion process.  TVector class
 * and TStringVector are widly used all over this program to work with array of classes,
 * string tokens, methods, etc.
 *)

unit Util;

interface

const
vPrivate   = 0;
vDefault   = 1;
vProtected = 2;
vPublic    = 3;

type

  TVector = class

  private

  public
    data: array of TObject;
    size: Longint;
    incr: Longint;
    max: Longint;

    constructor Create; overload;
    constructor Create(max: Longint; incr: Longint); overload;

    procedure add(o: TObject); overload;
    procedure add(o: TObject; pos: Longint); overload;
    function get(pos: Longint): TObject; overload;
    function rem(o: TObject): TObject; overload;
    function rem(pos: Longint): TObject; overload;
  end;

  TStringVector = class 

  private

  public
    strData: array of AnsiString;
    size: Longint;
    incr: Longint;
    max: Longint;
    constructor Create; overload;
    constructor Create(max: Longint; incr: Longint); overload;
    procedure add(o: AnsiString); overload;
    procedure add(vec: TStringVector); overload;
    procedure add(o: AnsiString; pos: Longint); overload;
    procedure add(vec: TStringVector; i: Longint); overload;
    function get(pos: Longint): AnsiString; overload;
    function rem(o: AnsiString): AnsiString; overload;
    function rem(pos: Longint): AnsiString; overload;

    function getStr(pos: Longint): AnsiString;
    function contains(str: AnsiString): Boolean;
    function setStr(o: AnsiString; pos: Longint): AnsiString;
    function copy(): TStringVector;
    function toString(): AnsiString;
    function toText(): AnsiString;
  end;

implementation

uses SysUtils, Globals, Funcs;

constructor TStringVector.Create;
begin
  size := 0;
  max  := 5;
  incr := 10;
  SetLength(strdata, max);
end;

constructor TStringVector.Create(max: Longint; incr: Longint);
begin
  size      := 0;
  self.max  := max;
  self.incr := incr;
  SetLength(strdata, max);
end;

function TStringVector.toString(): AnsiString;
var
  i: Longint;
  str: AnsiString;
begin
  for i := 0 to size - 1 do
  begin
    str := str + getStr(i) + ' ';
  end;

  toString := str;
end;

function TStringVector.toText(): AnsiString;
var
  i: Longint;
  str: AnsiString;
  wd: AnsiString;
  lv: Longint;
begin
  lv := 1;

  str := tabulate(lv);

  for i := 0 to size - 1 do
  begin
    wd := getStr(i);
    if (wd = ';') or (wd = '{') or isComment(wd) then
    begin
      if (wd = '{') then
      begin
        lv := lv + 1;
      end;
      str := str + wd + ' ' + newLine + tabulate(lv);
      continue;
    end;
    if (wd = '}') then
    begin
      lv := lv - 1;
      str := str + newLine + tabulate(lv) + wd + ' ' + newLine + tabulate(lv);
      continue;
    end;
    str := str + wd + ' ';
  end;

  toText := str;
end;

function TStringVector.contains(str: AnsiString): Boolean;
var
  size: Longint;
  i: Longint;
begin
    size := self.size - 1;

    for i := 0 to size do
    begin
      if (str = getStr(i)) then
      begin
        contains := true;
        exit;
      end;
    end;

    contains := false;
end;

function TStringVector.copy(): TStringVector;
var
  v: TStringVector;
  i: Longint;
  size: Longint;
begin
    v := TStringVector.Create(self.max, self.incr);

    size := self.size - 1;

    for i := 0 to size do
    begin
      v.strData[i] := self.strData[i];
    end;

    v.size := self.size;

    copy := v;
end;

function TStringVector.setStr(o: AnsiString; pos: Longint): AnsiString;
begin
  setStr := get(pos);

  strData[pos] := o;
end;

function TStringVector.getStr(pos: Longint): AnsiString;
begin
    getStr := get(pos);
end;

procedure TStringVector.add(o: AnsiString);
begin
  add(o, size);
end;

procedure TStringVector.add(vec: TStringVector; i: Longint);
var
  n: Longint;
begin
  for n := vec.size - 1 downto 0 do
  begin
    add(vec.getStr(n), i);
  end;
end;

procedure TStringVector.add(vec: TStringVector);
var
  i: Longint;
begin
  for i := 0 to vec.size - 1 do
  begin
    add(vec.getStr(i));
  end;
end;

procedure TStringVector.add(o: AnsiString; pos: Longint);
var
  i: Longint;
begin
  if (size >= max) then
  begin
     SetLength(strData, max + incr);
     max := max + incr;
  end;

  for i := size - 1 downto pos do
  begin
    strData[i + 1] := strData[i];
  end;

  strData[pos] := o;
  size := size + 1;
end;

function TStringVector.get(pos: Longint): AnsiString;
begin
  if (pos < size) then
  begin
    get := strData[pos];
  end
  else
  begin
    get := '';
  end;
end;

function TStringVector.rem(o: AnsiString): AnsiString;
var
  i: Longint;
begin
  for i := 0 to size do
  begin
    if strData[i] = o then
    begin
      rem := rem(i);
      exit;
    end;
  end;

  rem := '';
end;

function TStringVector.rem(pos: Longint): AnsiString;
var
  i: Longint;
  size: Longint;
begin
  size := self.size - 1;

  rem := strData[pos];

  for i := pos + 1 to size do
  begin
    strData[i-1] := strData[i];
  end;

  self.size := self.size - 1;
end;

constructor TVector.Create;
begin
  size := 0;
  max  := 5;
  incr := 10;
  SetLength(data, max);
end;

constructor TVector.Create(max: Longint; incr: Longint);
begin
  size      := 0;
  self.max  := max;
  self.incr := incr;
  SetLength(data, max);
end;

procedure TVector.add(o: TObject);
begin
  add(o, size);
end;

procedure TVector.add(o: TObject; pos: Longint);
var
  i: Longint;
begin
  if (size >= max) then
  begin
     SetLength(data, max + incr);
     max := max + incr;
  end;

  for i := size - 1 downto pos do
  begin
    data[i + 1] := data[i];
  end;

  data[pos] := o;
  size := size + 1;
end;

function TVector.get(pos: Longint): TObject;
begin
   get := data[pos];
end;

function TVector.rem(o: TObject): TObject;
var
  i: Longint;
begin
  for i := 0 to size do
  begin
    if data[i] = o then
    begin
      rem := rem(i);
      exit;
    end;
  end;

  rem := nil;
end;

function TVector.rem(pos: Longint): TObject;
var
  i: Longint;
  size: Longint;
begin

  size := self.size - 1;

  rem := data[pos];

  for i := pos + 1 to size do
  begin
    data[i-1] := data[i];
  end;

  self.size := self.size - 1;
end;

end.
