(*
 * QUSOFT MICROSYSTMES
 * Moka
 * Copyright 2003 Frdric Brown
 *)

(*
 *  This file is part of Moka.
 *
 *  Moka is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.

 *  Moka is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with Moka; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *)

(*
 * OutputStream unit defines the OutputStream class that is used to log all the
 * operations made by the compiler (they are displayed in verbose mode).
 *)

unit OutputStream;

interface

type
  TOutputStream = class

  private

  public
    procedure print(s: AnsiString); virtual;
    procedure println(s: AnsiString); virtual;
  end;

  TStdOut = class (TOutputStream)

  private
    verbose: Boolean;
  public
    constructor Create (verbose: Boolean);
    procedure print(s: AnsiString); override;
    procedure println(s: AnsiString); override;
  end;

implementation

procedure TOutputStream.print(s: AnsiString);
begin
  Write(s);
end;

procedure TOutputStream.println(s: AnsiString);
begin
  Writeln(s);
end;

constructor TStdOut.Create(verbose: Boolean);
begin
  self.verbose := verbose;
end;

procedure TStdOut.print(s: AnsiString);
begin
  if verbose then
  begin
    Write(s);
  end;
end;

procedure TStdOut.println(s: AnsiString);
begin
  if verbose then
  begin
    Writeln(s);
  end;
end;

end.
