(*
 * QUSOFT MICROSYSTMES
 * Moka
 * Copyright 2003 Frdric Brown
 *)

(*
 *  This file is part of Moka.
 *
 *  Moka is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.

 *  Moka is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with Moka; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *)

(*
 * Optimizer unit contains the optimizeCode method that is called to uptimize
 * the source code.  In the optimization process, all the methods or attributes
 * that the compiler 'knows' unused are removed from the project.  
 *)

unit Optimizer;

interface

uses Reflect, Util;

procedure optimizeCode;
procedure setUsed(b: Boolean);
procedure remove;
procedure optMeth(cl: TClasse; m: TMethode; pv: TParameterVector);
procedure optAttr(cl: TClasse; a: TAttribute; pv: TParameterVector);

implementation

uses SysUtils, Globals, Funcs, Tokenizer;

procedure optimizeCode;
var
  i: Longint;
  cl: TClasse;
  m: TMethode;
begin
  os.println('');

  vecOpt := TStringVector.Create;

  setUsed(false);

  if not mainCl.impl('No_Instanciation') then
  begin

  if isClass('GEM') then
  begin
    cl := vecCl.return('GEM');
    cl.setInst(true);
    cl.attr.return('gem').used := true;
    m  := cl.return('finalize_');
    optMeth(cl, m, TParameterVector.Create);
    m  := cl.return('GEM_');
    optMeth(cl, m, TParameterVector.Create);
    m  := cl.return('setStarted_BOOL');
    optMeth(cl, m, TParameterVector.Create);
  end;

  (*if isClass('Interrupt') then
  begin
    cl := vecCl.return('Interrupt');
    m  := cl.return('onInterrupt_');
    optMeth(cl, m, TParameterVector.Create);
  end;  *)

  if mainCl.ifs.contains('Use_GarbageCollection') then
  begin
    cl := vecCl.return('Object');
    cl.setInst(true);
    for i := 0 to vecCl.size - 1 do
    begin
      cl := vecCl.getClass(i);
      m  := cl.return('finalize_');
      if (m <> nil) then
      begin
        optMeth(cl, m, TParameterVector.Create);
      end;
    end;
    vecOpt.add('finalize_');
    (*if (vecCl.return('System') <> nil) and ((vecCl.return('System').return('malloc_long_int') <> nil) or (vecCl.return('System').return('free_void_p') <> nil)) then
    begin
      cl := vecCl.return('System');
      m := cl.return('free_void_p');
      optMeth(cl, m, TParameterVector.Create);
    end; *)
  end;
  
  end;  //No_Instanciation
  
  //m := mainCl.return('main_');
  m := mainCl.meth.getMVec('main').getMeth(0);
  optMeth(mainCl, m, TParameterVector.Create);

  if (m.getMorph = '_String_p') then
  begin
    cl := vecCl.return('System');
    m := cl.return('getMainArgs_');
    optMeth(cl, m, TParameterVector.Create);
  end;

  (*if not mainCl.impl('No_Instanciation') then
  begin        *)

  for i := 0 to vecCl.size - 1 do
  begin
    cl := vecCl.getClass(i);
    m := cl.return('finally_');
    if (m <> nil) then
    begin
      optMeth(cl, m, TParameterVector.Create);
    end;
    cl := vecCl.getClass(i);
    m := cl.return('static_');
    if (m <> nil) then
    begin
      optMeth(cl, m, TParameterVector.Create);
    end;
    (*if cl.hasValuedAttr then
    begin
      m  := cl.return(cl.name + '_');
      optMeth(cl, m, TParameterVector.Create);

      m := vecCl.return('Object').return('finalize_');
      optMeth(cl, m, TParameterVector.Create);
    end;*)
  end;
  //end;

  (* 2004/07/03
  if isClass('GEM') and (vecCl.return('GEM').attr.return('System_AMS') <> nil) then
  begin
    if (vecCl.return('GEM').attr.return('USABLE_HEIGHT').used) then
    begin
      vecCl.return('GEM').attr.return('LCD_HEIGHT').used := true;
    end;
    if (vecCl.return('GEM').attr.return('LCD_LINE_BYTES').used) or (vecCl.return('GEM').attr.return('LCD_HEIGHT').used) or (vecCl.return('GEM').attr.return('LCD_WIDTH').used) then
    begin
      if isClass('System') then
      begin
        vecCl.return('System').attr.return('CALCULATOR').used := true;
      end;
    end;
  end;

  if isClass('System') and (vecCl.return('GEM').attr.return('System_AMS') <> nil) then
  begin
     if (vecCl.return('GEM').attr.return('System_AMS').used) then
     begin
       vecCl.return('System').attr.return('ENTRIES').used := true;
     end;


  end;
  *)
  remove;
end;

procedure optAttr(cl: TClasse; a: TAttribute; pv: TParameterVector);
var
  words: TStringVector;
  ind: Longint;
  len: Longint;
  i: Longint;
  n: Longint;
  z: Longint;
  fc: TClasse;
  fa: TAttribute;
  fm: TMethode;
begin
    if a.used then
    begin
      exit;
    end;

    os.println('Attribute ' + a.name + ' of class ' + cl.name + ' is used in the project.');
    a.used := true;

    if (isClass(a.rType)) then
    begin
      os.println('Class ' + a.rType + ' is used in the project.');
      vecCl.return(a.rType).setInst(true);
    end;

    words := getStringVector(a.text);

    ind := 0;
    len := words.size;
    while (ind < len) do
    begin
      if not vecOpt.contains(words.getStr(ind)) then
      begin
        vecOpt.add(words.getStr(ind));
      end
      else
      begin
        ind := ind + 1;
        continue;
      end;

      if not est(words.getStr(ind), vecKey) then
      begin
        if (isClass(classIdent(words, ind))) then
        begin
          os.println('Class ' + classIdent(words, ind) + ' is used in the project.');
          vecCl.return(classIdent(words, ind)).setInst(true);
        end;

        if (ind + 1 >= len) or not (words.getStr(ind+1) = '(') then
        begin
          for i := 0 to vecCl.size - 1 do
          begin
            fc := vecCl.getClass(i);
            for n := 0 to fc.attr.size - 1 do
            begin
              fa := fc.attr.getAttr(n);
              if ((fc.name + '_' + fa.name) = words.getStr(ind)) or (fa.name = words.getStr(ind)) then
              begin
                optAttr(fc, fa, pv);
              end;
            end;
          end;
        end
        else
        begin
          for i := 0 to vecCl.size - 1 do
          begin
            fc := vecCl.getClass(i);
            for n := 0 to fc.meth.size - 1 do
            begin
              fm := fc.meth.getMeth(n);
              if (fm.getSign(fc) = words.getStr(ind)) then
              begin
                if fc.inter then
                begin
                  os.println('Interface ' + fc.name + ' is used in the project.');
                  fc.setInst(true);
                  fm.used := true;
                  for z := 0 to vecCl.size - 1 do
                  begin
                    if (vecCl.getClass(z).return(fm.name + fm.getMorph) <> nil) then
                    begin
                      if not (vecCl.getClass(z).inter) then
                      begin
                        os.println('Class ' + vecCl.getClass(z).name + ' is used in the project.');
                        vecCl.getClass(z).setInst(true);
                        optMeth(vecCl.getClass(z), vecCl.getClass(z).return(fm.name + fm.getMorph), fm.params);
                      end;
                    end;
                  end;
                end
                else
                begin
                  optMeth(fc, fm, fm.params);
                end;
              end
//else if (fm.rType = '') and ( (('T' + fc.name + fm.getMorph) = words.getStr(ind)) or (fc.name + '_' + fm.getMorph = words.getStr(ind)) or  (('Constructor_T' + fc.name + fm.getMorph) = words.getStr(ind))) then
else if (fm.rType = '') and ( (('T' + fc.name + fm.getMorph) = words.getStr(ind)) or (fc.name + '_' + fm.getMorph = words.getStr(ind)) ) then
              begin
                os.println('Class ' + fc.name + ' is used in the project.');
                fc.setInst(true);
                optMeth(fc, fm, fm.params);
              end;
            end;
          end;
        end;
      end;
      ind := ind + 1;
    end;
end;

procedure optMeth(cl: TClasse; m: TMethode; pv: TParameterVector);
var
  words: TStringVector;
  ind: Longint;
  len: Longint;
  i: Longint;
  n: Longint;
  z: Longint;
  fc: TClasse;
  fa: TAttribute;
  fm: TMethode;
begin
    if m.used then
    begin
      exit;
    end;

    os.println('Method ' + m.name + ' of class ' + cl.name + ' is used in the project.');
    m.used := true;

    words := getStringVector(m.text);

    ind := 0;
    len := words.size;
    while (ind < len) do
    begin
      if not vecOpt.contains(words.getStr(ind)) then
      begin
        vecOpt.add(words.getStr(ind));
      end
      else
      begin
        ind := ind + 1;
        continue;
      end;
      if not est(words.getStr(ind), vecKey) then
      begin
        if (isClass(classIdent(words, ind))) then
        begin
          os.println('Class ' + classIdent(words, ind) + ' is used in the project.');
          vecCl.return(classIdent(words, ind)).setInst(true);
        end;
        if (ind + 1 >= len) or not (words.getStr(ind+1) = '(') then
        begin
          for i := 0 to vecCl.size - 1 do
          begin
            fc := vecCl.getClass(i);
            for n := 0 to fc.attr.size - 1 do
            begin
              fa := fc.attr.getAttr(n);
              if ((fc.name + '_' + fa.name) = words.getStr(ind)) or (fa.name = words.getStr(ind)) then
              begin
                optAttr(fc, fa, pv);
              end;
            end;
          end;
        end
        else
        begin
          for i := 0 to vecCl.size - 1 do
          begin
            fc := vecCl.getClass(i);
            for n := 0 to fc.meth.size - 1 do
            begin
              fm := fc.meth.getMeth(n);
              if (fm.getSign(fc) = words.getStr(ind)) then
              begin
                if fc.inter then
                begin
                  os.println('Interface ' + fc.name + ' is used in the project.');
                  fc.setInst(true);
                  fm.used := true;
                  for z := 0 to vecCl.size - 1 do
                  begin
                    if (vecCl.getClass(z).return(fm.name + fm.getMorph) <> nil) then
                    begin
                      if not (vecCl.getClass(z).inter) then
                      begin
                        os.println('Class ' + vecCl.getClass(z).name + ' is used in the project.');
                        vecCl.getClass(z).setInst(true);
                        optMeth(vecCl.getClass(z), vecCl.getClass(z).return(fm.name + fm.getMorph), fm.params);
                      end;
                    end;
                  end;
                end
                else
                begin
                  optMeth(fc, fm, fm.params);
                end;
              end
//              else if (fm.rType = '') and ( (('T' + fc.name + fm.getMorph) = words.getStr(ind)) or (fc.name + '_' + fm.getMorph = words.getStr(ind)) or  (('Constructor_T' + fc.name + fm.getMorph) = words.getStr(ind))) then
              else if (fm.rType = '') and ( (('T' + fc.name + fm.getMorph) = words.getStr(ind)) or (fc.name + '_' + fm.getMorph = words.getStr(ind)) ) then
              begin
                os.println('Class ' + fc.name + ' is used in the project.');
                fc.setInst(true);
                optMeth(fc, fm, fm.params);
              end;
            end;
          end;
        end;
      end;
      ind := ind + 1;
    end;
end;

procedure setUsed(b: Boolean);
var
  i: Longint;
  n: Longint;
  cl: TClasse;
  m: TMethode;
  a: TAttribute;
begin
  for i := 0 to vecCl.size - 1 do
  begin
    cl := vecCl.getClass(i);
    cl.inst := false;
    for n := 0 to cl.attr.size - 1 do
    begin
      a := cl.attr.getAttr(n);
//      if (*a.stat and*)  not a.fin then
//      begin
        a.used := b;
//      end;
    end;
    for n := 0 to cl.meth.size - 1 do
    begin
      m := cl.meth.getMeth(n);
      m.used := b;
    end;
  end;
end;

procedure remove;
var
  i: Longint;
  n: Longint;
  cl: TClasse;
  m: TMethode;
  a: TAttribute;
begin
  for i := 0 to vecCl.size - 1 do
  begin
    cl := vecCl.getClass(i);
    os.println('Optimizing class ' + cl.name);
    for n := cl.attr.size - 1 downto 0 do
    begin
      a := cl.attr.getAttr(n);
      if not a.used and a.stat then
      begin
        os.println(#9 + 'Removing attribute ' + a.name);
        cl.attr.rem(n);
      end;
    end;
    for n := cl.meth.size - 1 downto 0 do
    begin
      m := cl.meth.getMeth(n);
      if not m.used or (not cl.inst and not m.stat) then
      begin
        os.println(#9 + 'Removing method ' + m.name);
        cl.meth.rem(n);
      end;
    end;
    if not cl.inst then
    begin
      os.println(#9 + 'Class ' + cl.name + ' is never instanciated in the project.');
      cl.fin := true;
      cl.abst := true;      
    end;
  end;
end;

end.
