
(*
 * QUSOFT MICROSYSTMES
 * Moka
 * Copyright 2003 Frdric Brown
 *)

(*
 *  This file is part of Moka.
 *
 *  Moka is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.

 *  Moka is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with Moka; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *)

(*
 * Main file, calls the required functions and procedure to convert the
 * specified java class to C source code.
 *)
program Moka;

{$APPTYPE CONSOLE}

uses
  SysUtils,
  Tokenizer in 'Tokenizer.pas',
  Funcs in 'Funcs.pas',
  Globals in 'Globals.pas',
  OutputStream in 'OutputStream.pas',
  Decoder in 'Decoder.pas',
  Converter in 'Converter.pas',
  Optimizer in 'Optimizer.pas',
  Coder in 'Coder.pas',
  Reflect in 'Reflect.pas',
  Util in 'Util.pas';

var
mokaCopy: AnsiString;
mainFileName: AnsiString;
profileFile: AnsiString;
//st: TTokenizer;
pCount: Longint;
pPos : Longint;
param: AnsiString;
verbose: Boolean;
//thencomp: Boolean;
ttime0: TTimeStamp;
ttime1: TTimeStamp;
time0: TTimeStamp;
time1: TTimeStamp;
clCount: Longint;

begin
  { Default parameters }
  verbose  := false;
  optimize := true;
  legacy := false;
//  fmi := FileExists(configDir + pathSeparator + 'ApiVersion');  //Default setted later
  fmiSet := false;

  //thencomp  := true;
  dirSrc   := GetCurrentDir();
  //clCount := MaxLongint;

  initValues;

  profileFile := readFileAsString('conf' + pathSeparator + 'profile.default');

  pCount := ParamCount;
  pPos   := 1;

  while (pCount > 1) do
  begin
    param := ParamStr(pPos);
    pPos := pPos + 1;
    if (param = '!') then
    begin
      param := param + ParamStr(pPos);
      pPos := pPos + 1;
      pCount := pCount - 1;
    end;
    if (param = '!-o') then
    begin
      optimize := false;
    end
    else if (param = '-o') then
    begin
      optimize := true;
    end
    else if (param = '!-v') then
    begin
      verbose := false;
    end
    else if (param = '-v') then
    begin
      verbose := true;
    end
    else if (param = '!-l') then
    begin
      legacy := false;
    end
    else if (param = '-l') then
    begin
      legacy := true;
    end
    else if (param = '!-f') then
    begin
      fmi := false;
      fmiSet := true;
    end
    else if (param = '-f') then
    begin
      fmi := true;
      fmiSet := true;
    end
    else if (param = '--profile') then
    begin
      if pCount > 2 then
      begin
        profileFile := ParamStr(pPos);
      end
      else
      begin
        Writeln('Expecting profile directory name after --profile.');
        exit;
      end;

      if not DirectoryExists(profileFile) then
      begin
        Writeln('Unable to find specified profile directory (' + profileFile + ').');
        exit;
      end;

      pPos := pPos + 1;
      pCount := pCount - 1;
    end;
    (*
    else if (param = '!-c') then
    begin
      thencomp := false;
    end
    else if (param = '-c') then
    begin
      thencomp := true;
    end;
    *)
    pCount := pCount - 1;
  end;

  mokaVer  := readFileAsString('conf' + pathSeparator + 'Version');
  mokaCopy := readFileAsString('conf' + pathSeparator + 'Copyright');
  apiDir   := profileFile + pathSeparator + 'packages';
  configDir := profileFile + pathSeparator + 'conf';
  apiVer   := readFileAsString(configDir + pathSeparator + 'ApiVersion');

  if (not fmiSet) then
  begin
    fmi := FileExists(configDir + pathSeparator + 'fast_method_invocation');
  end;

  Writeln('Moka object oriented language compiler v' + mokaVer);
  Writeln('Moka API v' + apiVer);
  Writeln(mokaCopy);
  Writeln('');

  if (ParamCount < 1) then
  begin
    Writeln('Syntax : Moka [[!]-o] [[!]-v] [-l] [[!]-f] <Main class name>');
    Writeln('-o : Optimize the code (Enabled by default)');
    Writeln('-v : Verbose (Disabled by default)');
    Writeln('-l : Enforce backward compatibility');
    Writeln('-f : Use fast method invocation');
    Writeln('');
    Writeln('--profile <profile directory> : Use specified profile');             
    (*
    Writeln('-c : Convert then compile using TIGCC (Enabled by default)');
    Writeln('     tigcc.exe path is specified by the TIGCC_path file');
    *)

    exit;
  end;

  //if verbose then
  //begin
    ttime0 := DateTimeToTimeStamp(Time());
  //end;
  
  //initValues;

  os := TStdOut.Create(verbose);
  
  mainFileName := ParamStr(pPos);
  if not strEndsWith(mainFileName, '.java') then
  begin
    mainFileName := mainFileName + '.java';
  end;

  {// For test purpose
  st := TTokenizer.Create(readFileAsString(mainFileName));

  while (st.hasMoreToken()) do
  begin
    Writeln( st.nextToken() );
  end;

  halt;}

  dirProj := extractDirectory(mainFileName);
  dirOut  := dirProj + pathSeparator + 'TIGCC';

  time0 := DateTimeToTimeStamp(Time());
  decode(mainFileName);
  time1 := DateTimeToTimeStamp(Time());
  Writeln('Built object oriented model and converted code in ' + intToStr(time1.Time - time0.Time) + 'ms.');

  if (optimize and not MainCl.ifs.contains('No_Optimization')) or MainCl.ifs.contains('Use_Optimization') then
  begin
    time0 := DateTimeToTimeStamp(Time());
    Write('Optimizing code : ');
    setUsed(false);
    repeat
    begin
      clCount := countInstClasses();
      optimizeCode;
    end
    until ( clCount >= countInstClasses() ) ;
    time1 := DateTimeToTimeStamp(Time());
    Writeln('done in ' + intToStr(time1.Time - time0.Time) + 'ms.');
  end;

  if (MainCl.ifs.contains('Use_FastMethodInvocation')) then
  begin
    fmi := true;
  end;

  if (MainCl.ifs.contains('No_FastMethodInvocation')) then
  begin
    fmi := false;
  end;

  time0 := DateTimeToTimeStamp(Time());
  Write('Converting model to Enhanced C OOL : ');
  code();
  time1 := DateTimeToTimeStamp(Time());
  Writeln('done in ' + intToStr(time1.Time - time0.Time) + 'ms.');

  Write('Project built successfuly');
  ttime1 := DateTimeToTimeStamp(Time());
  Writeln(' in ' + intToStr(ttime1.Time - ttime0.Time) + 'ms.');
end.
