(*
 * QUSOFT MICROSYSTMES
 * Moka
 * Copyright 2003 Frdric Brown
 *)

(*
 *  This file is part of Moka.
 *
 *  Moka is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.

 *  Moka is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with Moka; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *)

(*
 * Globals unit contains the global ressources that can be accessed anywhere in the
 * code in any context.
 *)

unit Globals;

interface

Uses Reflect, OutputStream, Util;

var
  vecDigit: array [0..9] of char;
  vecEspa: array [0..4] of char;
  vecDelim: array [0..1] of char;
  vecEscDelim: array [0..1] of char;

  vecSym: array[0..46] of AnsiString;
  vecCDecla: array[0..4] of AnsiString;
  vecCMod: array[0..2] of AnsiString;
  vecVisi: array[0..2] of AnsiString;
  vecMMod: array[0..3] of AnsiString;
  vecAMod: array[0..2] of AnsiString;
  vecKey: array[0..72] of AnsiString;
  vecUni: array[0..1] of AnsiString;
  vecOpen: array[0..1] of AnsiString;
  vecClose: array[0..1] of AnsiString;
  vecGrp: array[0..3] of AnsiString;
  vecNat: array[0..2] of AnsiString;
  vecTypes: array[0..14] of AnsiString;
  vecPtr: array[0..2] of AnsiString;
  vecStatic: array[0..2] of AnsiString;
  vecASep: array[0..2] of AnsiString;

  vecT: TTypeVector;

  pathSeparator: char;
  newLine: AnsiString;

  mainCl: TClasse;
  vecCl: TClassVector;
  vecPk: TPackageVector;
  vecOpt: TStringVector;

  dirProj: AnsiString;
  dirSrc: AnsiString;
  dirOut: AnsiString;
  configDir: AnsiString;
  apiDir: AnsiString;
  mokaVer: AnsiString;
  apiVer: AnsiString;

  returnValue: Boolean = false;

  os: TOutputStream;

  cClass: TClasse;
  cAttr: TAttribute;
  cMeth: TMethode;
  mainMeth: TMethode;
  cTyped: TTyped;

  finalNum: Longint;

  optimize: Boolean;
  legacy: Boolean;
  fmi: Boolean;
  fmiSet: Boolean;

  usesGarbageCollector: Boolean;

  featF: TFileLinked;
  messF: TFileLinked;

  mainStr: AnsiString;

  globalObjects: TStringVector;
  
procedure initValues;

implementation

uses SysUtils;

procedure initValues;
var
  str: AnsiString;
  len: Longint;
  i: Longint;
begin
  featF := TFileLinked.Create;
  //featF.writeLine('/*' + newLine + ' * This file contains essential definitions for the Moka''s macro language.' + newLine + ' */');
  messF := TFileLinked.Create;
  //messF.writeLine('/*' + newLine + ' * This file is used by the dynamic binding facilities.' + newLine + ' */');

  mainStr := '';

  vecDigit[0] := '0';
  vecDigit[1] := '1';
  vecDigit[2] := '2';
  vecDigit[3] := '3';
  vecDigit[4] := '4';
  vecDigit[5] := '5';
  vecDigit[6] := '6';
  vecDigit[7] := '7';
  vecDigit[8] := '8';
  vecDigit[9] := '9';

  vecEspa[0] := ' ';
  vecEspa[1] := #10;
  vecEspa[2] := #9;
  vecEspa[3] := #13;

  vecDelim[0] := '"';
  vecDelim[1] := '''';

  vecEscDelim[0] := '\';
  vecEscDelim[1] := '\';

  vecSym[0] := '{';
  vecSym[1] := '}';
  vecSym[2] := '[';
  vecSym[3] := ']';
  vecSym[4] := '(';
  vecSym[5] := ')';
  vecSym[6] := '.';
  vecSym[7] := ',';
  vecSym[8] := ';';
  vecSym[9] := '/*';
  vecSym[10] := '*/';
  vecSym[11] := '//';
  vecSym[12] := '/';
  vecSym[13] := '*';
  vecSym[14] := '+';
  vecSym[15] := '-';
  vecSym[16] := '%';
  vecSym[17] := '<<';
  vecSym[18] := '>>';
  vecSym[19] := '<';
  vecSym[20] := '>';
  vecSym[21] := '!';
  vecSym[22] := '^';
  vecSym[23] := '||';
  vecSym[24] := '&&';
  vecSym[25] := '|';
  vecSym[26] := '&';
  vecSym[27] := '~';
  vecSym[28] := '++';
  vecSym[29] := '--';
  vecSym[30] := '=';
  vecSym[31] := '+=';
  vecSym[32] := '-=';
  vecSym[33] := '/=';
  vecSym[34] := '*=';
  vecSym[35] := '%=';
  vecSym[36] := '|=';
  vecSym[37] := '&=';
  vecSym[38] := '^=';
  vecSym[39] := '<<=';
  vecSym[40] := '>>=';
  vecSym[41] := '==';
  vecSym[42] := '!=';
  vecSym[43] := '>=';
  vecSym[44] := '<=';
  vecSym[45] := '?';
  vecSym[46] := ':';

  vecKey[0] := '{';
  vecKey[1] := '}';
  vecKey[2] := '[';
  vecKey[3] := ']';
  vecKey[4] := '(';
  vecKey[5] := ')';
  vecKey[6] := '.';
  vecKey[7] := ',';
  vecKey[8] := ';';
  vecKey[9] := '/*';
  vecKey[10] := '*/';
  vecKey[11] := '//';
  vecKey[12] := '/';
  vecKey[13] := '*';
  vecKey[14] := '+';
  vecKey[15] := '-';
  vecKey[16] := '%';
  vecKey[17] := '<<';
  vecKey[18] := '>>';
  vecKey[19] := '<';
  vecKey[20] := '>';
  vecKey[21] := '!';
  vecKey[22] := '^';
  vecKey[23] := '||';
  vecKey[24] := '&&';
  vecKey[25] := '|';
  vecKey[26] := '&';
  vecKey[27] := '~';
  vecKey[28] := '++';
  vecKey[29] := '--';
  vecKey[30] := '=';
  vecKey[31] := '+=';
  vecKey[32] := '-=';
  vecKey[33] := '/=';
  vecKey[34] := '*=';
  vecKey[35] := '%=';
  vecKey[36] := '|=';
  vecKey[37] := '&=';
  vecKey[38] := '^=';
  vecKey[39] := '<<=';
  vecKey[40] := '>>=';
  vecKey[41] := '==';
  vecKey[42] := '!=';
  vecKey[43] := '>=';
  vecKey[44] := '<=';
  vecKey[45] := '?';
  vecKey[46] := ':';
  vecKey[47] := 'public';
  vecKey[48] := 'protected';
  vecKey[49] := 'default';
  vecKey[50] := 'private';
  vecKey[51] := 'class';
  vecKey[52] := 'interface';
  vecKey[53] := 'final';
  vecKey[54] := 'abstract';
  vecKey[55] := 'static';
  vecKey[56] := 'native';
  vecKey[57] := 'for';
  vecKey[58] := 'while';
  vecKey[59] := 'return';
  vecKey[60] := 'switch';
  vecKey[61] := 'case';
  vecKey[62] := 'this';
  vecKey[63] := 'super';
  vecKey[64] := 'if';
  vecKey[65] := 'else';
  vecKey[66] := 'new';
  vecKey[67] := 'try';
  vecKey[68] := 'catch';
  vecKey[69] := 'throw';
  vecKey[70] := 'finally';
  vecKey[71] := 'local';
  vecKey[72] := 'global';

  vecCDecla[0] := 'public';
  vecCDecla[1] := 'class';
  vecCDecla[2] := 'interface';
  vecCDecla[3] := 'abstract';
  vecCDecla[4] := 'final';

  vecCMod[0] := 'abstract';
  vecCMod[1] := 'final';
  vecCMod[2] := 'public';

  vecVisi[0] := 'private';
  vecVisi[1] := 'protected';
  vecVisi[2] := 'public';

  vecMMod[0] := 'abstract';
  vecMMod[1] := 'final';
  vecMMod[2] := 'static';
  vecMMod[3] := 'native';

  vecAMod[0] := 'final';
  vecAMod[1] := 'static';
  vecAMod[2] := 'volatile';

  vecUni[0] := '.';
  vecUni[1] := '->';

  vecOpen[0] := '(';
  vecOpen[1] := '[';

  vecClose[0] := ')';
  vecClose[1] := ']';

  vecGrp[0] := '(';
  vecGrp[1] := '[';
  vecGrp[2] := ')';
  vecGrp[3] := ']';

  vecNat[0] := '(';
  vecNat[1] := '.';
  vecNat[2] := '{';

  vecPtr[0] := '[';
  vecPtr[1] := '*';

  vecASep[0] := ';';
  vecASep[1] := ',';

  vecStatic[0] := 'static';
  vecStatic[1] := 'finally';

  vecTypes[0] := 'boolean';
  vecTypes[1] := 'char';
  vecTypes[2] := 'byte';
  vecTypes[3] := 'short';
  vecTypes[4] := 'int';
  vecTypes[5] := 'long';
  vecTypes[6] := 'float';
  vecTypes[7] := 'double';
  vecTypes[8] := 'unsigned';
  vecTypes[9] := 'signed';
  vecTypes[10] := 'void';
  vecTypes[11] := 'ubyte';
  vecTypes[12] := 'ushort';
  vecTypes[13] := 'uint';
  vecTypes[14] := 'ulong';

  vecT := TTypeVector.Create;
  vecT.add(TMokaBoolean.Create);
  vecT.add(TMokaChar.Create);
  vecT.add(TMokaUByte.Create);
  vecT.add(TMokaUShort.Create);
  vecT.add(TMokaUInt.Create);
  vecT.add(TMokaULong.Create);
  vecT.add(TMokaFloat.Create);
  vecT.add(TMokaDouble.Create);
  vecT.add(TMokaString.Create);
  vecT.add(TMokaNull.Create);
  vecT.add(TMokaByte.Create);
  vecT.add(TMokaShort.Create);
  vecT.add(TMokaInt.Create);
  vecT.add(TMokaLong.Create);
  vecT.add(TMokaANSIString.Create);

  str := GetCurrentDir();

  len := Length(str);

  for i := 1 to len do
  begin
    if (str[i] = '\') or (str[i] = '/') then
    begin
      pathSeparator := str[i];
      break;
    end;
  end;

  if (pathSeparator = '\') then
  begin
    newLine := #13 + #10;
  end
  else
  begin
    newLine := #10;
  end;

  mainCl := nil;

  cMeth := nil;
  cAttr := nil;

  globalObjects := TStringVector.Create;

  usesGarbageCollector := false;
end;

end.
