(*
 * QUSOFT MICROSYSTMES
 * Moka
 * Copyright 2003 Frdric Brown
 *)

(*
 *  This file is part of Moka.
 *
 *  Moka is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.

 *  Moka is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with Moka; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *)

(*
 * Funcs unit contains nearly all the 'stand-alone' functions which are the functions
 * that aren't encapsulated in a class.
 *)

unit Funcs;

interface

uses Util, Reflect;

function est (c: char; vec: array of char):Boolean; overload;
function est (str: AnsiString; vec: array of AnsiString):Boolean; overload;
function commence (c: char; vec: array of AnsiString):Boolean;
function getPos (c: char; vec: array of char): Longint;
function readFileAsString (fileName: AnsiString): AnsiString;
procedure writeStringToFile (fileText: AnsiString; fileName: AnsiString);
function strBeginsWith(str: AnsiString; strBegin: AnsiString): Boolean;
function strEndsWith(str: AnsiString; strEnd: AnsiString): Boolean;
function isComment(str: AnsiString): Boolean;
function extractDirectory(str: AnsiString): AnsiString;
function extractClass(str: AnsiString): AnsiString;
function extractFile(str: AnsiString): AnsiString;
function getFilesVector(dir: AnsiString; ext: AnsiString): TStringVector;
function getBlock(vec: TStringVector; ind: Longint): TStringVector;
function getInner(vec: TStringVector; ind: Longint): TStringVector; overload;
function getInner(vec: TStringVector; ind: Longint; open: AnsiString; close: AnsiString): TStringVector; overload;
function nextIndex(vec: TStringVector; str: AnsiString; ind: Longint): Longint; overload;
function nextIndexSkip(vec: TStringVector; str: AnsiString; ind: Longint): Longint; overload;
procedure pushError(lv: Longint; msg: AnsiString);
function nextInstIndex(vec: TStringVector; ind: Longint): Longint;
function getVisibility(str: AnsiString): Longint;
function convertType(t: AnsiString): AnsiString;
function convertValue(t: AnsiString): AnsiString;
function isDigit(c: char): Boolean;
function isClass(str: AnsiString): Boolean;
function count(c: char; str: AnsiString): Longint;
function overloads(m: TMethode; cl: TClasse): Boolean; overload;
function overloads(a: TAttribute; cl: TClasse): Boolean; overload;
function overloaded(m: TMethode; ac: TClasse; cl: TClasse): Boolean;
function classIdent(vec: TStringVector; ind: Longint): AnsiString;
function replace(str: AnsiString; co: char; cr: char): AnsiString;
function nextExpr(vec: TStringVector; ind: Longint): Longint; overload;
function nextMember(vec: TStringVector; ind: Longint): Longint;
function prevExpr(vec: TStringVector; ind: Longint): Longint;
function prevMember(vec: TStringVector; ind: Longint): Longint;
function tabulate(num: Longint): AnsiString;
function returnExprLeft(vec: TStringVector; ind: Longint): TStringVector;
function returnExprRight(vec: TStringVector; ind: Longint): TStringVector;
function returnExpr(vec: TStringVector; ind: Longint): TStringVector;
function skip(vec: TStringVector; ind: Longint; open: AnsiString; close: AnsiString): Longint;
function isInstance(s: AnsiString; pv: TParameterVector; cl: TClasse): Boolean;
function getStaticMemberClass(s: AnsiString; cl: TClasse): AnsiString;
function getTypeOf(vec: TStringVector; pv: TParameterVector): TParameter;
function isObject(s: AnsiString; pv: TParameterVector; cl: TClasse): Boolean;
function getClassOf(str: AnsiString; pv: TParameterVector; cl: TClasse): TClasse;
function returnIdentType(str: AnsiString; pv: TParameterVector; cl: TClasse): TParameter;
function returnExprType(str: AnsiString; pv: TParameterVector): TParameter;
function isCast(vec: TStringVector): Boolean;
function getParameter(vecType: TStringVector): TParameter;
procedure addMethod(cClass: TClasse; indCl: Longint; comment: AnsiString; order: Longint);
procedure addStatic(cClass: TClasse; indCl: Longint; comment: AnsiString);
procedure addAttribute(cClass: TClasse; indCl: Longint; comment: AnsiString; order: Longint);
function getUpTo(vec: TStringVector; ind: Longint; str: AnsiString): TStringVector;
function getAttribute(vec: TStringVector; indCl: Longint): TAttribute;
function skipTo(vec: TStringVector; str: AnsiString; ind: Longint): Longint;
function getTypesVec(vec: TStringVector; pv: TParameterVector; protos: TMethodVector): TParameterVector;
function compatible(p0: TParameter; p1: TParameter): Boolean;
function addClassesAsParam(pv: TParameterVector): TParameterVector;
function bwSkip(vec: TStringVector; ind: Longint; open: AnsiString; close: AnsiString): Longint;
function returnObject(vec: TStringVector; ind: Longint): TStringVector;
function nextMemberAbs(vec: TStringVector; ind: Longint): Longint;
function prevMemberAbs(vec: TStringVector; ind: Longint): Longint;
function returnRange(vec: TStringVector; i0: Longint; i1: Longint): TStringVector;
function countInstClasses(): Longint;
function usedClassInherits(name :AnsiString): boolean;

implementation

uses SysUtils, Globals, Tokenizer;

function usedClassInherits(name :AnsiString): boolean;
var
  i: Longint;
  cl: TClasse;
begin

  for i := 0 to vecCl.size - 1 do
  begin
    cl := vecCl.getClass(i);
    if cl.inst then
    begin
      if cl.instof(name) then
      begin
        usedClassInherits := true;
        exit;
      end;
    end;
  end;

  usedClassInherits := false ;
end;

function countInstClasses(): Longint;
var
  count: Longint;
  i: Longint;
begin

  count := 0;

  for i := 0 to vecCl.size - 1 do
  begin
    if vecCl.getClass(i).inst then
    begin
      count := count + 1;
    end;
  end;

  countInstClasses := count ;
end;

function classIdent(vec: TStringVector; ind: Longint): AnsiString;
var
  i: Longint;
  cl: TClasse;
  m: TMethode;
  n: Longint;
  c: AnsiString;
begin
  c := vec.getStr(ind);

  (*
  if (isClass(c)) then
  begin
    if ()
    classIdent := c;
    exit;
  end
  else
  begin *)
    for i := 0 to vecCl.size - 1 do
    begin
    cl := vecCl.getClass(i);
      if (c = ('T' + cl.name)) then
      begin
        classIdent := cl.name;
        exit;
      end;
      for n := 0 to cl.meth.size - 1 do
      begin
        m := cl.meth.getMeth(n);
        if (m.rType = '') and (('T' + cl.name + m.getMorph) = c) then
        begin
          classIdent := cl.name;
          exit;
        end;
      end;
    end;
  //end;

  classIdent := '';
end;

function returnRange(vec: TStringVector; i0: Longint; i1: Longint): TStringVector;
var
  nv: TStringVector;
  n: Longint;
begin
  nv := TStringVector.Create;

  for n := i0 to i1 do
  begin
    nv.add(vec.getStr(n));
  end;

  returnRange := nv;
end;

function returnObject(vec: TStringVector; ind: Longint): TStringVector;
var
  nvec: TStringVector;
  lv0: Longint;
  lv1: Longint;
begin
  nvec := TStringVector.Create;
  lv0 := 0;
  lv1 := 0;

  while (ind >= 0) do
  begin
    if (vec.getStr(ind) = ']') then
    begin
      lv0 := lv0 + 1;
    end
    else if (vec.getStr(ind) = '[') then
    begin
      lv0 := lv0 - 1;
    end
    else if (vec.getStr(ind) = ')') then
    begin
      lv1 := lv1 + 1;
    end
    else if (vec.getStr(ind) = '(') then
    begin
      lv1 := lv1 - 1;
    end;
    nvec.add(vec.getStr(ind), 0);
    if (lv0 = 0) and (lv1 = 0) and not (est(vec.getStr(ind), vecUni)) and (not est(vec.getStr(ind), vecKey)  or ((ind - 1 < 0) or est(vec.getStr(ind-1), vecKey))) then
    begin
      break;
    end;
    ind := ind - 1;
  end;
  
  returnObject := nvec;
end;

function addClassesAsParam(pv: TParameterVector): TParameterVector;
var
  i: Longint;
begin
  for i := 0 to vecCl.size - 1 do
  begin
    pv.add(TParameter.Create(vecCl.getClass(i).name, '', vecCl.getClass(i).name));
  end;

  addClassesAsParam := pv;
end;

function compatible(p0: TParameter; p1: TParameter): Boolean;
begin
  if (p0.rType = 'void') then
  begin
    compatible := true;
    exit;
  end;

  if (length(p0.rPtr) > length(p1.rPtr)) then
  begin
      compatible := false;
      exit;
  end;

  if (p0.rType = p1.rType) then
  begin
    compatible := true;
    exit;
  end;
  
  if (isClass(p0.rType)) then
  begin
    if (p1.rType = 'null') then
    begin
      compatible := true;
      exit;
    end;
    if (isClass(p1.rType)) then
    begin
      if (vecCl.return(p1.rType).ext(p0.rType)) or (vecCl.return(p1.rType).implAll(p0.rType)) then
      begin
        compatible := true;
        exit;
      end
      else
      begin
        compatible := false;
        exit;
      end;
    end;
  end;

  if (p1.rType = 'ubyte') then
  begin
    if (p0.rType = 'byte') or (p0.rType = 'short') or (p0.rType = 'int') or (p0.rType = 'long') or (p0.rType = 'float') or (p0.rType = 'double') or (p0.rType = 'ubyte') or (p0.rType = 'ushort') or (p0.rType = 'uint') or (p0.rType = 'ulong') then
    begin
      compatible := true;
      exit;
    end
    else
    begin
      compatible := false;
      exit;
    end;
  end;
  if (p1.rType = 'ushort') then
  begin
    if (p0.rType = 'byte') or (p0.rType = 'short') or (p0.rType = 'int') or (p0.rType = 'long') or (p0.rType = 'float') or (p0.rType = 'double') or (p0.rType = 'ubyte') or (p0.rType = 'ushort') or (p0.rType = 'uint') or (p0.rType = 'ulong') then
    begin
      compatible := true;
      exit;
    end
    else
    begin
      compatible := false;
      exit;
    end;
  end;
  if (p1.rType = 'uint') then
  begin
    if (p0.rType = 'byte') or (p0.rType = 'short') or (p0.rType = 'int') or (p0.rType = 'long') or (p0.rType = 'float') or (p0.rType = 'double') or (p0.rType = 'ubyte') or (p0.rType = 'ushort') or (p0.rType = 'uint') or (p0.rType = 'ulong') then
    begin
      compatible := true;
      exit;
    end
    else
    begin
      compatible := false;
      exit;
    end;
  end;
  if (p1.rType = 'ulong') then
  begin
    if (p0.rType = 'byte') or (p0.rType = 'short') or (p0.rType = 'int') or (p0.rType = 'long') or (p0.rType = 'float') or (p0.rType = 'double') or (p0.rType = 'ubyte') or (p0.rType = 'ushort') or (p0.rType = 'uint') or (p0.rType = 'ulong') then
    begin
      compatible := true;
      exit;
    end
    else
    begin
      compatible := false;
      exit;
    end;
  end;
  if (p1.rType = 'byte') then
  begin
    if (p0.rType = 'byte') or (p0.rType = 'short') or (p0.rType = 'int') or (p0.rType = 'long') or (p0.rType = 'float') or (p0.rType = 'double') or (p0.rType = 'ubyte') or (p0.rType = 'ushort') or (p0.rType = 'uint') or (p0.rType = 'ulong') then
    begin
      compatible := true;
      exit;
    end
    else
    begin
      compatible := false;
      exit;
    end;
  end;
  if (p1.rType = 'short') then
  begin
    if (p0.rType = 'byte') or (p0.rType = 'short') or (p0.rType = 'int') or (p0.rType = 'long') or (p0.rType = 'float') or (p0.rType = 'double') or (p0.rType = 'ubyte') or (p0.rType = 'ushort') or (p0.rType = 'uint') or (p0.rType = 'ulong') then
    begin
      compatible := true;
      exit;
    end
    else
    begin
      compatible := false;
      exit;
    end;
  end;
  if (p1.rType = 'int') then
  begin
    if (p0.rType = 'byte') or (p0.rType = 'short') or (p0.rType = 'int') or (p0.rType = 'long') or (p0.rType = 'float') or (p0.rType = 'double') or (p0.rType = 'ubyte') or (p0.rType = 'ushort') or (p0.rType = 'uint') or (p0.rType = 'ulong') then
    begin
      compatible := true;
      exit;
    end
    else
    begin
      compatible := false;
      exit;
    end;
  end;
  if (p1.rType = 'long') then
  begin
    if (p0.rType = 'byte') or (p0.rType = 'short') or (p0.rType = 'int') or (p0.rType = 'long') or (p0.rType = 'float') or (p0.rType = 'double') or (p0.rType = 'ubyte') or (p0.rType = 'ushort') or (p0.rType = 'uint') or (p0.rType = 'ulong') then
    begin
      compatible := true;
      exit;
    end
    else
    begin
      compatible := false;
      exit;
    end;
  end;
  if (p1.rType = 'float') then
  begin
    if (p0.rType = 'float') or (p0.rType = 'double') then
    begin
      compatible := true;
      exit;
    end
    else
    begin
      compatible := false;
      exit;
    end;
  end;
  if (p1.rType = 'double') then
  begin
    if (p0.rType = 'double') then
    begin
      compatible := true;
      exit;
    end
    else
    begin
      compatible := false;
      exit;
    end;
  end;

  compatible := false;
end;

function getTypesVec(vec: TStringVector; pv: TParameterVector; protos: TMethodVector): TParameterVector;
var
  i: Longint;
  n: Longint;
  tvec: TParameterVector;
  mvec: TMethodVector;
  buf: TStringVector;
  z: Longint;
begin
  i := 0;
  tvec := TParameterVector.Create;
  buf := TStringVector.Create;
  while (i < vec.size) do
  begin
    if (vec.getStr(i) <> ',') then
    begin
      buf.add(returnExpr(vec, i));
      i := nextExpr(vec, i);
    end
    else
    begin
      tvec.add(returnExprType(buf.toString, pv));
      buf := TStringVector.Create;
      i := nextExpr(vec, i);
    end;
  end;

  if (vec.size > 0) then
  begin
    tvec.add(returnExprType(buf.toString, pv));
  end;

  mvec := TMethodVector.Create;

  for i := 0 to protos.size - 1 do
  begin
    if (protos.getMeth(i).params.size = tvec.size) then
    begin
      mvec.add(protos.getMeth(i));
    end;
  end;

  protos := TMethodVector.Create;

  for i := 0 to mvec.size - 1 do
  begin
    for n := 0 to tvec.size - 1 do
    begin
      if not compatible(mvec.getMeth(i).params.getParam(n), tvec.getParam(n)) then
      begin
        break;
      end;
      if (n = tvec.size - 1) then
      begin
        protos.add(mvec.getMeth(i));
      end;
    end;
  end;

  for i := 0 to tvec.size - 1 do
  begin
    for n := 0 to protos.size - 1 do
    begin
      if (tvec.getParam(i).rType = protos.getMeth(n).params.getParam(i).rType) then
      begin
        z := 0;
        while (z < protos.size) do
        begin
          if (protos.getMeth(z).params.getParam(i).rType <> tvec.getParam(i).rType) then
          begin
            protos.rem(z);
          end
          else
          begin
            z := z + 1;
          end;
        end;
      end;
    end;
  end;

  if (protos.size > 0) then
  begin
    tvec := protos.getMeth(0).params;
  end;

  getTypesVec := tvec;
end;

function skipTo(vec: TStringVector; str: AnsiString; ind: Longint): Longint;
var
  found: Boolean;
  len: Longint;
  lv0: Longint;
  lv1: Longint;
begin
  lv0 := 0;
  lv1 := 0;
  found := false;
  len := vec.size;

  //ind := ind + 1;
  while not found do
  begin
    if (ind < len) then
    begin
      if (vec.getStr(ind) = '[') then
      begin
        lv0 := lv0 + 1;
      end
      else if (vec.getStr(ind) = ']') then
      begin
        lv0 := lv0 - 1;
      end
      else if (vec.getStr(ind) = '(') then
      begin
        lv1 := lv1 + 1;
      end
      else if (vec.getStr(ind) = ')') then
      begin
        lv1 := lv1 - 1;
      end;
      if (lv0 = 0) and (lv1 = 0) then
      begin
        if (ind + 1 >= len) or (vec.getStr(ind) = str) then
        begin
          //if (est(vec.getStr(ind), vecClose)) then
          //begin
          //end;
          break;
        end;
      end;
    end
    else
    begin
      break;
    end;
    ind := ind + 1;
  end;

  skipTo := ind;
end;

function getAttribute(vec: TStringVector; indCl: Longint): TAttribute;
var
  attr: TAttribute;
  vecStr: TStringVector;
  param: TParameter;
begin
  attr := TAttribute.Create('');

  cTyped := attr;

  vecStr := TStringVector.Create;

  while (indCl < vec.size) and not est(vec.getStr(indCl), vecASep) and (vec.getStr(indCl) <> '=') do
  begin
    vecStr.add(vec.getStr(indCl));
    indCl := indCl + 1;
  end;

  param := getParameter(vecStr);

  attr.name := param.name;
  attr.rType := param.rType;
  attr.rPtr := param.rPtr;

  while (indCl < vec.size) and (vec.getStr(indCl) <> '=') and not est(vec.getStr(indCl), vecASep) do
  begin
    indCl := indCl + 1;
  end;

  if (vec.getStr(indCl) = '=') then
  begin
    indCl := indCl + 1;

    vecStr := TStringVector.Create;

    while (indCl < vec.size) and not est(vec.getStr(indCl), vecASep) do
    begin
      vecStr.add(vec.getStr(indCl));
      indCl := indCl + 1;
    end;

    attr.value := vecStr;
  end;
  
  (*
  if (indCl >= vec.size) then
  begin
    pushError(1, 'Error : '';'' expected in the declaration of ' + attr.name + ' in method ' + cMeth.name + ' of class ' + cClass.name + ' (' + cClass.fileName + ').');
  end;
  *)

  getAttribute := attr;
end;

function getUpTo(vec: TStringVector; ind: Longint; str: AnsiString): TStringVector;
var
  found: Boolean;
  len: Longint;
  lv0: Longint;
  lv1: Longint;
  lv2: Longint;
  v: TStringVector;
begin
  lv0 := 0;
  lv1 := 0;
  lv2 := 0;
  found := false;
  len := vec.size;
  v := TStringVector.Create;

  //ind := ind + 1;
  while not found do
  begin
    if (ind < len) then
    begin
      if (vec.getStr(ind) = '[') then
      begin
        lv0 := lv0 + 1;
      end
      else if (vec.getStr(ind) = ']') then
      begin
        lv0 := lv0 - 1;
      end
      else if (vec.getStr(ind) = '(') then
      begin
        lv1 := lv1 + 1;
      end
      else if (vec.getStr(ind) = ')') then
      begin
        lv1 := lv1 - 1;
      end
      else if (vec.getStr(ind) = '{') then
      begin
        lv2 := lv2 + 1;
      end
      else if (vec.getStr(ind) = '}') then
      begin
        lv2 := lv2 - 1;
      end;
      if (lv0 = 0) and (lv1 = 0) and (lv2 = 0) then
      begin
        if (ind + 1 >= len) or (vec.getStr(ind) = str) then
        begin
          //if (est(vec.getStr(ind), vecClose)) then
          //begin
          v.add(vec.getStr(ind));
          //end;
          break;
        end;
      end;
    end
    else
    begin
      break;
    end;
    v.add(vec.getStr(ind));
    ind := ind + 1;
  end;

  getUpTo := v;
end;

procedure addStatic(cClass: TClasse; indCl: Longint; comment: AnsiString);
var
  mc: TMethode;
  desc: AnsiString;
begin
  mc := cMeth;
  cMeth := TMethode.Create(comment);
  cTyped := cMeth;

  desc := 'static ';

  cMeth.stat := true;

  if (cClass.words.getStr(indCl) = 'static') then
  begin
      cMeth.name := 'static';
      desc := desc + 'constructor ';
  end
  else
  begin
    cMeth.name := 'finally';
    desc := desc + 'destructor ';
  end;

  if (indCl + 1 >= cClass.words.size) or (cClass.words.getStr(indCl+1) <> '{') then
  begin
    pushError(1, 'Error : ''{'' expected in the declaration of a static constructor or destructor in class ' + cClass.name + '(' + cClass.fileName + ').');
  end;

  indCl := indCl + 1;

  cMeth.rType := 'void';
  cMeth.rPtr := '';

  cMeth.words := getBlock(cClass.words, indCl);

  cClass.meth.add(cMeth);

  os.println(#9 + desc);

  cMeth := mc;
end;

procedure addMethod(cClass: TClasse; indCl: Longint; comment: AnsiString; order: Longint);
var
  mc: TMethode;
  desc: AnsiString;
  vecType: TStringVector;
  param: TParameter;
begin
  mc := cMeth;
  cMeth := TMethode.Create(comment);
  cTyped := cMeth;

  desc := '';

  if est(cClass.words.getStr(indCl), vecVisi) then
  begin
    cMeth.visibility := getVisibility(cClass.words.getStr(indCl));
    desc := desc + '(' + cClass.words.getStr(indCl) + ') ';
    indCl := indCl + 1;
  end
  else
  begin
    desc := desc + '(default) ';
  end;

  while (indCl < cClass.words.size) and (est(cClass.words.getStr(indCl), vecMMod)) do
  begin
    if (cClass.words.getStr(indCl) = 'final') then
    begin
      cMeth.fin := true;
    end
    else if (cClass.words.getStr(indCl) = 'static') then
    begin
      cMeth.stat := true;
    end
    else if (cClass.words.getStr(indCl) = 'native') then
    begin
      cMeth.nat := true;
    end
    else
    begin
      cMeth.abst := true;
    end;
    desc := desc + cClass.words.getStr(indCl) + ' ';
    indCl := indCl + 1;
  end;

  vecType := TStringVector.Create;

  while (indCl < cClass.words.size) and (cClass.words.getStr(indCl) <> '(') do
  begin
    vecType.add(cClass.words.getStr(indCl));
    indCl := indCl + 1;
  end;

  if (indCl + 1 >= cClass.words.size) then
  begin
    pushError(1, 'Error : ''('' expected in the declaration of a method in class ' + cClass.name + '(' + cClass.fileName + ').');
  end;

  param := getParameter(vecType);

  cMeth.name := param.name;
  cMeth.rType := param.rType;
  cMeth.rPtr := param.rPtr;

  cMeth.order := order;

  if (param.rType = '') then
  begin
    desc := 'constructor : ' + desc;
  end
  else
  begin
    desc := 'method ' + param.name + ' : ' + desc + 'returning ' + cMeth.rType + ' ' + cMeth.rPtr;;
  end;

  indCl := indCl + 1;

  if (cClass.words.getStr(indCl) <> ')') then
  begin
    desc := desc + 'accepting ';
  end;

  while (indCl < cClass.words.size) and (cClass.words.getStr(indCl) <> ')') do
  begin
    vecType := TStringVector.Create;
    while (indCl < cClass.words.size) and (cClass.words.getStr(indCl) <> ',') and (cClass.words.getStr(indCl) <> ')') do
    begin
      vecType.add(cClass.words.getStr(indCl));
      indCl := indCl + 1;
    end;
    if (cClass.words.getStr(indCl) = ',') then
    begin
      indCl := indCl + 1;
    end;
    param := getParameter(vecType);
    cMeth.params.add(param);
    desc := desc + param.name + ' as ' + param.rType + ' ' + param.rPtr + '; ';
  end;

  if cMeth.nat and not cMeth.abst then
  begin
    cMeth.text := cClass.words.getStr(indCl+2);
  end
  else if  not cMeth.abst then
  begin
    cMeth.words := getBlock(cClass.words, indCl);
  end;

  cClass.meth.add(cMeth);

  os.println(#9 + desc);
  
  cMeth := mc;
end;

procedure addAttribute(cClass: TClasse; indCl: Longint; comment: AnsiString; order: Longint);
var
  desc: AnsiString;
  attr: TAttribute;
  vecStr: TStringVector;
  param: TParameter;
begin
  attr := TAttribute.Create(comment);

  cTyped := attr;

  desc := '';

  if est(cClass.words.getStr(indCl), vecVisi) then
  begin
    attr.visibility := getVisibility(cClass.words.getStr(indCl));
    desc := desc + '(' + cClass.words.getStr(indCl) + ') ';
    indCl := indCl + 1;
  end
  else
  begin
    desc := desc + '(default) ';
  end;

  while (indCl < cClass.words.size) and (est(cClass.words.getStr(indCl), vecAMod)) do
  begin
    if (cClass.words.getStr(indCl) = 'final') then
    begin
      attr.fin := true;
    end
    else if (cClass.words.getStr(indCl) = 'volatile') then
    begin
      attr.vol := true;
    end
    else
    begin
      attr.stat := true;
    end;
    indCl := indCl + 1;
  end;

  vecStr := TStringVector.Create;

  while (indCl < cClass.words.size) and (cClass.words.getStr(indCl) <> ';') and (cClass.words.getStr(indCl) <> '=') do
  begin
    vecStr.add(cClass.words.getStr(indCl));
    indCl := indCl + 1;
  end;

  param := getParameter(vecStr);

  attr.name := param.name;
  attr.rType := param.rType;
  attr.rPtr := param.rPtr;

  attr.order := order;

  if attr.stat then
  begin
    desc := desc + 'static ';
  end;

  if attr.fin then
  begin
    desc := 'constant ' + attr.name + ' : ' + desc;
  end
  else
  begin
    desc := 'attribute ' + attr.name + ' : ' + desc;
  end;

  desc := desc + 'of type ' + attr.rType + ' ' + attr.rPtr;

  while (indCl < cClass.words.size) and (cClass.words.getStr(indCl) <> '=') and (cClass.words.getStr(indCl) <> ';') do
  begin
    indCl := indCl + 1;
  end;
  if (cClass.words.getStr(indCl) = '=') then
  begin
    indCl := indCl + 1;

    vecStr := TStringVector.Create;

    while (indCl < cClass.words.size) and (cClass.words.getStr(indCl) <> ';') do
    begin
      vecStr.add(cClass.words.getStr(indCl));
      indCl := indCl + 1;
    end;

    attr.value := vecStr;
  end;

  if (indCl >= cClass.words.size) then
  begin
    pushError(1, 'Error : '';'' expected in the declaration of ' + attr.name + ' in class ' + cClass.name + ' (' + cClass.fileName + ').');
  end;

  cClass.attr.add(attr);

  os.println(#9 + desc);

end;

function getParameter (vecType: TStringVector): TParameter;
var
  i: Longint;
  param: TParameter;
  rType: AnsiString;
  rPtr: AnsiString;
  name: AnsiString;
begin

  rType := '';
  rPtr := '';

  i := vecType.size - 1;

  while (i >= 0) and ((vecType.getStr(i) = '*') or (vecType.getStr(i) = ']')) do
  begin
    rPtr := rPtr + '* ';
    if (vecType.getStr(i) = ']') then
    begin
      i := bwSkip(vecType, i, ']', '[') + 1;
    end;
    i := i - 1;
  end;

  name := vecType.getStr(i);

  i := i - 1;

  while (i >= 0) and ((vecType.getStr(i) = '*') or (vecType.getStr(i) = ']')) do
  begin
    rPtr := rPtr + '* ';
    if (vecType.getStr(i) = ']') then
    begin
      i := bwSkip(vecType, i, ']', '[') + 1;
    end;
    i := i - 1;
  end;

  while (i >= 0) do
  begin
    rType := vecType.getStr(i) + ' ' + rType;
    i := i - 1;
  end;

  rType := trim(rType);

  param := TParameter.Create(rType, rPtr, name);

  getParameter := param;
end;

function isCast(vec: TStringVector): Boolean;
var
  i: Longint;
  rType: AnsiString;
  rPtr: AnsiString;
begin
  if (vec.getStr(0) = '(') then
  begin
    i := 1;
    rType := convertType(vec.getStr(i));
    i := 2;

    rPtr := '';

    while (i < vec.size) and (vec.getStr(i) = '*') or ((i + 1 < vec.size) and (vec.getStr(i) = '[') and (vec.getStr(i) = ']')) do
    begin
      if (vec.getStr(i) = '[') then
      begin
        i := i + 1;
      end;
      i := i + 1;
     rPtr := rPtr + '* ';
    end;

    if (vec.getStr(i) = ')') then
    begin
      isCast := true;
      exit;
    end;
  end;

  isCast := false;
end;

function getClassOf(str: AnsiString; pv: TParameterVector; cl: TClasse): TClasse;
var
  n: Longint;
begin
  if (str = 'this') then
  begin
    getClassOf := cl;
    exit;
  end;

  if (str = 'super') then
  begin
    getClassOf := cl.sup;
    exit;
  end;

  for n := 0 to pv.size - 1 do
  begin
    if (pv.getParam(n).name = str) and isClass(pv.getParam(n).rType) then
    begin
      getClassOf := vecCl.return(pv.getParam(n).rType);
      exit;
    end;
  end;
  while (cl <> nil) do
  begin
    for n := 0 to cl.attr.size - 1 do
    begin
      if (cl.attr.getAttr(n).name = str) and isClass(cl.attr.getAttr(n).rType) then
      begin
        getClassOf := vecCl.return(cl.attr.getAttr(n).rType);
        exit;
      end;
    end;
    for n := 0 to cl.meth.size - 1 do
    begin
      if (cl.meth.getMeth(n).name = str) and isClass(cl.meth.getMeth(n).rType) then
      begin
        getClassOf := vecCl.return(cl.meth.getMeth(n).rType);
        exit;
      end;
    end;
    cl := cl.sup;
  end;

  getClassOf := nil;
end;

function returnIdentType(str: AnsiString; pv: TParameterVector; cl: TClasse): TParameter;
var
  param: TParameter;
  n: Longint;
begin
  if (str = 'this') then
  begin
    param := TParameter.Create(cl.name, '', str);
    returnIdentType := param;
    exit;
  end;
  if (str = 'super') then
  begin
    param := TParameter.Create(cl.sup.name, '', str);
    returnIdentType := param;
    exit;
  end;
  if (str = 'null') then
  begin
    param := TParameter.Create('null', '', str);
    returnIdentType := param;
    exit;
  end;
  for n := 0 to pv.size - 1 do
  begin
    if (pv.getParam(n).name = str) then
    begin
      param := TParameter.Create(pv.getParam(n).rType, pv.getParam(n).rPtr, str);
      returnIdentType := param;
      exit;
    end;
  end;
  while (cl <> nil) do
  begin
    for n := 0 to cl.attr.size - 1 do
    begin
      if (cl.attr.getAttr(n).name = str)then
      begin
        param := TParameter.Create(cl.attr.getAttr(n).rType, cl.attr.getAttr(n).rPtr, str);
        returnIdentType := param;
        exit;
      end;
    end;
    for n := 0 to cl.meth.size - 1 do
    begin
      if (cl.meth.getMeth(n).name = str) then
      begin
        param := TParameter.Create(cl.meth.getMeth(n).rType, cl.meth.getMeth(n).rPtr, str);
        returnIdentType := param;
        exit;
      end;
    end;
    cl := cl.sup;
  end;

  if vecT.getType(14).est(str) then
  begin
    returnIdentType := TParameter.Create('char', '* ', str);
    exit;
  end;

  if vecT.getType(8).est(str) then
  begin
    returnIdentType := TParameter.Create('String', '', str);
    exit;
  end;
    
  for n := 0 to vecT.size - 1 do
  begin
    if vecT.getType(n).est(str) then
    begin
      returnIdentType := TParameter.Create(vecT.getType(n).strMoka, '', str);
      exit;
    end;
  end;
  param := TParameter.Create('short', '', str);
  returnIdentType := param;
end;

function returnExprType(str: AnsiString; pv: TParameterVector): TParameter;
var
  param: TParameter;
  i: Longint;
  vec: TStringVector;
  rParam: TParameter;
  v: TStringVector;
begin
  vec := getStringVector(str);
  rParam := TParameter.Create('', '', '');

  i := 0;
  while (i < vec.size) do
  begin
    if (vec.getStr(i) = '(') then
    begin
      v := TStringVector.Create;
      v.add('(');
      v.add(getInner(vec, i, '(', ')'));
      v.add(')');
      if (isCast(returnExpr(v, 0))) then
      begin
        i := skip(vec, i, '(', ')');
        v.add(returnExpr(vec, i));
        param := getTypeOf(v, pv);
      end
      else
      begin
        param := getTypeOf(returnExpr(vec, i), pv);
      end;
    end
    else if (vec.getStr(i) = 'new') then
    begin
      param := TParameter.Create(vec.getStr(i+1), '', '');
      i := skip(vec, i, '(', ')');
    end
    else
    begin
      param := getTypeOf(returnExpr(vec, i), pv);
    end;
    if (param.rType = 'double') or (param.rType = 'null') or (isClass(param.rType)) or (param.rType = 'boolean') or (param.rType = 'char') then
    begin
      rParam := param;
      break;
    end;
    if (rParam.rType = '') then
    begin
        rParam := param;
    end
    else if (param.rType = 'short') then
    begin
      if (rParam.rType = 'byte') then
      begin
        rParam := param;
      end;
    end
    else if (param.rType = 'int') then
    begin
      if (rParam.rType = 'byte') or (rParam.rType = 'short') then
      begin
        rParam := param;
      end;
    end
    else if (param.rType = 'long') then
    begin
      if (rParam.rType = 'byte') or (rParam.rType = 'short') or (rParam.rType = 'int') then
      begin
        rParam := param;
      end;
    end
    else if (param.rType = 'float') then
    begin
      if (rParam.rType = 'byte') or (rParam.rType = 'short') or (rParam.rType = 'int') or (rParam.rType = 'long') then
      begin
        rParam := param;
      end;
    end;
    i := nextExpr(vec, i);
  end;

  returnExprType := rParam;
end;

function getTypeOf(vec: TStringVector; pv: TParameterVector): TParameter;
var
  i: Longint;
  c: TClasse;
  rType: AnsiString;
  rPtr: AnsiString;
  pvc: TParameterVector;
  str: AnsiString;
begin
  if (vec.getStr(0) = '(') then
  begin
    i := 1;
    rType := vec.getStr(i);
    i := 2;

    rPtr := '';

    while (i < vec.size) and (vec.getStr(i) = '*') or ((i + 1 < vec.size) and (vec.getStr(i) = '[') and (vec.getStr(i+1) = ']')) do
    begin
      if (vec.getStr(i) = '[') then
      begin
        i := i + 1;
      end;
      i := i + 1;
     rPtr := rPtr + '* ';
    end;

    if (vec.getStr(i) = ')') then
    begin
      getTypeOf := TParameter.Create(rType, rPtr, '');
      exit;
    end
    else
    begin
      getTypeOf := getTypeOf(getInner(vec, 0), pv);
      exit;
    end;
  end;


      if isInstance(vec.get(0), pv, cClass) then
      begin
        str := getStaticMemberClass(vec.get(0), cClass);
        if (str <> '') then
        begin
          vec.add('.', 0);
          vec.add(str, 0);

        end
        else if (((cMeth <> nil) and not cMeth.stat) or ((cAttr <> nil) and not cAttr.stat)) then
        begin
	        vec.add('.', 0);
	        vec.add('this', 0);
        end;
      end;

  c := getClassOf(vec.get(0), pv, cClass);
  if (c <> nil) then
  begin
    i := 0;
    pvc := pv;
    if (nextMember(vec, i) < vec.size) then
    begin
      i := nextMember(vec, i);
    end;
    while (getClassOf(vec.get(i), pvc, c) <> nil) and (nextMember(vec, i) < vec.size) {and est(vec.getStr(nextMember(vec, i) - 1), vecUni)} do
    begin
      c := getClassOf(vec.get(i), pvc, c);
      i := nextMember(vec, i);
      pvc := TParameterVector.Create;
    end;

    if (nextMember(vec, i) < vec.size) then
    begin
      i := nextMember(vec, i);
    end;
    rType := returnIdentType(vec.get(i), pvc, c).rType;
    rPtr := returnIdentType(vec.get(i), pvc, c).rPtr;
  end
  else
  begin
    rType := returnIdentType(vec.get(0), pv, cClass).rType;
    rPtr := returnIdentType(vec.get(0), pv, cClass).rPtr;
  end;
  getTypeOf := TParameter.Create(rType, rPtr, '');
end;

function isObject(s: AnsiString; pv: TParameterVector; cl: TClasse): Boolean;
begin
  if (s = 'this') or (s = 'super') then
  begin
    isObject := true;
    exit;
  end;

  if pv.contains(s) then
  begin
    if isClass(pv.return(s).rType) (* and (pv.return(s).rPtr = '') *) then
    begin
      isObject := true;
    end
    else
    begin
      isObject := false;
    end;
    exit;
  end;

  while cl <> nil do
  begin
    if cl.meth.contains(s) then
    begin
      if isClass(cl.meth.getMVec(s).getMeth(0).rType) (* and (cl.meth.getMVec(s).getMeth(0).rPtr = '') *) then
      begin
        isObject := true;
      end
      else
      begin
        isObject := false;
      end;
      exit;
    end;
    if cl.attr.contains(s) then
    begin
      if isClass(cl.attr.return(s).rType) (* and (cl.attr.return(s).rPtr = '') *) then
      begin
        isObject := true;
      end
      else
      begin
        isObject := false;
      end;
      exit;
    end;
    cl := cl.sup;
  end;

  isObject := false;
end;

function isInstance(s: AnsiString; pv: TParameterVector; cl: TClasse): Boolean;
begin
  if pv.contains(s) then
  begin
    isInstance := false;
    exit;
  end;

  while cl <> nil do
  begin
    if cl.meth.contains(s) then
    begin
      isInstance := true;
      exit;
    end;
    if cl.attr.contains(s) then
    begin
      isInstance := true;
      exit;
    end;
    cl := cl.sup;
  end;

  isInstance := false;
end;

function getStaticMemberClass(s: AnsiString; cl: TClasse): AnsiString;
var
 m: TMethode;
 a: TAttribute;
begin
  while cl <> nil do
  begin
    m := cl.meth.return(s);
    if (m <> nil) and (m.stat) then
    begin
      getStaticMemberClass := cl.name;
      exit;
    end;

    a := cl.attr.return(s);

    if (a <> nil) and (a.stat) then
    begin
      getStaticMemberClass := cl.name;
      exit;
    end;
    cl := cl.sup;
  end;

  getStaticMemberClass := '';
end;

function bwSkip(vec: TStringVector; ind: Longint; open: AnsiString; close: AnsiString): Longint;
var
  //i: TStringVector;
  lv: Longint;
  str: AnsiString;
begin
  lv := 1;

  while (ind < vec.size) and (vec.getStr(ind) <> open) do
  begin
    ind := ind - 1;
  end;

  ind := ind - 1;

  while (ind >=0) and not ((lv = 0) and (vec.getStr(ind) = close)) do
  begin
    if (vec.getStr(ind) = close) then
    begin
      lv := lv - 1;
      if (lv = 0) then
      begin
        ind := ind - 1;
        break;
        //i.add(vec.getStr(ind));
      end;
    end
    else if (vec.getStr(ind) = open) then
    begin
      //i.add(vec.getStr(ind));
      lv := lv + 1;
    end;
    (*else
    begin
      //i.add(vec.getStr(ind));
    end; *)
    ind := ind - 1;
  end;

  str := '';

  if (cMeth <> nil) then
  begin
    str := ', method ' + cMeth.name;
  end
  else if (cAttr <> nil) then
  begin
    str := ', attribute ' + cMeth.name;
  end;

  if (ind > vec.size) then
  begin
    pushError(1, 'Error: ''' + close + ''' expected in class ' + cClass.name + str + ' (' + cClass.fileName + ').');
  end;

  bwSkip := ind;
end;

function skip(vec: TStringVector; ind: Longint; open: AnsiString; close: AnsiString): Longint;
var
  //i: TStringVector;
  lv: Longint;
  str: AnsiString;
begin
  lv := 1;

  while (ind < vec.size) and (vec.getStr(ind) <> open) do
  begin
    ind := ind + 1;
  end;

  ind := ind + 1;

  while (ind < vec.size) and not ((lv = 0) and (vec.getStr(ind) = close)) do
  begin
    if (vec.getStr(ind) = close) then
    begin
      lv := lv - 1;
      if (lv = 0) then
      begin
        ind := ind + 1;
        break;
        //i.add(vec.getStr(ind));
      end;
    end
    else if (vec.getStr(ind) = open) then
    begin
      //i.add(vec.getStr(ind));
      lv := lv + 1;
    end;
    (*else
    begin
      //i.add(vec.getStr(ind));
    end; *)
    ind := ind + 1;
  end;

  str := '';

  if (cMeth <> nil) then
  begin
    str := ', method ' + cMeth.name;
  end
  else if (cAttr <> nil) then
  begin
    str := ', attribute ' + cAttr.name;
  end;

  if (ind > vec.size) then
  begin
    pushError(1, 'Error: ''' + close + ''' expected in class ' + cClass.name + str + ' (' + cClass.fileName + ').');
  end;

  skip := ind;
end;

function returnExprLeft(vec: TStringVector; ind: Longint): TStringVector;
var
  v: TStringVector;
  i: Longint;
  pos0: Longint;
begin
  v := TStringVector.Create;

  pos0 := prevExpr(vec, ind);

  for i := pos0 downto ind - 1 do
  begin
    v.add(vec.get(i));
  end;

  returnExprLeft := v;
end;

function returnExprRight(vec: TStringVector; ind: Longint): TStringVector;
var
  v: TStringVector;
  i: Longint;
  pos0: Longint;
  pos1: Longint;
begin
  v := TStringVector.Create;

  if (ind > 0) then
  begin
    pos0 := nextExpr(vec, ind);
  end
  else
  begin
    pos0 := 0;
  end;
  pos1 := nextExpr(vec, pos0);

  for i := pos0 to pos1 - 1 do
  begin
    v.add(vec.get(i));
  end;

  returnExprRight := v;
end;

function returnExpr(vec: TStringVector; ind: Longint): TStringVector;
var
  v: TStringVector;
  i: Longint;
  pos0: Longint;
  pos1: Longint;
begin
  v := TStringVector.Create;

  pos0 := ind;
  pos1 := nextExpr(vec, pos0);

  for i := pos0 to pos1 - 1 do
  begin
    v.add(vec.get(i));
  end;

  returnExpr := v;
end;

function tabulate(num: Longint): AnsiString;
var
  i: Longint;
  s: AnsiString;
begin
  s := '';

  for i := 1 to num do
  begin
    s := s + #9;
  end;

  tabulate := s;
end;

function nextExpr(vec: TStringVector; ind: Longint): Longint;
var
  found: Boolean;
  len: Longint;
  lv0: Longint;
  lv1: Longint;
begin
  lv0 := 0;
  lv1 := 0;
  found := false;
  len := vec.size;

  //ind := ind + 1;
  while not found do
  begin
    if (ind < len) then
    begin
      if (vec.getStr(ind) = '[') then
      begin
        lv0 := lv0 + 1;
      end
      else if (vec.getStr(ind) = ']') then
      begin
        lv0 := lv0 - 1;
      end
      else if (vec.getStr(ind) = '(') then
      begin
        lv1 := lv1 + 1;
      end
      else if (vec.getStr(ind) = ')') then
      begin
        lv1 := lv1 - 1;
      end;
      if (lv0 = 0) and (lv1 = 0) then
      begin
        if (ind + 1 >= len) or not (est(vec.getStr(ind), vecUni) or est(vec.getStr(ind), vecOpen) or est(vec.getStr(ind+1), vecUni) or (est(vec.getStr(ind+1), vecOpen) and not est(vec.getStr(ind), vecSym))) then
        begin
          //if (est(vec.getStr(ind), vecClose)) then
          //begin
            ind := ind + 1;
          //end;
          break;
        end;
      end;
    end
    else
    begin
      break;
    end;
    ind := ind + 1;
  end;

  nextExpr := ind;
end;

function nextMember(vec: TStringVector; ind: Longint): Longint;
var
  found: Boolean;
  len: Longint;
  lv0: Longint;
  lv1: Longint;
begin
  lv0 := 0;
  lv1 := 0;
  found := false;
  len := vec.size;
  //ind := ind + 1;
  while not found do
  begin
    if (ind < len) then
    begin
      if (vec.getStr(ind) = '[') then
      begin
        lv0 := lv0 + 1;
      end
      else if (vec.getStr(ind) = ']') then
      begin
        lv0 := lv0 - 1;
      end
      else if (vec.getStr(ind) = '(') then
      begin
        lv1 := lv1 + 1;
      end
      else if (vec.getStr(ind) = ')') then
      begin
        lv1 := lv1 - 1;
      end;
      if (lv0 = 0) and (lv1 = 0) then
      begin
        if (ind + 1 >= len) or not (est(vec.getStr(ind), vecUni) or est(vec.getStr(ind), vecOpen) or est(vec.getStr(ind+1), vecOpen)) then
        begin
          ind := ind + 1;
          if (est(vec.getStr(ind), vecUni)) then
          begin
            ind := ind + 1;
          end;
          break;
        end;
      end;
    end
    else
    begin
      break;
    end;
    ind := ind + 1;
  end;

  nextMember := ind;
end;

function nextMemberAbs(vec: TStringVector; ind: Longint): Longint;
var
  found: Boolean;
  len: Longint;
  lv0: Longint;
  lv1: Longint;
begin
  lv0 := 0;
  lv1 := 0;
  found := false;
  len := vec.size;
  //ind := ind + 1;
  while not found do
  begin
    if (ind < len) then
    begin
      if (vec.getStr(ind) = '[') then
      begin
        lv0 := lv0 + 1;
      end
      else if (vec.getStr(ind) = ']') then
      begin
        lv0 := lv0 - 1;
      end
      else if (vec.getStr(ind) = '(') then
      begin
        lv1 := lv1 + 1;
      end
      else if (vec.getStr(ind) = ')') then
      begin
        lv1 := lv1 - 1;
      end;
      if (lv0 = 0) and (lv1 = 0) then
      begin
        if (ind + 1 >= len) or not (est(vec.getStr(ind), vecOpen) or est(vec.getStr(ind+1), vecOpen)) then
        begin
          ind := ind + 1;
          break;
        end;
      end;
    end
    else
    begin
      break;
    end;
    ind := ind + 1;
  end;
  nextMemberAbs := ind;
end;

function prevExpr(vec: TStringVector; ind: Longint): Longint;
var
  found: Boolean;
  lv0: Longint;
  lv1: Longint;
begin
  lv0 := 0;
  lv1 := 0;
  found := false;

  ind := ind - 1;
  while not found do
  begin
    if (ind >= 0) then
    begin
      if (vec.getStr(ind) = ']') then
      begin
        lv0 := lv0 + 1;
      end
      else if (vec.getStr(ind) = '[') then
      begin
        lv0 := lv0 - 1;
      end
      else if (vec.getStr(ind) = ')') then
      begin
        lv1 := lv1 + 1;
      end
      else if (vec.getStr(ind) = '(') then
      begin
        lv1 := lv1 - 1;
      end;
      if (lv0 = 0) and (lv1 = 0) then
      begin
        if (ind - 1 < 0) or not (est(vec.getStr(ind), vecUni) or est(vec.getStr(ind), vecOpen) or est(vec.getStr(ind-1), vecUni) or est(vec.getStr(ind-1), vecOpen)) then
        begin
          break;
        end;
      end;
    end
    else
    begin
      break;
    end;
    ind := ind - 1;
  end;

  prevExpr := ind;
end;

function prevMember(vec: TStringVector; ind: Longint): Longint;
var
  found: Boolean;
  lv0: Longint;
  lv1: Longint;
begin
  lv0 := 0;
  lv1 := 0;
  found := false;

  ind := ind - 1;
  while not found do
  begin
    if (ind >= 0) then
    begin
      if (vec.getStr(ind) = ']') then
      begin
        lv0 := lv0 + 1;
      end
      else if (vec.getStr(ind) = '[') then
      begin
        lv0 := lv0 - 1;
      end
      else if (vec.getStr(ind) = ')') then
      begin
        lv1 := lv1 + 1;
      end
      else if (vec.getStr(ind) = '(') then
      begin
        lv1 := lv1 - 1;
      end;
      if (lv0 = 0) and (lv1 = 0) then
      begin
        if (ind - 1 < 0) or not (est(vec.getStr(ind), vecUni) or est(vec.getStr(ind), vecOpen) or est(vec.getStr(ind-1), vecOpen)) then
        begin
          break;
        end;
      end;
    end
    else
    begin
      break;
    end;
    ind := ind - 1;
  end;

  prevMember := ind;
end;

function prevMemberAbs(vec: TStringVector; ind: Longint): Longint;
var
  found: Boolean;
  lv0: Longint;
  lv1: Longint;
begin
  lv0 := 0;
  lv1 := 0;
  found := false;

  ind := ind - 1;
  while not found do
  begin
    if (ind >= 0) then
    begin
      if (vec.getStr(ind) = ']') then
      begin
        lv0 := lv0 + 1;
      end
      else if (vec.getStr(ind) = '[') then
      begin
        lv0 := lv0 - 1;
      end
      else if (vec.getStr(ind) = ')') then
      begin
        lv1 := lv1 + 1;
      end
      else if (vec.getStr(ind) = '(') then
      begin
        lv1 := lv1 - 1;
      end;
      if (lv0 = 0) and (lv1 = 0) then
      begin
        if (ind - 1 < 0) or not (est(vec.getStr(ind), vecOpen) or est(vec.getStr(ind-1), vecOpen)) then
        begin
          break;
        end;
      end;
    end
    else
    begin
      break;
    end;
    ind := ind - 1;
  end;

  prevMemberAbs := ind;
end;

function replace(str: AnsiString; co: char; cr: char): AnsiString;
var
  len: Longint;
  i: Longint;
  s: AnsiString;
begin
  len := Length(str);
  s := '';

  for i := 1 to len do
  begin
    if (str[i] = co) then
    begin
      s := s + cr;
    end
    else
    begin
      s := s + str[i];
    end;
  end;

  replace := s;
end;

function overloaded(m: TMethode; ac: TClasse; cl: TClasse): Boolean;
var
  i: Longint;
begin

  while (cl <> ac) do
  begin
    for i := 0 to cl.meth.size - 1 do
    begin
      if m.sameAs(cl.meth.getMeth(i)) then
      begin
        overloaded := true;
        exit;
      end;
    end;
    cl := cl.sup;
  end;

  overloaded := false;
end;

function overloads(m: TMethode; cl: TClasse): Boolean;
var
  i: Longint;
begin

  while (cl <> nil) do
  begin

    for i := 0 to cl.meth.size - 1 do
    begin
      if m.sameAs(cl.meth.getMeth(i)) then
      begin
        overloads := true;
        exit;
      end;
    end;

    cl := cl.sup;
  end;

  overloads := false;
end;

function overloads(a: TAttribute; cl: TClasse): Boolean;
begin

  while (cl <> nil) do
  begin

    if cl.attr.contains(a.name) then
    begin
      overloads := true;
      exit;
    end;

    cl := cl.sup;
  end;

  overloads := false;
end;

function count(c: char; str: AnsiString): Longint;
var
  i: Longint;
  cpt: Longint;
begin
  cpt := 0;
  for i := 1 to Length(str) do
  begin
    if (c = str[i]) then
    begin
      cpt := cpt + 1;
    end;
  end;

  count := cpt;
end;

function isClass(str: AnsiString): Boolean;
begin
  isClass := vecCl.contains(str);
end;

function isDigit(c: char): Boolean;
begin
  isDigit := est(c, vecDigit);
end;

function convertType(t: AnsiString): AnsiString;
var
  i: Longint;
begin

  if vecCl.contains(t) then
  begin
    if vecCl.return(t).inter then
    begin
      convertType := 'TObject * ';
      exit;
    end;
    convertType := 'T' + t + ' * ';
    exit;
  end;

  for i := 0 to vecT.size - 1 do
  begin
    if (t = vecT.getType(i).strMoka) then
    begin
      convertType := vecT.getType(i).strC;
      exit;
    end;
  end;

  convertType := t;
end;

function convertValue(t: AnsiString): AnsiString;
var
  i: Longint;
begin

  for i := 0 to vecT.size - 1 do
  begin
    if (vecT.getType(i).est(t)) then
    begin
      convertValue := vecT.getType(i).format(t);
      exit;
    end;
  end;

  convertValue := t;
end;

function getVisibility(str: AnsiString): Longint;
var
  visi: Longint;
begin

  if (str = 'private') then
  begin
    visi := vPrivate;
  end
  else if (str = 'protected') then
  begin
    visi := vProtected;
  end
  else
  begin
    visi := vPublic;
  end;

  getVisibility := visi;
end;

function nextInstIndex(vec: TStringVector; ind: Longint): Longint;
var
  lv: Longint;
begin

  while (ind < vec.size) do
  begin
    if (vec.getStr(ind) = ';') then
    begin
      ind := ind + 1;
      break;
    end
    else if (vec.getStr(ind) = '{') then
    begin
      lv := 1;
      ind := ind + 1;
      while (ind < vec.size) and not ((lv = 0) and (vec.getStr(ind) = '}')) do
      begin
        if (vec.getStr(ind) = '}') then
        begin
          lv := lv - 1;
          if (lv = 0) then
          begin
            ind := ind + 1;
            break;
          end;
        end
        else if (vec.getStr(ind) = '{') then
        begin
          lv := lv + 1;
        end;
        ind := ind + 1;
      end;
      break;
    end;
    ind := ind + 1;
  end;

  nextInstIndex := ind;
end;

function nextIndexSkip(vec: TStringVector; str: AnsiString; ind: Longint): Longint;
var
  len: Longint;
  lv0: Longint;
  lv1: Longint;
  lv2: Longint;
begin
  len := vec.size - 1;
  lv0 := 0;
  lv1 := 0;
  lv2 := 0;

  while (ind < len) do
  begin
    if (vec.getStr(ind) = '[') then
    begin
      lv0 := lv0 + 1;
    end
    else if (vec.getStr(ind) = ']') then
    begin
      lv0 := lv0 - 1;
    end
    else if (vec.getStr(ind) = '(') then
    begin
      lv1 := lv1 + 1;
    end
    else if (vec.getStr(ind) = ')') then
    begin
      lv1 := lv1 - 1;
    end
    else if (vec.getStr(ind) = '{') then
    begin
      lv2 := lv2 + 1;
    end
    else if (vec.getStr(ind) = '}') then
    begin
      lv2 := lv2 - 1;
    end;
    if (lv0 = 0) and (lv1 = 0) and (lv2 = 0) and (vec.getStr(ind) = str) then
    begin
      break;
    end;
    ind := ind + 1;
  end;

  if (ind >= len) then
  begin
    ind := -1;
  end;

  nextIndexSkip := ind;
end;

function nextIndex(vec: TStringVector; str: AnsiString; ind: Longint): Longint;
var
  len: Longint;
begin
  len := vec.size - 1;

  while (ind < len) do
  begin
    if (vec.getStr(ind) = str) then
    begin
      break;          
    end;
    ind := ind + 1;
  end;

  if (ind >= len) then
  begin
    ind := -1;
  end;

  nextIndex := ind;
end;

procedure pushError(lv: Longint; msg: AnsiString);
var
i: Longint;
begin
  Writeln('');

  for i := 0 to lv - 1 do
  begin
    Write(#9);
  end;

  Writeln(msg);

  halt;
end;

function getInner(vec: TStringVector; ind: Longint): TStringVector;
begin
  getInner := getInner(vec, ind, '(', ')');
end;

function getInner(vec: TStringVector; ind: Longint; open: AnsiString; close: AnsiString): TStringVector;
var
  i: TStringVector;
  lv: Longint;
  str: AnsiString;
begin

  i := TStringVector.Create(25, 50);
  lv := 1;

  while (ind < vec.size) and (vec.getStr(ind) <> open) do
  begin
    ind := ind + 1;
  end;

  ind := ind + 1;



  while (ind < vec.size) and not ((lv = 0) and (vec.getStr(ind) = close)) do
  begin
    if (vec.getStr(ind) = close) then
    begin
      lv := lv - 1;
      if (lv <> 0) then
      begin
        i.add(vec.getStr(ind));
      end
      else
      begin
        break;
      end;
    end
    else if (vec.getStr(ind) = open) then
    begin
      i.add(vec.getStr(ind));
      lv := lv + 1;
    end
    else
    begin
      i.add(vec.getStr(ind));
    end;
    ind := ind + 1;
  end;
  


  str := '';
  if (cMeth <> nil) then
  begin

    str := ', method ' + cMeth.name;
  end
  else if (cAttr <> nil) then
  begin
    str := ', attribute ' + cAttr.name;
  end;



  if (ind >= vec.size) then
  begin
    pushError(1, 'Error: ''' + close + ''' expected in class ' + cClass.name + str + ' (' + cClass.fileName + ').');
  end;



  getInner := i;

end;

function getBlock(vec: TStringVector; ind: Longint): TStringVector;
var
  b: TStringVector;
  lv: Longint;
  str: AnsiString;
begin
  b := TStringVector.Create(25, 50);
  lv := 1;

  while (ind < vec.size) and (vec.getStr(ind) <> '{') do
  begin
    ind := ind + 1;
  end;

  ind := ind + 1;

  while (ind < vec.size) and not ((lv = 0) and (vec.getStr(ind) = '}')) do
  begin
    if (vec.getStr(ind) = '}') then
    begin
      lv := lv - 1;
      if (lv <> 0) then
      begin
        b.add(vec.getStr(ind));
      end
      else
      begin
        break;
      end;
    end
    else if (vec.getStr(ind) = '{') then
    begin
      b.add(vec.getStr(ind));
      lv := lv + 1;
    end
    else
    begin
      b.add(vec.getStr(ind));
    end;
    ind := ind + 1;
  end;

  str := '';

  if (cMeth <> nil) then
  begin
    str := ', method ' + cMeth.name;
  end
  else if (cAttr <> nil) then
  begin
    str := ', attribute ' + cMeth.name;
  end;

  if (ind >= vec.size) then
  begin
    pushError(1, 'Error: ''}'' expected in class ' + cClass.name + str + ' (' + cClass.fileName + ').');
  end;

  getBlock := b;
end;

function getFilesVector(dir: AnsiString; ext: AnsiString): TStringVector;
var
  MySearch: TSearchRec;
  FindResult: Integer;
  vec: TStringVector;
begin
  FindResult:=FindFirst(dir+pathSeparator+ext, faAnyFile, MySearch);

  vec := TStringVector.Create;


  if (MySearch.Attr<>faDirectory) and (FindResult = 0) then
    vec.add(MySearch.Name);

  while FindNext(MySearch)=0 do
  begin
    if (MySearch.Attr<>faDirectory) then
      vec.add(MySearch.Name);
  end;

  getFilesVector := vec;
end;

function isComment(str: AnsiString): Boolean;
begin
  if (Length(str) > 2) and (str[1] = '/') and ((str[2] = '*') or (str[2] = '/')) then
  begin
    isComment := true;
  end
  else
  begin
    isComment := false;
  end;
end;

function extractDirectory(str: AnsiString): AnsiString;
var
  len: Longint;
  i: Longint;
  dir: AnsiString;
  tok: AnsiString;
begin
  len := Length(str);
  if (pathSeparator = '/') then
  begin
   (* I'm on a UNIX system ...*)
   if ((len > 0) and (str[1] = pathSeparator)) then
   begin
        dir := '/';
   end;
  end
  else
  begin
    dir := '';
  end;
  tok := '';

  for i:= 1 to len do
  begin
    if (str[i] = pathSeparator) then
    begin
      if (dir <> '') then
      begin
        dir := dir + pathSeparator;
      end;
      dir := dir + tok;
      tok := '';
    end
    else
    begin
      tok := tok + str[i];
    end;
  end;

  if (dir = '') then
  begin
    dir := GetCurrentDir();
  end;

  extractDirectory := dir;
end;

function extractClass(str: AnsiString): AnsiString;
var
  len: Longint;
  i: Longint;
  className: AnsiString;
  tok: AnsiString;
begin
  len := Length(str);
  className := '';
  tok := '';

  for i:= 1 to len do
  begin
    tok := tok + str[i];
    if (str[i] = pathSeparator) then
    begin
      tok := '';
    end;
  end;

  len := Length(tok) - 5;

  for i := 1 to len do
  begin
    className := className + tok[i];
  end;

  extractClass := className;
end;

function extractFile(str: AnsiString): AnsiString;
var
  len: Longint;
  i: Longint;
  tok: AnsiString;
begin
  len := Length(str);
  tok := '';

  for i:= 1 to len do
  begin
    tok := tok + str[i];
    if (str[i] = pathSeparator) then
    begin
      tok := '';
    end;
  end;

  extractFile := tok;
end;

function strBeginsWith(str: AnsiString; strBegin: AnsiString): Boolean;
var
  len: Longint;
  len0: Longint;
  size: Longint;
  i: Longint;
begin
  len := Length(str);
  len0 := Length(strBegin);

  if (len < len0) then
  begin
    strBeginsWith := false;
    exit;
  end;

  size := len0 - 1;

  for i := 0 to size do
  begin
    if (str[i] <> strBegin[i]) then
    begin
      strBeginsWith := false;
      exit;
    end;
  end;

  strBeginsWith := true;
end;

function strEndsWith(str: AnsiString; strEnd: AnsiString): Boolean;
var
  len: Longint;
  len0: Longint;
  size: Longint;
  i: Longint;
begin
  len := Length(str);
  len0 := Length(strEnd);

  if (len < len0) then
  begin
    strEndsWith := false;
    exit;
  end;

  size := len0 - 1;

  for i := 0 to size do
  begin
    if (str[len-i] <> strEnd[len0-i]) then
    begin
      strEndsWith := false;
      exit;
    end;
  end;

  strEndsWith := true;
end;

procedure writeStringToFile (fileText: AnsiString; fileName: AnsiString);
var
  fileHand: TextFile;
begin
  AssignFile(fileHand, fileName);
  //FileMode := fmOpenWrite;

  ReWrite(fileHand);

  Write(fileHand, fileText);

  CloseFile(fileHand);
end;

function readFileAsString (fileName: AnsiString): AnsiString;
var
  fileText: AnsiString;
  fileHand: TextFile;//File of char;
  //buffer: Char;
  buffer: AnsiString;
  //size: Longint;
begin
  AssignFile(fileHand, fileName);
  FileMode := fmOpenRead;

 // Reset(fileHand);

  //size := FileSize(fileHand);

  fileText := '';

  Reset(fileHand);

  while not EOF(fileHand) do
  begin
    //Read(fileHand, buffer);
    Readln(fileHand, buffer);
    //BlockRead(fileHand, buffer, size);
    //fileText := fileText + char(buffer);
    if (fileText <> '') then
    begin
      fileText := fileText + newLine;
    end;
    fileText := fileText + buffer;
  end;

  CloseFile(fileHand);
  readFileAsString := fileText;
end;

function getPos (c: char; vec: array of char): Longint;
var
  i: longint;
  size: longint;
begin
  size := Length(vec) - 1;

  for i := 0 to size do
  begin
    if c = vec[i] then
    begin
      getPos := i;
      exit;
    end;
  end;

  getPos := -1;
end;

function est (c: char; vec:array of char): Boolean; overload;
var
  i: longint;
  size: longint;
begin
  size := Length(vec) - 1;

  for i := 0 to size do
  begin
    if c = vec[i] then
    begin
      est := true;
      exit;
    end;
  end;

  est := false;
end;

function est (str: AnsiString; vec:array of AnsiString): Boolean; overload;
var
  i: longint;
  size: longint;
begin
  size := Length(vec) - 1;

  for i := 0 to size do
  begin
    if str = vec[i] then
    begin
      est := true;
      exit;
    end;
  end;

  est := false;
end;

function commence (c: char; vec:array of AnsiString): Boolean;
var
  i: longint;
  size: longint;
begin
  size := Length(vec) - 1;

  for i := 0 to size do
  begin
    if c = vec[i][1] then
    begin
      commence := true;
      exit;
    end;
  end;

  commence := false;
end;
end.
