(*
 * QUSOFT MICROSYSTMES
 * Moka
 * Copyright 2003 Frdric Brown
 *)

(*
 *  This file is part of Moka.
 *
 *  Moka is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.

 *  Moka is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with Moka; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *)

(*
 * Converter unit contains method to convert the methods' instructions or
 * the attributes' values.
 *)

unit Converter;

interface

uses Reflect, Util;

function convertAttr(cl: TClasse; a: TAttribute): TStringVector;
function convertMeth(cl: TClasse; m: TMethode): TStringVector;
function convert(vec: TStringVector; i: Longint; pv: TParameterVector): TStringVector;

implementation

uses SysUtils, Globals, Funcs, Tokenizer;

function convertAttr(cl: TClasse; a: TAttribute): TStringVector;
begin
  cClass := cl;
  cMeth := nil;
  cAttr := a;
  finalNum := 0;
  convertAttr := convert(a.value, 0, addClassesAsParam(TParameterVector.Create));
end;

function convertMeth(cl: TClasse; m: TMethode): TStringVector;
var
  txt : TStringVector;
begin
  cClass := cl;
  cMeth := m;
  cAttr := nil;
  finalNum := 0;

  txt := convert(m.words, 0, addClassesAsParam(m.params.copy));
  if (cMeth.locals.size > 0) then
  begin
    txt.add(';', 0);
    txt.add(')', 0);
    txt.add('& _local_GarbageCollector_instance_reserved_keyword', 0);
    txt.add('(', 0);
    txt.add('ADT_GarbageCollector_init', 0);
    txt.add(';', 0);
    txt.add('_local_GarbageCollector_instance_reserved_keyword', 0);
    txt.add('ADT_GarbageCollector', 0);
    if (cMeth.rType = 'void') then
    begin
      txt.add('ADT_GarbageCollector_clearObjects');
      txt.add('(');
      txt.add('& _local_GarbageCollector_instance_reserved_keyword');
      txt.add(')');
      txt.add(';');
    end;
  end;

  convertMeth := txt;
end;

function convert(vec: TStringVector; i: Longint; pv: TParameterVector): TStringVector;
var
  ovec: TStringVector;
  wd: AnsiString;
  n: Longint;
  z: Longint;
  o: Longint;
  tempBuf: TStringVector;
  pos: Longint;
  str: AnsiString;
  buf: TStringVector;
  decl: TStringVector;
  typv: TStringVector;
  a: TAttribute;
  cl: TClasse;
  temp: TParameterVector;
  first :Boolean;
  localObjects: TStringVector;
begin
  ovec := TStringVector.Create(50, 100);

  while (i < vec.size) do
  begin
    wd := vec.getStr(i);
    if (wd = 'native') then
    begin
      i := i + 1;
      wd := vec.getStr(i);
      if not est(wd, vecNat) then
      begin
        if (cMeth <> nil) then
        begin
          pushError(2, 'Error : ''{'', ''.'' or ''('' expected after the native keyword in the method ' + cMeth.name + ' of the class ' + cClass.name + ' (' + cClass.fileName + ').');
        end
        else
        begin
          pushError(2, 'Error : ''{'', ''.'' or ''('' expected after the native keyword in the attribute ' + cAttr.name + ' of the class ' + cClass.name + ' (' + cClass.fileName + ').');
        end;
      end;
      if (wd = '{') then
      begin
        i := i + 1;
        wd := vec.getStr(i);
        if (i >= vec.size) then
        begin
          if (cMeth <> nil) then
          begin
            pushError(2, 'Error : Expression expected after ''native {'' in the method ' + cMeth.name + ' of the class ' + cClass.name + ' (' + cClass.fileName + ').');
          end
          else
          begin
            pushError(2, 'Error : Expression expected after ''native {'' in the attribute ' + cAttr.name + ' of the class ' + cClass.name + ' (' + cClass.fileName + ').');
          end;
        end;
        ovec.add(wd);
        i := i + 1;
        wd := vec.getStr(i);
        if (i >= vec.size) or (wd <> '}') then
        begin
          if (cMeth <> nil) then
          begin
            pushError(2, 'Error : ''}'' expected after ''native {'' in the method ' + cMeth.name + ' of the class ' + cClass.name + ' (' + cClass.fileName + ').');
          end
          else
          begin
            pushError(2, 'Error : ''}'' expected after ''native {'' in the attribute ' + cAttr.name + ' of the class ' + cClass.name + ' (' + cClass.fileName + ').');
          end;
        end;
        i := i + 1;
        continue;
      end;
      if (wd = '(') then
      begin
        ovec.add(wd);
        i := i + 1;
        wd := vec.getStr(i);
        if (i >= vec.size) then
        begin
          if (cMeth <> nil) then
          begin
            pushError(2, 'Error : Expression expected after ''native ('' in the method ' + cMeth.name + ' of the class ' + cClass.name + ' (' + cClass.fileName + ').');
          end
          else
          begin
            pushError(2, 'Error : Expression expected after ''native ('' in the attribute ' + cAttr.name + ' of the class ' + cClass.name + ' (' + cClass.fileName + ').');
          end;
        end;
        ovec.add(wd);
        i := i + 1;
        wd := vec.getStr(i);
        if (i >= vec.size) or (wd <> ')') then
        begin
          if (cMeth <> nil) then
          begin
            pushError(2, 'Error : '')'' expected after ''native {'' in the method ' + cMeth.name + ' of the class ' + cClass.name + ' (' + cClass.fileName + ').');
          end
          else
          begin
            pushError(2, 'Error : '')'' expected after ''native {'' in the attribute ' + cAttr.name + ' of the class ' + cClass.name + ' (' + cClass.fileName + ').');
          end;
        end;
        ovec.add(wd);
        i := i + 1;
        continue;
      end;
      if (wd = '.') then
      begin
        i := i + 1;
        pos := nextExpr(vec, i);
        for n := i to pos - 1 do
        begin
          ovec.add(vec.getStr(n));
        end;
        i := pos;
        continue;
      end;
    end;
    if (wd = 'asm') then
    begin
      ovec.add('asm');
      i := i + 1;
      wd := vec.getStr(i);
      if (i >= vec.size) or ((wd <> '{') and (wd <> '(')) then
      begin
        if (cMeth <> nil) then
        begin
          pushError(2, 'Error : ''{'' or ''('' expected after the asm keyword in the method ' + cMeth.name + ' of the class ' + cClass.name + ' (' + cClass.fileName + ').');
        end
        else
        begin
          pushError(2, 'Error : ''{'' or ''('' expected after the asm keyword in the attribute ' + cAttr.name + ' of the class ' + cClass.name + ' (' + cClass.fileName + ').');
        end;
      end;

      if (wd = '{') then
      begin
        str := str + '("';
        //ovec.add('("');
      end
      else
      begin
        ovec.add(wd);
      end;
      i := i + 1;
      wd := vec.getStr(i);
      if (i >= vec.size) then
      begin
        if (cMeth <> nil) then
        begin
          pushError(2, 'Error : Expression expected after asm in the method ' + cMeth.name + ' of the class ' + cClass.name + ' (' + cClass.fileName + ').');
        end
        else
        begin
          pushError(2, 'Error : Expression expected after asm in the attribute ' + cAttr.name + ' of the class ' + cClass.name + ' (' + cClass.fileName + ').');
        end;
      end;
      if (str <> '') then
      begin
        str := str + wd;
        //ovec.add('("');
      end
      else
      begin
        ovec.add(wd);
      end;
      i := i + 1;
      wd := vec.getStr(i);
      if (i >= vec.size) or ((wd <> '}') and (wd <> ')')) then
      begin
        if (cMeth <> nil) then
        begin
          pushError(2, 'Error : ''}'' or '')'' expected after asm in the method ' + cMeth.name + ' of the class ' + cClass.name + ' (' + cClass.fileName + ').');
        end
        else
        begin
          pushError(2, 'Error : ''}'' or '')'' expected after asm in the attribute ' + cAttr.name + ' of the class ' + cClass.name + ' (' + cClass.fileName + ').');
        end;
      end;

      if (wd = '}') then
      begin
        str := str + '") ;';
        ovec.add(str);
        //ovec.add('");');
      end
      else
      begin
        ovec.add(wd);
      end;
      i := i + 1;
      continue;
    end;
    if (wd = '(') and (i + 1 < vec.size) and (est(vec.getStr(i+1), vecTypes) or isClass(vec.getStr(i+1))) and not ((i + 1 < vec.size) and (vec.getStr(i+1) = ')'))  then
    begin
      buf := TStringVector.Create;
      n := i + 1;
      buf.add('(');
      buf.add(convertType(vec.getStr(n)));
      n := n + 1;

      while (n < vec.size) and ((vec.getStr(n) = '*') or ((n + 1 < vec.size) and (vec.getStr(n) = '[') and (vec.getStr(n+1) = ']'))) do
      begin
        if (vec.getStr(n) = '[') then
        begin
          n := n + 1;
        end;
        n := n + 1;
        buf.add('*');
      end;
      buf.add(')');
      if (vec.getStr(n) = ')') then
      begin
        ovec.add(buf);
        i := n + 1;
        continue;
      end
      else
      begin
      ovec.add('(');
      ovec.add(convert(getInner(vec, i), 0, pv));
      ovec.add(')');
      i := skip(vec, i, '(', ')');
      continue;
      end;
    end;
    if (wd = '[') and (i + 1 < vec.size) and (vec.getStr(i + 1) = ']') then
    begin
      //2004-11-18
      (*if (i - 1 >= 0) then
      begin
        ovec.add('*', i - 1);
        i := i + 2;
      end
      else
      begin
        pushError(2, 'Error : Type identifier expected after [] in the method ' + cMeth.name + ' of the class ' + cClass.name + ' (' + cClass.fileName + ').');
      end; *)
      ovec.add('*');
      i := i + 2;
      continue;
    end;
    if (wd = '[') then
    begin
      ovec.add('[');
      ovec.add(convert(getInner(vec, i, '[', ']'), 0, pv));
      ovec.add(']');
      i := skip(vec, i, '[', ']');
      continue;
    end;
    if (wd = '(') then
    begin
      ovec.add('(');
      ovec.add(convert(getInner(vec, i), 0, pv));
      ovec.add(')');
      i := skip(vec, i, '(', ')');
      continue;
    end;
    if (wd = '{') then
    begin
      ovec.add('{');
      ovec.add(convert(getBlock(vec, i), 0, pv.copy()));
      ovec.add('}');
      i := skip(vec, i, '{', '}');
      continue;
    end;
    if (nextExpr(vec, i) < vec.size) and (vec.getStr(nextExpr(vec, i)) = 'instanceof') then
    begin
      ovec.add('instanceof');
      ovec.add('(');
      ovec.add('(');
      ovec.add('TObject *');
      ovec.add(')');
      //ovec.add(convert(returnExprLeft(vec, nextExpr(vec, i)), 0, pv));
      buf := convert(returnRange(vec, i, nextExpr(vec, i)-1), 0, pv)   ;
      ovec.add(buf);
      ovec.add(',');
      ovec.add('(');
      ovec.add('TObject *');
      ovec.add(')');
      ovec.add(convert(returnExprRight(vec, nextExpr(vec, i)), 0, pv));
      ovec.add(')');
      i := nextExpr(vec, nextExpr(vec, nextExpr(vec, i)));
      continue;
    end;
    if est(wd, vecTypes) or ((i + 1 < vec.size) and isClass(wd) and (not est(vec.getStr(i+1), vecKey) or est(vec.getStr(i+1), vecPtr))) then
    begin

      typv := TStringVector.Create;
      typv.add(wd);

      ovec.add(convertType(wd)) ;

      i := i + 1;

      (*while est(vec.getStr(i), vecPtr) do
      begin
        typv.add('*');
        if (vec.getStr(i) = '[') then
        begin
          i := skip(vec, i, '[', ']');
        end
        else
        begin
          i := i + 1;
        end;
      end;
      *)

      first := true;

      //while (nextIndex(vec, ',', i) >= 0) and (nextIndex(vec, ',', i) < nextIndex(vec, ';', i)) do
      //Modified 2004/11/13
      while (nextIndexSkip(vec, ',', i) >= 0) and (nextIndexSkip(vec, ',', i) < nextIndexSkip(vec, ';', i)) do
      begin

        decl := getUpTo(vec, i, ',');

        decl.add(typv, 0);

        a := getAttribute(decl, 0);

        pv.add(TParameter.Create(a.rType, a.rPtr, a.name));

        buf := TStringVector.Create;

        a.rPtr := '';

        if (isClass(a.rType)) and not first then
        begin
          a.rPtr := '* ';
        end;

        buf.add(getStringVector(a.rPtr));

        buf.add(getUpTo(vec, i, ','));

        ovec.add(convert(buf, 0, pv));

        i := skipTo(vec, ',', i) + 1;

        first := false;
      end;

      decl := getUpTo(vec, i, ';');

      decl.add(typv, 0);

      a := getAttribute(decl, 0);

      pv.add(TParameter.Create(a.rType, a.rPtr, a.name));

      buf := TStringVector.Create;

      a.rPtr := '';

      if (isClass(a.rType)) and not first then
      begin
        a.rPtr := '* ';
      end;

      buf.add(getStringVector(a.rPtr));

      buf.add(getUpTo(vec, i, ';'));

      ovec.add(convert(buf, 0, pv));

      i := skipTo(vec, ';', i) + 1;
      continue;
    end;
    (*if ((wd = '+=') or (wd = '+')) and (returnExprLeft(vec, i).size > 0) and (returnExprType(returnExprLeft(vec, i).toString, pv).rType = 'String') and (returnExprType(returnExprLeft(vec, i).toString, pv).rPtr = '') then
    begin
      if (wd = '+=') then
      begin
        vec.setStr('=', i);
        vec.add(returnExprLeft(vec, i), i + 1);
        vec.add('+', i + 2);
      end
      else
      begin
        buf := returnExprRight(vec, i);
        for n := nextExpr(vec, i) to nextExpr(vec, nextExpr(vec, i)) - 1 do
        begin
          vec.rem(nextExpr(vec, i));
        end;
        vec.setStr('.', i);
        vec.add('concat', i + 1);
        vec.add('(', i + 2);
        vec.add(')', i + 3);
        vec.add(buf, i + 3);
      end;
      continue;
    end;*)     
    if est(wd, vecKey) then
    begin

      if (wd = '.') then
      begin
        ovec.add('->');
        i := i + 1;
        continue;
      end;
      if (wd = 'return') then
      begin
        if (cMeth.locals.size > 0) then
        begin
          ovec.add('ADT_GarbageCollector_clearObjects');
          ovec.add('(');
          ovec.add('& _local_GarbageCollector_instance_reserved_keyword');
          ovec.add(')');
          ovec.add(';');
        end;
        ovec.add('return');
        i := i + 1;
        continue;
      end;
      if (wd = 'new') then
      begin
        if (i + 1 >= vec.size) then
        begin
          pushError(2, 'Error : identifier expected after new in the method ' + cMeth.name + ' of the class ' + cClass.name + ' (' + cClass.fileName + ').');
        end;

        if (i + 2 < vec.size) and (vec.getStr(i + 2) = '[') then
        begin
          ovec.add('System_malloc_long_int');
          ovec.add('(');
          ovec.add('sizeof');
          ovec.add('(');
          ovec.add(convertType(vec.getStr(i+1)));
          (*
          if (vecCl.return(vec.getStr(i+1)) = nil) then
          begin
            ovec.add(vec.getStr(i+1));
          end
          else
          begin
            ovec.add('T' + vec.getStr(i+1) + '*');
          end;
          *)
          ovec.add(')');
          z := i + 2;
          while (z < vec.size) and (vec.getStr(z) = '[') do
          begin
            ovec.add('*');
            ovec.add('(');
            ovec.add(convert(getInner(vec, z, '[', ']'), 0, pv));
            ovec.add(')');
            z := skip(vec, z, '[', ']');
          end;
          ovec.add(')');
          i := z;
        end
        else if (vecCl.return(vec.getStr(i+1)) = nil) then
        begin
          pushError(2, 'Error : Class identifier expected but ''' + vec.getStr(i+1) + ''' found in the method ' + cMeth.name + ' of the class ' + cClass.name + ' (' + cClass.fileName + ').');
        end
        else
        begin
          ovec.add('T' + vec.getStr(i+1) + getTypesVec(getInner(vec, i, '(', ')'), pv, vecCl.return(vec.getStr(i+1)).meth.getMVec(vec.getStr(i+1))).getMorph);
          i := i + 2;
        end;
        continue;
      end;
      if (wd = 'local') then
      begin
        if (i + 1 >= vec.size) then
        begin
          pushError(2, 'Error : identifier expected after local in the method ' + cMeth.name + ' of the class ' + cClass.name + ' (' + cClass.fileName + ').');
        end;

        if (i + 2 < vec.size) and (vec.getStr(i + 2) = '[') then
        begin
          pushError(2, 'Error : local array are not supported but declared in the method ' + cMeth.name + ' of the class ' + cClass.name + ' (' + cClass.fileName + ').');
        end
        else if (vecCl.return(vec.getStr(i+1)) = nil) then
        begin
          pushError(2, 'Error : Class identifier expected but ''' + vec.getStr(i+1) + ''' found in the method ' + cMeth.name + ' of the class ' + cClass.name + ' (' + cClass.fileName + ').');
        end
        else
        begin
          ovec.add('ADT_GarbageCollector_add');
          ovec.add('(');
          ovec.add('& _local_GarbageCollector_instance_reserved_keyword');
          ovec.add(',');
          ovec.add('T' + vec.getStr(i+1) + getTypesVec(getInner(vec, i, '(', ')'), pv, vecCl.return(vec.getStr(i+1)).meth.getMVec(vec.getStr(i+1))).getMorph);
          ovec.add('(');
          ovec.add(convert(getInner(vec, i), 0, pv));
          ovec.add(')');
          ovec.add(')');

          usesGarbageCollector := true;

          cMeth.locals.add(vec.getStr(i+1));
          i := skip(vec, i, '(', ')');
        end;
        continue;
      end;
      if (wd = 'global') then
      begin
        if (i + 1 >= vec.size) then
        begin
          pushError(2, 'Error : identifier expected after local in the method ' + cMeth.name + ' of the class ' + cClass.name + ' (' + cClass.fileName + ').');
        end;

        if (i + 2 < vec.size) and (vec.getStr(i + 2) = '[') then
        begin
          pushError(2, 'Error : local array are not supported but declared in the method ' + cMeth.name + ' of the class ' + cClass.name + ' (' + cClass.fileName + ').');
        end
        else if (vecCl.return(vec.getStr(i+1)) = nil) then
        begin
          pushError(2, 'Error : Class identifier expected but ''' + vec.getStr(i+1) + ''' found in the method ' + cMeth.name + ' of the class ' + cClass.name + ' (' + cClass.fileName + ').');
        end
        else
        begin
          ovec.add('ADT_GarbageCollector_add');
          ovec.add('(');
          ovec.add('& _global_GarbageCollector_instance_reserved_keyword');
          ovec.add(',');
          ovec.add('T' + vec.getStr(i+1) + getTypesVec(getInner(vec, i, '(', ')'), pv, vecCl.return(vec.getStr(i+1)).meth.getMVec(vec.getStr(i+1))).getMorph);
          ovec.add('(');
          ovec.add(convert(getInner(vec, i), 0, pv));
          ovec.add(')');
          ovec.add(')');

          usesGarbageCollector := true;

          globalObjects.add(vec.getStr(i+1));
          i := skip(vec, i, '(', ')');
        end;
        continue;
      end;
      if (i + 1 < vec.size) and (wd = 'super') and (vec.getStr(i+1) = '(') then
      begin
        if (cClass.sup = nil) then
        begin
          pushError(2, 'Error : super keyword not expected in the method ' + cMeth.name + ' of the class ' + cClass.name + ' (' + cClass.fileName + ') as ' + cClass.name + ' has no superclass.');
        end;
        ovec.add(cClass.sup.name + '_' + getTypesVec(getInner(vec, i, '(', ')'), pv, vecCl.return(cClass.sup.name).getMVec(cClass.sup.name)).getMorph);
        if (getTypesVec(getInner(vec, i, '(', ')'), pv, vecCl.return(cClass.sup.name).getMVec(cClass.sup.name)).size > 0) then
        begin
          vec.add(',', i + 2);
        end;
        vec.add('this', i + 2);
        vec.add(')', i + 2);
        vec.add(cClass.sup.name, i + 2);
        vec.add('(', i + 2);
        i := i + 1;
        continue;
      end;
      if (i + 1 < vec.size) and (wd = 'this') and (vec.getStr(i+1) = '(') then
      begin
        ovec.add(cClass.name + '_' + getTypesVec(getInner(vec, i, '(', ')'), pv, vecCl.return(cClass.name).getMVec(vec.getStr(i+1))).getMorph);
        if (getTypesVec(getInner(vec, i, '(', ')'), pv, vecCl.return(cClass.name).getMVec(vec.getStr(i+1))).size > 0) then
        begin
          vec.add(',', i + 2);
        end;
        vec.add('this', i + 2);
        i := i + 1;
        continue;
      end;
      if (wd = 'throw') then
      begin
        decl := getUpTo(vec, i+1, ';');
        i := skipTo(vec, ';', i) + 1;
        //decl.rem(decl.size - 1);

        ovec.add('TError');
        ovec.add('*');
        ovec.add('errCode_Temporary_Error_Object_reserved_keyword');
        ovec.add('=');
        ovec.add(convert(decl, 0, pv));
        ovec.add(getStringVector('if ( Error_error ) { if ( Error_error != errCode_Temporary_Error_Object_reserved_keyword ) {'));
        ovec.add('Error_error');
        ovec.add('->');
        ovec.add(getStringVector('finalize_(Error_error) ; Error_error = errCode_Temporary_Error_Object_reserved_keyword ; } goto label' + intToStr(finalNum) + '_finally_reserved_keyword ; } else { Error_error = errCode_Temporary_Error_Object_reserved_keyword ;'));
        ovec.add(getStringVector('ER_throwVar ( Error_error'));
        ovec.add('->');
        ovec.add(getStringVector('errCode ) ; }'));

        (*
        ovec.add('TError');
        ovec.add('*');
        ovec.add('errCode_Temporary_Error_Object_reserved_keyword');
        ovec.add('=');
        ovec.add(convert(decl, 0, pv));


        ovec.add('short int');
        ovec.add('errCode_Temporary_Error_Number_reserved_keyword');
        ovec.add('=');
        buf := TStringVector.Create;
        buf.add('errCode_Temporary_Error_Object_reserved_keyword');
        buf.add('->');
        buf.add('errCode');
        buf.add(';');
        ovec.add(buf);


        buf := TStringVector.Create;
        buf.add('errCode_Temporary_Error_Object_reserved_keyword');
        buf.add('->');
        buf.add('finalize_');
        buf.add('(');
        buf.add('errCode_Temporary_Error_Object_reserved_keyword');
        buf.add(')');
        buf.add(';');
        ovec.add(buf);

        ovec.add('ER_throwVar');
        ovec.add('(');
        ovec.add('errCode_Temporary_Error_Number_reserved_keyword');
        ovec.add(')');
        ovec.add(';');
        *)
        continue;
      end;
      if (wd = 'try') then
      begin
        ovec.add('TRY' + newLine);
        i := i + 1;
        wd := vec.getStr(i);
        if (wd = '{') then
        begin
          ovec.add(convert(getBlock(vec, i), 0, pv.copy));
          i := skip(vec, i, '{', '}');
        end
        else if (i < vec.size) then
        begin
          ovec.add(convert(getUpTo(vec, i, ';'), 0, pv.copy));
          i := skipTo(vec, ';', i) + 1;
        end;

        if (i >= vec.size) or ((vec.getStr(i) <> 'catch') and (vec.getStr(i) <> 'finally')) then
        begin
          pushError(2, 'Error : try without catch or finally in the method ' + cMeth.name + ' of the class ' + cClass.name + ' (' + cClass.fileName + ').');
        end;

        ovec.add('ONERR' + newLine);

        ovec.add(getStringVector('if ( ! Error_error ) { Error_error = TError_short_int( errCode ) ; }'));


        while (vec.getStr(i) = 'catch') do
        begin
          buf := TStringVector.Create;
          buf.add(getInner(vec, i));

          i := skip(vec, i, '(', ')');

          temp := pv.copy;
          temp.add(TParameter.Create(buf.getStr(0), '', buf.getStr(1)));

          ovec.add(getStringVector('if ( instanceof ( Error_error ,'));
          ovec.add(buf.getStr(0));
          ovec.add(getStringVector(' ) ) {'));
          ovec.add('T' + buf.getStr(0) + '*');
          ovec.add(buf.getStr(1));
          ovec.add('=');
          ovec.add('(');
          ovec.add('T' + buf.getStr(0) + '*');
          ovec.add(')');
          ovec.add(getStringVector('Error_error ;'));
          if (wd = '{') then
          begin
            ovec.add(convert(getBlock(vec, i), 0, temp));
            i := skip(vec, i, '{', '}');
          end
          else if (i < vec.size) then
          begin
            ovec.add(convert(getUpTo(vec, i, ';'), 0, temp));
            i := skipTo(vec, ';', i) + 1;
          end;
          ovec.add('if');
          ovec.add('(');
          ovec.add(buf.getStr(1));
          ovec.add(')');
          ovec.add('{');
          ovec.add(buf.getStr(1));
          ovec.add('->');
          ovec.add('finalize_');
          ovec.add('(');
          ovec.add(buf.getStr(1));
          ovec.add(')');
          ovec.add(';');
          ovec.add(getStringVector('Error_error = NULL ;'));
          ovec.add('}');

          ovec.add('}');
        end;

        ovec.add('ENDTRY' + newLine);

        ovec.add('label' + intToStr(finalNum) + '_finally_reserved_keyword');
        ovec.add(':' + newLine);

        finalNum := finalNum + 1;

        if (vec.getStr(i) = 'finally') then
        begin
          i := i + 1;
          wd := vec.getStr(i);
          if (wd = '{') then
          begin
            ovec.add(convert(getBlock(vec, i), 0, pv.copy));
            i := skip(vec, i, '{', '}');
          end
          else if (i < vec.size) then
          begin
            ovec.add(convert(getUpTo(vec, i, ';'), 0, pv.copy));
            i := skipTo(vec, ';', i) + 1;
          end;
        end;

        ovec.add(getStringVector('if ( Error_error ) ER_throwVar ( Error_error'));
        ovec.add('->');
        ovec.add(getStringVector('errCode ) ;'));

        (*
        if (vec.getStr(i) = 'catch') then
        begin
          buf := TStringVector.Create;

          buf.add(getInner(vec, i));

          i := skip(vec, i, '(', ')');

          temp := pv.copy;
          temp.add(TParameter.Create(buf.getStr(0), '', buf.getStr(1)));

          ovec.add('ONERR' + newLine);
          ovec.add('T' + buf.getStr(0) + '*');
          ovec.add(buf.getStr(1));

          ovec.add('=');
          ovec.add('TError_short_int');
          ovec.add('(');
          ovec.add('errCode');
          ovec.add(')');
          ovec.add(';');
          wd := vec.getStr(i);
          if (wd = '{') then
          begin
            ovec.add(convert(getBlock(vec, i), 0, temp));
            i := skip(vec, i, '{', '}');
          end
          else if (i < vec.size) then
          begin
            ovec.add(convert(getUpTo(vec, i, ';'), 0, temp));
            i := skipTo(vec, ';', i) + 1;
          end;
          ovec.add('if');
          ovec.add('(');
          ovec.add(buf.getStr(1));
          ovec.add(')');
          ovec.add(buf.getStr(1));
          ovec.add('->');
          ovec.add('finalize_');
          ovec.add('(');
          ovec.add(buf.getStr(1));
          ovec.add(')');
          ovec.add(';');
          ovec.add('ENDTRY' + newLine);
          if (vec.getStr(i) = 'finally') then
          begin
            i := i + 1;
            wd := vec.getStr(i);
            if (wd = '{') then
            begin
              ovec.add(convert(getBlock(vec, i), 0, pv.copy));
              i := skip(vec, i, '{', '}');
            end
            else if (i < vec.size) then
            begin
              ovec.add(convert(getUpTo(vec, i, ';'), 0, pv.copy));
              i := skipTo(vec, ';', i) + 1;
            end;
          end;
        end;

        if (vec.getStr(i) = 'finally') then
        begin
          ovec.add('ONERR' + newLine);
          ovec.add('ENDTRY' + newLine);
          //ovec.add('FINALLY' + newLine);
          i := i + 1;
          wd := vec.getStr(i);
          if (wd = '{') then
          begin
            ovec.add(convert(getBlock(vec, i), 0, pv.copy));
            i := skip(vec, i, '{', '}');
          end
          else if (i < vec.size) then
          begin
            ovec.add(convert(getUpTo(vec, i, ';'), 0, pv.copy));
            i := skipTo(vec, ';', i) + 1;
          end;
          //ovec.add('ENDFINAL' + newLine);
        end;
        *)
        continue;
      end;
      if (wd = 'for') then
      begin
        if (i + 3 < vec.size) and (vec.getStr(i + 3) <> '=') then
        begin
          decl := TStringVector.Create;
          if (nextIndex(vec, '=', i) < 0) then
          begin
            pushError(2, 'Error : ''='' expected after the for instruction in the method ' + cMeth.name + ' of the class ' + cClass.name + ' (' + cClass.fileName + ').');
          end;
          for n := i + 2 to nextIndex(vec, '=', i) - 2 do
          begin
            decl.add(vec.getStr(n));
          end;
          decl.add(vec.getStr(nextIndex(vec, '=', i) - 1));
          decl.add(';');
          for n := i + 2 to nextIndex(vec, '=', i) - 2 do
          begin
            vec.rem(i+2);
          end;
          ovec.add('{');
          pv.add(getParameter(decl));
          ovec.add(convert(decl, 0, pv.copy));
          ovec.add('for');
          ovec.add('(');
          ovec.add(convert(getInner(vec, i), 0, pv));
          ovec.add(')');
          i := skip(vec, i+1, '(', ')');
          wd := vec.getStr(i);
          if (wd = '{') then
          begin
            ovec.add('{');
            ovec.add(convert(getBlock(vec, i), 0, pv.copy));
            ovec.add('}');
            i := skip(vec, i, '{', '}');
            ovec.add('}');
          end
          else
          begin
            n := i;
            buf := TStringVector.Create;
            while (n < vec.size) and (vec.getStr(n) <> ';') do
            begin
              buf.add(vec.getStr(n));
              n := n + 1;
            end;
            ovec.add(convert(buf, 0, pv));
            ovec.add(vec.getStr(n));
            ovec.add('}');
            i := n + 1;
          end;
          continue;
        end
        else
        begin
          ovec.add(wd);
          i := i + 1;
          continue;
        end;
      end;
    end;
   if optimize then
   begin
    if (wd = 'System') then
    begin
      if (i + 4 < vec.size) and (vec.getStr(i + 2) = 'print') and (vec.getStr(i + 3) = '(') and (vecT.getType(8).est(vec.getStr(i + 4))) then
      begin
        ovec.add('printf');
        ovec.add('(');
        ovec.add(vec.getStr(i + 4));
        ovec.add(')');
        i := skipTo(vec, ';', i);
        continue;
      end
      else if (i + 4 < vec.size) and (vec.getStr(i + 2) = 'println') and (vec.getStr(i + 3) = '(') and (vecT.getType(8).est(vec.getStr(i + 4))) then
      begin
        str := '';
        z := 1;
        while (z < length(vec.getStr(i + 4))) do
        begin
          str := str + vec.getStr(i + 4)[z];
          z := z + 1;
        end;
        ovec.add('printf');
        ovec.add('(');
        ovec.add(str + '\n"');
        ovec.add(')');
        i := skipTo(vec, ';', i);
        continue;
      end;
    end;
   end;

      if (wd = 'System') and ((i + 2 < vec.size) and (vec.getStr(i + 2) = 'exit')) then
      begin
        if (cMeth.locals.size > 0) then
        begin
          ovec.add('ADT_GarbageCollector_clearObjects');
          ovec.add('(');
          ovec.add('& _local_GarbageCollector_instance_reserved_keyword');
          ovec.add(')');
          ovec.add(';');
        end;
      end;

      if isInstance(wd, pv, cClass) and ((i - 1 < 0) or not est(vec.getStr(i - 1), vecUni)) then
      begin
        str := getStaticMemberClass(wd, cClass);
        if (str <> '') then
        begin
          wd := str;
          vec.add('.', i);
          vec.add(wd, i);

        end
        else if (((cMeth <> nil) and not cMeth.stat) or ((cAttr <> nil) and not cAttr.stat)) then
        begin
          wd := 'this';
	        vec.add('.', i);
	        vec.add('this', i);
        end;
      end;

      if (i + 1 < vec.size) and (isObject(wd, pv, cClass) or isClass(wd)) and (est(vec.getStr(nextMemberAbs(vec,i)), vecUni)) then
      begin
        if isClass(wd) then
        begin
          cl := vecCl.return(wd);
        end
        else
        begin
          cl := getClassOf(wd, pv, cClass);
        end;
        o := i;
        buf := TStringVector.Create;
        n := nextExpr(vec, i);
        i := nextMember(vec, i);
        
        while (i < vec.size) and (i < n) and (isObject(wd, pv, cl) or isClass(wd)) do
        begin
          if isClass(wd) then
          begin
            cl := vecCl.return(wd);
          end
          else if (wd = 'super') then
          begin
            cl := cClass.sup;
          end
          else
          begin
            cl := getClassOf(wd, pv, cl);
          end;
          buf.add(wd);
          if (i + 1 < vec.size) and (vec.getStr(i + 1) = '(') then
          begin
            if vecCl.contains(wd) then
            begin
              ovec.add(cl.name + '_' + vec.getStr(i) + getTypesVec(getInner(vec, i, '(', ')'), pv, cl.getMVec(vec.getStr(i))).getMorph);
              ovec.add('(');

            end
            else if cl.inter then
            begin
              if (buf.size > 1) then
              begin
                tempBuf := convert(returnRange(vec, o, i - 2), 0, pv);
                for z := 0 to tempBuf.size - 1 do
                begin
                  ovec.rem(ovec.size - 1)
                end;
              end;
              ovec.add(cl.name + '_' + vec.getStr(i) + getTypesVec(getInner(vec, i, '(', ')'), pv, cl.getMVec(vec.getStr(i))).getMorph);
              ovec.add('(');

              if (buf.size = 1) and (buf.getStr(0) = 'super') then
              begin
                ovec.add('this');
              end
              else
              begin
                ovec.add(convert(returnRange(vec, o, i - 2), 0, pv));
              end;
              if (getTypesVec(getInner(vec, i, '(', ')'), pv, cl.getMVec(vec.getStr(i))).size > 0) then
              begin
                ovec.add(',');
              end;
            end
            else
            begin
              if (buf.size = 1) then
              begin
                if (wd = 'super') then
                begin
                  ovec.add(cClass.sup.name);  //was cl.sup.name
                end
                else
                begin
                  ovec.add(convert(returnRange(vec, prevMember(vec, i), i - 2), 0, pv));
                end;
              end;
              ovec.add('->');
              ovec.add(vec.getStr(i) + getTypesVec(getInner(vec, i, '(', ')'), pv, cl.getMVec(vec.getStr(i))).getMorph);
              ovec.add('(');

              if (buf.size = 1) and (buf.getStr(0) = 'super') then
              begin
                ovec.add('this');
              end
              else
              begin
                ovec.add(convert(returnRange(vec, o, i - 2), 0, pv));
              end;
              if (getTypesVec(getInner(vec, i, '(', ')'), pv, cl.getMVec(vec.getStr(i))).size > 0) then
              begin
                ovec.add(',');
              end;
            end;
            ovec.add(convert(getInner(vec, i, '(', ')'), 0, pv));
            ovec.add(')');

            z := skip(vec, i, '(', ')');
            while (z + 1 < vec.size) and (vec.getStr(z + 1) = '[') do
            begin
              ovec.add('[');
              ovec.add(convert(getInner(vec, z, '[', ']'), 0, pv));
              ovec.add(']');
              z := skip(vec, z, '[', ']') + 1;
            end;

          end
          else
          begin
            if vecCl.contains(wd) then
            begin
              ovec.add(cl.name + '_' + vec.getStr(i));
              z := i;
              while (z + 1 < vec.size) and (vec.getStr(z + 1) = '[') do
              begin
                ovec.add('[');
                ovec.add(convert(getInner(vec, z, '[', ']'), 0, pv));
                ovec.add(']');
                z := skip(vec, z, '[', ']');
              end;
            end
            else
            begin
              if (buf.size = 1) then
              begin
                if (wd = 'super') then
                begin
                  ovec.add(cClass.sup.name);
                end
                else
                begin
                  ovec.add(convert(returnRange(vec, prevMember(vec, i), i - 2), 0, pv));
                  //ovec.add(wd);
                end;
              end;
              ovec.add('->');
              ovec.add(vec.getStr(i));

              z := i;
              while (z + 1 < vec.size) and (vec.getStr(z + 1) = '[') do
              begin
                ovec.add('[');
                ovec.add(convert(getInner(vec, z, '[', ']'), 0, pv));
                ovec.add(']');
                z := skip(vec, z, '[', ']');
              end;

            end;
          end;
          for z := i + 1 to nextMember(vec, i) - 1 do
          begin
            if (z < vec.size) then
            begin
              buf.add(vec.getStr(z));
            end;
          end;
          wd := vec.getStr(i);


          if (i + 1 < vec.size) and (vec.getStr(i + 1) = '[') then
          begin
            while (i + 1 < vec.size) and (vec.getStr(i + 1) = '[') do
            begin
              i := skip(vec, i, '[', ']');
            end;
          end
          else
          begin
          i := nextMember(vec, i);
          end;

          if (i < vec.size) and est(vec.getStr(i), vecUni) then
          begin
            i := i + 1;
          end;
        end;
        continue;
      end;
    if (i + 1 < vec.size) and not (est(wd, vecKey)) and (vec.getStr(i + 1) = '(') then
    begin

      if ((i - 1 < 0) or not est(vec.getStr(i - 1), vecUni)) then
      begin
        ovec.add(wd);
        ovec.add('(');
        if (i + 2 < vec.size) and (vec.getStr(i + 2) <> ')') then
        begin
          ovec.add(convert(getInner(vec, i, '(', ')'), 0, pv));
        end;
      end
      else
      begin
        buf := returnObject(vec, i - 2);

        ovec.add(wd + getTypesVec(getInner(vec, i, '(', ')'), pv, TMethodVector.Create).getMorph);
        ovec.add('(');
        ovec.add(convert(buf, 0, pv));
        if (i + 2 < vec.size) and (vec.getStr(i + 2) <> ')') then
        begin
          ovec.add(',');
          ovec.add(convert(getInner(vec, i, '(', ')'), 0, pv));
        end;
      end;


      ovec.add(')');

      i := skip(vec, i, '(', ')');
      continue;
    end;

    (*
    if (i + 1 < vec.size) and vecT.getType(8).est(wd) and ((vec.getStr(i + 1) = 'c') or (vec.getStr(i + 1) = 'C')) then
    begin
      ovec.add(wd);
      i := i + 1;
      continue;
    end;
    *)

    if (returnExpr(vec, i).size > 0) and (returnExprType(returnExpr(vec, i).toString, pv).rType = 'String') and (nextExpr(vec, nextExpr(vec, i)) < vec.size) and ((vec.getStr(nextExpr(vec, i)) = '+') or (vec.getStr(nextExpr(vec, i)) = '+=')) then
    begin
      buf := TStringVector.Create;
      buf.add(returnExpr(vec, i));
      buf.add('.');
      buf.add('append');
      buf.add('(');
      buf.add(returnExpr(vec, nextExpr(vec, nextExpr(vec, i))));
      buf.add(')');
      ovec.add(convert(buf, 0, pv));
      i := nextExpr(vec, nextExpr(vec, nextExpr(vec, i)));
      continue;
    end;

    ovec.add(convertValue(wd));
    i := i + 1;
  end;
  convert := ovec;
end;

end.

