(*
 * QUSOFT MICROSYSTMES
 * Moka
 * Copyright 2003 Frdric Brown
 *)

(*
 *  This file is part of Moka.
 *
 *  Moka is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.

 *  Moka is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with Moka; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *)

(*
 * Coder unit is used to write the C source files of the TIGCC project once the
 * conversion and optimization is done.
 *)

unit Coder;

interface

Uses Reflect;

procedure code;
procedure writeStruct(pk: TPack; cl: TClasse; ac: TClasse);
procedure writeAssignments(cl: TClasse; ac: TClasse);
procedure finalizeProject;
procedure copyHeaders;
function countUsedClasses: Longint;
function countUsedSerializable: Longint;
//function systemEntriesUsed: Boolean;
//function systemCalculatorUsed: Boolean;
//function GEMLCDUsed: Boolean;

implementation

Uses SysUtils, Globals, Util, Funcs;

procedure writeAssignments(cl: TClasse; ac: TClasse);
var
  i: Longint;
  m: TMethode;
begin
  if (ac.sup <> nil) then
  begin
    writeAssignments(cl, ac.sup);
  end;

  cl.writeLine(#9 + '//Methods from class ' + ac.name);

  for i := 0 to ac.meth.size - 1 do
  begin
    m := ac.meth.getMeth(i);

    if m.stat or (m.rType = '') or m.abst then //modif 2003/11/02
    begin
      continue;
    end;

    if not overloaded(m, ac, cl) then
    begin
      cl.writeLine(#9 + 'this -> ' + m.name + m.getMorph +  ' = ( void * ) T' + ac.name + '_' + m.name + m.getMorph +  ' ; ');
    end;
  end;
end;

procedure writeStruct(pk: TPack; cl: TClasse; ac: TClasse);
var
  i: Longint;
  a: TAttribute;
  m: TMethode;
  ccl: TClasse;
  cat: TAttribute;
begin
  if (ac.sup <> nil) then
  begin
    writeStruct(pk, cl, ac.sup);
  end;

  pk.writeLine(#9 + '//Fields from class ' + ac.name);
  featF.writeLine('#define MOKACLASS_' + cl.name + '_EXTENDSCLASS_' + ac.name + ' 1 ');
  if (cl = maincl) then
  begin
    featF.writeLine('#define MOKACLASS_MAINCLASS_EXTENDSCLASS_' + ac.name + ' 1 ');
  end;

  for i := 0 to ac.attr.size - 1 do
  begin
    a := ac.attr.getAttr(i);

    ccl := ac.sup;

    while (ccl <> nil) do
    begin
      cat := ccl.attr.return(a.name);
      if cat <> nil then
      begin
        pushError(2, 'Error : Attribute ' + a.name + ' defined in class ' + ac.name + ' (' + ac.fileName + ') already exists in its superclass : class ' + ccl.name + ' (' + ccl.fileName + ').');
      end;
      ccl := ccl.sup;
    end;

    if a.stat then
    begin
      continue;
    end;

    pk.writeLine(a.comment);

    if a.vol then
    begin
      pk.writeString(#9 + 'volatile ');
    end
    else
    begin
      pk.writeString(#9);
    end;

    if vecCl.contains(a.rType) then
    begin
      pk.writeString('struct ' + a.rType + ' * ');
    end
    else
    begin
      pk.writeString(convertType(a.rType) + ' ');
    end;

    pk.writeLine(a.rPtr + a.name + ' ; ');
  end;

  pk.writeLine(#9 + '//Methods from class ' + ac.name);

  for i := 0 to ac.meth.size - 1 do
  begin
    m := ac.meth.getMeth(i);

    if m.stat or (m.rType = '') then
    begin
      continue;
    end;

    if not overloads(m, ac.sup) then
    begin
      if vecCl.contains(m.rType) then
      begin
        pk.writeString(#9 + 'struct ' + m.rType + ' * ');
      end
      else
      begin
        pk.writeString(#9 + convertType(m.rType) + ' ');
      end;

      pk.writeLine(m.rPtr + '( * ' + m.name + m.getMorph + ' ) ( ' + m.listArgs(false, cl) + ') ; ');

    end;
  end;
end;

procedure code;
var
  i: Longint;
  n: Longint;
  cl: TClasse;
  pk: TPack;
  z: Longint;
  //w: Longint;
  an: Longint;
  a: TAttribute;
  m: TMethode;
  packF: TFileLinked;
  cpt: Longint;
  //num: Longint;
begin
  os.println('');

  if not SysUtils.DirectoryExists(dirOut) and not CreateDir(dirOut) then
  begin
    pushError(0, 'Error : Unable to create output directory (' + dirOut + ').');
  end;

  os.println('Designing packages.h file');

  packF := TFileLinked.Create;

  packF.writeLine('/*' + newLine + ' * This file contains the declaration of all the classes used in the project and includes all the packages, classes and interfaces of the project.' + newLine + ' */');

  copyHeaders();

  mainMeth := mainCl.getMVec('main').getMeth(0);

  if (mainMeth = nil) then
  begin
    pushError(0, 'No ''main'' method found in the main class.');
  end;

  if not mainCl.ifs.contains('No_Instanciation') then
  begin

  for i := 0 to vecPk.size - 1 do
  begin
    packF.writeLine('/*' + newLine + ' * Declaration of the classes of the package ' + vecPk.getPack(i).name + newLine + ' */');
    for n := 0 to vecPk.getPack(i).classes.size - 1 do
    begin
      cl := vecPk.getPack(i).classes.getClass(n);
      if not cl.inter and cl.used then
      begin
        packF.writeLine('//Declaration of class ' + cl.name);
        packF.writeLine('struct ' + cl.name + ' ; ');
      end;
    end;
  end;

  packF.writeLine('/*' + newLine + ' * Declaration of built in functions' + newLine + ' */');
  packF.writeLine(readFileAsString(configDir + pathSeparator + 'define.funcs'));

  (*if mainCl.ifs.contains('Use_GarbageCollection') then
  begin
    packF.writeLine('/*' + newLine + ' * Declaration of garbage collector''s functions' + newLine + ' */');
    packF.writeLine('void GarbageCollector_add_Object ( void * ) ; ');
    packF.writeLine('void GarbageCollector_rem_Object ( void * ) ; ');
    packF.writeLine('void GarbageCollector_rem_long_int ( long int ) ; ');
    if (vecCl.return('System') <> nil) and ((vecCl.return('System').return('malloc_long_int') <> nil) or (vecCl.return('System').return('free_void_p') <> nil)) then
    begin
      packF.writeLine('void GarbageCollector_addPtr_void_p ( void * ) ; ');
      packF.writeLine('void GarbageCollector_remPtr_void_p ( void * ) ; ');
      packF.writeLine('void GarbageCollector_remPtr_long_int ( long int ) ; ');
    end;
  end;*)

  end
  else
  begin
      mainStr := mainMeth.outp.toText;
      for i := 0 to mainCl.meth.size - 1 do
      begin
        if (mainCl.meth.getMeth(i).name = 'main') then
        begin
          mainCl.meth.rem(i);
          break;
        end;
      end;
  end; //NO_Instanciation

  packF.writeLine('/*' + newLine + ' * Inclusion of all the packages' + newLine + ' */');

  cpt := 0;

  for i := 0 to vecPk.size - 1 do
  begin
    pk := vecPk.getPack(i);
    os.println('Designing ' + pk.name + '.h package file');
    packF.writeLine('//Inclusion of package ' + pk.name);
    packF.writeLine('#include "' + pk.name + '.h"');
    os.println('Package : ' + pk.name);

    featF.writeLine('#define MOKAPACKAGE_' + replace(pk.name, '.', '_') + ' 1 ');

    pk.writeLine('//Package ' + pk.name);
    pk.writeLine('/*' + newLine + ' * This file contains the structure of all the classes of the package, the declaration of all the method of these classes and all their static attributes.' + newLine + ' */');

    for n := 0 to pk.classes.size - 1 do
    begin
      //numDLL := 0;
      cl := pk.classes.getClass(n);

      for z := 0 to cl.ifs.size - 1 do
      begin
        featF.writeLine('#define MOKACLASS_' + cl.name + '_IMPLEMENTSINTERFACE_' + cl.ifs.getClass(z).name + ' 1 ');
        if (cl = maincl) then
        begin
          featF.writeLine('#define MOKACLASS_MAINCLASS_IMPLEMENTSINTERFACE_' + cl.ifs.getClass(z).name + ' 1 ');
        end;
      end;

      os.println('Designing ' + cl.name + '.h class file');

      if not cl.inter then
      begin
        os.println(#9 + 'Class : ' + cl.name);
        featF.writeLine('#define MOKACLASS_' + cl.name + ' 1 ');

        if not mainCl.ifs.contains('No_Instanciation') then
        begin

        if (cl = maincl) then
        begin
          featF.writeLine('#define MOKACLASS_MAINCLASS ' + cl.name);
        end;
        pk.writeLine('//Structure of class ' + cl.name);
        pk.writeLine('typedef struct ' + cl.name + ' { ');
        pk.writeLine(#9 + 'char * class ; ');
        pk.writeLine(#9 + 'short int class_id ; ');//Serial # support
        //pk.writeLine(#9 + 'short int size_of ; ');
        pk.writeLine(#9 + 'struct Object * super ; ');
        writeStruct(pk, cl, cl);
        pk.writeLine('} T' + cl.name + ' ; ');
        if not (cl.abst and cl.fin) then
        begin
          pk.writeLine('struct ' + cl.name + ' * T' + cl.name + '0 ( ) ; ' );
          //pk.writeLine('void T' + cl.name + '0 ( ) ; ' );
          pk.writeLine('struct ' + cl.name + ' * ' + cl.name + ' ; //Generic ' + cl.name + ' object prototype');
        end;

        end; //No_Instanciation
      end
      else
      begin
        featF.writeLine('#define MOKAINTERFACE_' + cl.name + ' 1 ');
        pk.writeLine('//Interface ' + cl.name);
        os.println(#9 + 'Interface : ' + cl.name);
      end;

      {if cl.hasValuedStat then
      begin
        cl.writeLine('void ' + cl.name + '_init ( ) ; ');
      end;}

      if cl.inter then
      begin
        cl.outText := '//Defining interface ' + cl.name + newLine + '/*' + newLine + ' * This file contains the definition of all the methods of the interface and the definition of the built in functions related to the interface.' + newLine + ' */' + newLine + cl.outText;
      end
      else
      begin
        cl.outText := '//Defining class ' + cl.name + newLine + '/*' + newLine + ' * This file contains the definition of all the methods of the class and the definition of the built in functions related to the class.' + newLine + ' */' + newLine + cl.outText;

        if not mainCl.ifs.contains('No_Instanciation') then
        begin

        if not (cl.abst and cl.fin) then
        begin
          cl.writeLine('T' + cl.name + ' * T' + cl.name + '0 ( ) {');
          //cl.writeLine('void T' + cl.name + '0 ( struct ' + cl.name + ' * this ) {');
          cl.writeLine(#9 + 'T' + cl.name + ' * this = malloc ( sizeof ( T' + cl.name + ' ) ) ; ');

          if mainCl.ifs.contains('Use_GarbageCollection') then
          begin
            cl.writeLine(#9 + 'GarbageCollector_add_Object ( this ) ; ');
          end;

          cl.writeLine(#9 + 'this -> class = ( char * ) "' + cl.name + '" ; ');
          cl.writeLine(#9 + 'this -> class_id = ' + inttostr(cpt) + ' ; ');//Serial # support
          cpt := cpt + 1;
          cl.writeString(#9 + 'this -> super = ( void * ) ');
          if cl.sup <> nil then
          begin
            cl.writeLine(cl.sup.name + ' ; ');
          end
          else
          begin
            cl.writeLine('NULL ; ');
          end;
          //cl.writeLine(#9 + 'this ->size_of = sizeof ( T' + cl.name + ' ) ; ');
          writeAssignments(cl, cl);
          cl.writeLine(#9 + 'return this ; ');
          cl.writeLine('} ');
        end;

        end; //No_Instanciation
      end;

      for z := 0 to cl.attr.size - 1 do
      begin
        a := cl.attr.getAttr(z);
        if a.fin then
        begin
          os.print(#9 + #9 + 'Constant : ');
        end
        else
        begin
          os.print(#9 + #9 + 'Attribute : ');
        end;
        if a.stat then
        begin
          featF.writeLine('#define MOKASTATICATTRIBUTE_' + cl.name + '_' + a.name + ' 1 ');
          if (cl = maincl) then
          begin
            featF.writeLine('#define MOKASTATICATTRIBUTE_MAINCLASS_' + a.name + ' 1 ');
          end;
          os.print('static ');
          pk.writeLine(a.comment);
          if a.fin then
          begin
            pk.writeLine('#define ' + cl.name + '_' + a.name + ' ' + a.text);
          end
          else
          begin

            if cl.ext('DLL_Interface') then
            begin
              pk.writeString('#define ' + cl.name + '_' + a.name);

              if (a.rPtr <> '') or vecCl.contains(a.rType) then
              begin
                pk.writeString(' _DLL_reference(const ');
              end
              else
              begin
                pk.writeString(' _DLL_glbvar(');
              end;

              if vecCl.contains(a.rType) then
              begin
                pk.writeString('struct ' + a.rType);
              end
              else
              begin
                pk.writeString(convertType(a.rType));
              end;

              pk.writeLine(',' + inttostr(a.order) + ')');

              //numDLL := numDLL + 1;
             continue;
            end;

            if a.vol then
            begin
              os.print('volatile ');
              pk.writeString('volatile ');
            end;
            if vecCl.contains(a.rType) then
            begin
              pk.writeLine('struct ' + a.rType + ' * ' + a.rPtr + ' ' + cl.name + '_' + a.name + ' ; ');
            end
            else
            begin
              pk.writeLine(convertType(a.rType) + a.rPtr + ' ' + cl.name + '_' + a.name + ' ; ');
            end;
          end;
        end
        else
        begin
          featF.writeLine('#define MOKAATTRIBUTE_' + cl.name + '_' + a.name + ' 1 ');
          if (cl = maincl) then
          begin
            featF.writeLine('#define MOKAATTRIBUTE_MAINCLASS_' + a.name + ' 1 ');
          end;
        end;
        os.println(a.name);
      end;

      for z := 0 to cl.meth.size - 1 do
      begin
        m := cl.meth.getMeth(z);
        if (m.rType <> '') then
        begin
          os.println(#9 + #9 + 'Method : ' + m.name);
        end
        else
        begin
          featF.writeLine('#define MOKACONSTRUCTOR_' + cl.name + m.getMorph + ' 1 ');
          if (cl = maincl) then
          begin
            featF.writeLine('#define MOKACONSTRUCTOR_MAINCLASS' + m.getMorph + ' 1 ');
          end;
          os.println(#9 + #9 + 'Constructor');
        end;

        cl.writeLine(m.comment);

        if m.stat then
        begin
          featF.writeLine('#define MOKASTATICMETHOD_' + cl.name + '_' + m.name + m.getMorph + ' 1 ');
          if (cl = maincl) then
          begin
            featF.writeLine('#define MOKASTATICMETHOD_MAINCLASS_' + m.name + m.getMorph + ' 1 ');
          end;

          if (cl.ext('DLL_Interface')) then
          begin


            pk.writeString('#define ' + cl.name + '_' + m.name + m.getMorph + ' _DLL_call_attr(');

            if vecCl.contains(m.rType) then
            begin
              if vecCl.return(m.rType).inter then
              begin
                pk.writeString('struct Object * ');
              end
              else
              begin
                pk.writeString('struct ' + m.rType + ' * ');
              end;
            end
            else
            begin
              pk.writeString(convertType(m.rType));
            end;

            pk.writeString(',(');

            if (m.params.size = 0) then
            begin
               pk.writeString('void');
            end
            else
            begin
              pk.writeString(m.listArgs(false, cl));
            end;

            pk.writeLine('),__attribute__((stkparm)),' + inttostr(m.order) + ')');

           // numDLL := numDLL + 1;

            continue;
          end;

          if (m.abst) then
          begin
            continue;
          end;

          if vecCl.contains(m.rType) then
          begin
            if vecCl.return(m.rType).inter then
            begin
              pk.writeString('struct Object * ');
            end
            else
            begin
              pk.writeString('struct ' + m.rType + ' * ');
            end;
          end
          else
          begin
            pk.writeString(convertType(m.rType) + ' ');
          end;
          pk.writeString(m.rPtr);
          pk.writeLine(cl.name + '_' + m.name + m.getMorph() + ' ( ' + m.listArgs(false, cl) + ') ; ');

          cl.writeLine(convertType(m.rType) + m.rPtr + ' ' + cl.name + '_' + m.name + m.getMorph + ' ( ' + m.listArgs(true, cl) + ') { ');
          cl.writeLine(m.text);
          cl.writeLine('} ');
        end
        else if not cl.inter and (m.rType <> '') then
        begin
          featF.writeLine('#define MOKAMETHOD_' + cl.name + '_' + m.name + m.getMorph + ' 1 ');
          if (cl = maincl) then
          begin
            featF.writeLine('#define MOKAMETHOD_MAINCLASS_' + m.name + m.getMorph + ' 1 ');
          end;
          if (m.abst) then
          begin
            continue;
          end;
          if vecCl.contains(m.rType) then
          begin
            if vecCl.return(m.rType).inter then
            begin
              pk.writeString('struct Object * ');
            end
            else
            begin
              pk.writeString('struct ' + m.rType + ' * ');
            end;
          end
          else
          begin
            pk.writeString(convertType(m.rType) + ' ');
          end;
          pk.writeString(m.rPtr);
          pk.writeLine('T' + cl.name + '_' + m.name + m.getMorph() + ' ( ' + m.listArgs(false, cl) + ') ; ');

          cl.writeLine(convertType(m.rType) + m.rPtr + ' T' + cl.name + '_' + m.name + m.getMorph + ' ( ' + m.listArgs(true, cl) + ') { ');
          cl.writeLine(m.text);
          cl.writeLine('} ');
        end
        else if (m.rType = '') and not cl.inter then
        begin
          pk.writeLine('struct ' + m.name + ' * T' + m.name + m.getMorph + ' ( ' + m.listArgsConst(true, false) + ') ; ');
          //pk.writeLine('struct ' + m.name + ' * Constructor_T' + m.name + m.getMorph + ' ( ' + m.listArgs(false, cl) + ') ; ');
          pk.writeLine('void ' + m.name + '_' + m.getMorph + ' ( ' + m.listArgs(false, cl) + ') ; ');

          (*if (m.params.size > 0) then
          begin
            pk.writeLine('#define ' + 'T' + m.name + m.getMorph + '( _args... ) ' + ' Constructor_T' + m.name + m.getMorph + '( malloc ( sizeof ( T' + m.name + ' ) ) , _args )');
          end
          else
          begin
            pk.writeLine('#define ' + 'T' + m.name + m.getMorph + '(  ) ' + ' Constructor_T' + m.name + m.getMorph + '( malloc ( sizeof ( T' + m.name + ' ) ) )');
          end;  *)

          cl.writeLine('T' + cl.name + ' * T' + m.name + m.getMorph + ' ( ' + m.listArgsConst(true, true) + ') {');
          //cl.writeLine('T' + cl.name + ' * Constructor_T' + m.name + m.getMorph + ' ( ' + m.listArgs(true, cl) + ') {');

          cl.writeLine(#9 + 'T' + cl.name + ' * this = T' + cl.name + '0 ( ) ; ');
          //cl.writeLine(#9 + 'T' + cl.name + ' * this = malloc( sizeof ( T' + cl.name + ' ) ) ;');
          //cl.writeLine(#9 + 'T' + cl.name + '0 ( this ) ; ');

          for an := 0 to cl.attr.size - 1 do
          begin
            if not cl.attr.getAttr(an).stat and (cl.attr.getAttr(an).outp.size > 0) then
            begin
              cl.writeLine(#9 + 'this -> ' + cl.attr.getAttr(an).name + ' = ' + cl.attr.getAttr(an).text + ' ; ');
            end;
          end;

          cl.writeString(#9 + cl.name + '_' + m.getMorph + ' ( this ');
          if (m.params.size > 0) then
          begin
            cl.writeLine(', ' + m.listArgsConst(false, true) + ') ; ');
          end
          else
          begin
            cl.writeLine(') ; ');
          end;
          cl.writeLine(#9 + 'return this ; ');
          cl.writeLine('} ');

          cl.writeLine('void ' + m.name + '_' + m.getMorph + ' ( ' + m.listArgs(true, cl) + ') { ');
          cl.writeLine(m.text);
          cl.writeLine('} ');
        end
        else //Interface binding support
        begin
          featF.writeLine('#define MOKAMETHOD_' + cl.name + '_' + m.name + m.getMorph + ' 1 ');
          if (cl = maincl) then
          begin
            featF.writeLine('#define MOKAMETHOD_MAIN_' + m.name + m.getMorph + ' 1 ');
          end;

          if vecCl.contains(m.rType) then
          begin
            if vecCl.return(m.rType).inter then
            begin
              pk.writeString('struct Object * ');
            end
            else
            begin
              pk.writeString('struct ' + m.rType + ' * ');
            end;
          end
          else
          begin
            pk.writeString(convertType(m.rType) + ' ');
          end;
          pk.writeString(m.rPtr);

          messF.writeLine(convertType(m.rType) + ' ( * * ' + cl.name + '_' + m.name + m.getMorph + '_ProtArray ) ( ' + m.listArgs(false, cl) + ' ) ;');

          if (fmi) then
          begin
            pk.writeLine('__inline__ ' + cl.name + '_' + m.name + m.getMorph() + ' ( ' + m.listArgs(false, cl) + ') ; ');
            messF.writeLine('__inline__ static ' + convertType(m.rType) + m.rPtr + ' ' + cl.name + '_' + m.name + m.getMorph + ' ( ' + m.listArgs(true, cl) + ') { ');
          end
          else
          begin
            pk.writeLine(cl.name + '_' + m.name + m.getMorph() + ' ( ' + m.listArgs(false, cl) + ') ; ');
            messF.writeLine(convertType(m.rType) + m.rPtr + ' ' + cl.name + '_' + m.name + m.getMorph + ' ( ' + m.listArgs(true, cl) + ') { ');
          end;

          (*cl.writeLine(#9 + 'short int i = -1 ; ');
          cl.writeLine(#9 + convertType(m.rType) + ' ( * meth ) ( ' + m.listArgs(false, cl) + ' ) ; ');
          cl.writeLine(#9 + 'TObject * obj ; ');
          cl.writeLine(#9 + 'while ( ( obj = ProtArray [ ' + '++i' + ' ] ) -> class_id != this -> class_id) ; ');
          cl.writeLine(#9 + 'meth = ( void * ) ' + cl.name + '_' + m.name + m.getMorph() + '_ProtArray [ i ] ; ');
          *)
          if m.rType <> 'void' then
          begin
            messF.writeString(#9 + 'return ');
          end
          else
          begin
            messF.writeString(#9);
          end;
          messF.writeString(cl.name + '_' + m.name + m.getMorph() + '_ProtArray [ this -> class_id ] ( this ');
          if (m.params.size > 0) then
          begin
            messF.writeLine(', ' + m.listArgsConst(false, true) + ') ; ');
          end
          else
          begin
            messF.writeLine(') ; ');
          end;
          messF.writeLine('} ');
        end;
      end;
    end;

    (*for w := 0 to pk.classes.size - 1 do
    begin
      cl := pk.classes.getClass(w);
      if cl.inter then
      begin
        for n := 0 to cl.meth.size - 1 do
        begin
          m := cl.meth.getMeth(n);
          if not m.stat then
          begin
            //num := 0;
            for z := 0 to vecCl.size - 1 do
            begin
              if (vecCl.getClass(z).used) and not vecCl.getClass(z).inter and not (vecCl.getClass(z).abst and vecCl.getClass(z).fin) then
              begin
                if (vecCl.getClass(z).returnAll(m.name + m.getMorph) <> nil) and vecCl.getClass(z).implAll(cl.name) then
                begin
                  //pk.writeLine(cl.name + '_' + m.name + m.getMorph + '_ProtArray [ ' + inttostr(num) + ' ] = ' + vecCl.getClass(z).name + ' -> ' + m.name + m.getMorph + ' ; ');
                  //pk.writeLine(convertType(m.rType) + ' ( * * ' + cl.name + '_' + m.name + m.getMorph + '_ProtArray ) ( ' + m.listArgs(false, cl) + ' ) ;');
                  messF.writeLine(convertType(m.rType) + ' ( * * ' + cl.name + '_' + m.name + m.getMorph + '_ProtArray ) ( ' + m.listArgs(false, cl) + ' ) ;');
                end;
                //num := num + 1;
              end;
            end;
          end;
        end;
       end;
      end;*)
  end;

  packF.writeLine('/* Used by dynamic binding support. */');
  packF.writeLine('#include "messages.h"');

  (*for i := 0 to globalObjects.size - 1 do
  begin
    globF.writeLine('T' + globalObjects.getStr(i) + ' _Global_Object_Number_' + intToStr(i) + '_reserved_keyword ; ');
  end;*)

  packF.writeLine('/*' + newLine + ' * Inclusion of all the headers.' + newLine + ' */');

  for i := 0 to vecPk.size - 1 do
  begin
    pk := vecPk.getPack(i);
    for n := 0 to pk.classes.size - 1 do
    begin
      cl := pk.classes.getClass(n);
      for z := 0 to cl.inclu.size - 1 do
      begin
        if strEndsWith(cl.inclu.getStr(z), '.h') then
        begin
          packF.writeLine('#include "' + cl.name + '.h"');
        end;
      end;
    end;
  end;

  packF.writeLine('/*' + newLine + ' * Inclusion of all the classes and interfaces' + newLine + ' */');

  for i := 0 to vecPk.size - 1 do
  begin
    pk := vecPk.getPack(i);
    os.println('Writing ' + pk.name + '.h');
    writeStringToFile(pk.outText, dirOut + pathSeparator + pk.name + '.h');
  end;

//was interupt


  for i := 0 to vecPk.size - 1 do
  begin
    pk := vecPk.getPack(i);
    packF.writeLine('/* Package ' + pk.name + ' */');
    for n := 0 to pk.classes.size - 1 do
    begin
      cl := pk.classes.getClass(n);
      if cl.inter then
      begin
        packF.writeLine('//Inclusion of interface ' + cl.name);
      end
      else
      begin
        packF.writeLine('//Inclusion of class ' + cl.name);
      end;
      packF.writeLine('#include "T' + cl.name + '.h"');
      os.println('Writing T' + cl.name + '.h');
      writeStringToFile(cl.outText, dirOut + pathSeparator + 'T' + cl.name + '.h');
    end;
  end;

  os.println('Writing packages.h');
  writeStringToFile(packF.outText, dirOut + pathSeparator + 'packages.h');

  finalizeProject;
end;
(* 2004/03/07
function systemEntriesUsed: Boolean;
var
  cl: TClasse;
begin
  cl := vecCl.return('System');
  if (cl.attr.return('ENTRIES') <> nil) then
  begin
    systemEntriesUsed := true;
    exit;
  end;
  if (cl.attr.return('AMS') <> nil) then
  begin
    systemEntriesUsed := true;
    exit;
  end;

  systemEntriesUsed := false;
end;

function systemCalculatorUsed: Boolean;
var
  cl: TClasse;
begin
  cl := vecCl.return('System');
  if (cl.attr.return('CALCULATOR') <> nil) then
  begin
    systemCalculatorUsed := true;
    exit;
  end;
  if (cl.attr.return('ROM_BASE') <> nil) then
  begin
    systemCalculatorUsed := true;
    exit;
  end;

  if GEMLCDUsed then
  begin
    systemCalculatorUsed := true;
    exit;
  end;

  systemCalculatorUsed := false;
end;

function GEMLCDUsed: Boolean;
var
  cl: TClasse;
begin
  if (isClass('GEM')) then
  begin
    cl := vecCl.return('GEM');
    if (cl.attr.return('LCD_HEIGHT') <> nil) then
    begin
      GEMLCDUsed := true;
      exit;
    end;
    if (cl.attr.return('LCD_LINE_BYTES') <> nil) then
    begin
      GEMLCDUsed := true;
      exit;
    end;
    if (cl.attr.return('LCD_WIDTH') <> nil) then
    begin
      GEMLCDUsed := true;
      exit;
    end;
  end;

  GEMLCDUsed := false;
end;
*)
procedure finalizeProject;
var
  mainCF: TFileLinked;
  projF: TFileLinked;
//  returnValue: Boolean;
  cl: TClasse;
  m: TMethode;
  a: TAttribute;
  i: Longint;
  num: Longint;
  n: Longint;
  z: Longint;
  mMeth: TMethode;
  finalMeth: TMethode;
  cpt: Longint;
begin
  mainCF := TFileLinked.Create;
  mainCF.writeLine('/*' + newLine + ' * This file is the main file of the C project.' + newLine + ' * It includes the packages.h file, defines the appropriate constants,  ' + newLine + ' */');

  (*
  if not mainCl.ifs.contains('No_GhostSpace') then
  begin
    mainCF.writeLine('#define EXECUTE_IN_GHOST_SPACE 	// Relocate the program in the ghost space');
  end;

  if (vecCl.return('File') <> nil) and vecCl.return('File').meth.contains('showVarLinkDialog') then
  begin
    mainCF.writeLine('#define SET_FILE_IN_USE_BIT 	// With this definition, the program''s in use (a.k.a. hidden) bit is set while the program is running.');
  end
  else if not mainCl.ifs.contains('No_ROMCallsOptimization') then
  begin
    mainCF.writeLine('#define OPTIMIZE_ROM_CALLS    	// Use ROM Call Optimization');
  end;

  if mainCl.ifs.contains('Use_ErrorReturn') then
  begin
    mainCF.writeLine('#define ENABLE_ERROR_RETURN     // Enable Returning Errors to TIOS');
  end;
  *)

  mainCF.writeLine('#include "features.h"');

  featF.writeLine('#define __MOKA__ 2 //The Moka major version number ');
  featF.writeLine('#define __MOKA_VERSION__ ' + mokaVer + '//The Moka version');
  featF.writeLine('#define __MOKA_API_VERSION__ ' + apiVer + '//The Moka API version');

  mainCF.writeLine('/* Used by the Moka macro language files */');
  if isClass('GEM') then
  begin
    //mainCF.writeLine('#define MOKAMACRO_CALLMAIN xStartFunc = ' + mainCl.name + '_main_ ');
    mainCF.writeLine('#define MOKAMACRO_CALLMAIN xStartFunc = ' + mainCl.name + '_main' + mainMeth.getMorph);
  end
  else
  begin
    //mainCF.writeLine('#define MOKAMACRO_CALLMAIN ' + mainCl.name + '_main_ ( ) ');
    mainCF.writeLine('#define MOKAMACRO_CALLMAIN ' + mainCl.name + '_main' + mainMeth.getMorph);
  end;

  if (legacy) then
  begin
    mainCF.writeLine('#define __LEGACY__ 1 //Enforce backward compatibility');
  end;

  if (usesGarbageCollector) then
  begin
    mainCF.writeLine('#define MOKAUSES_GarbageCollector 1 //Project needs ADT_GarbageCollector');
  end;

//  returnValue := false;
  if (isClass('System')) then
  begin
    cl := vecCl.return('System');
    if (cl.meth.contains('exit')) then
    begin
      mainCF.writeLine('#define RETURN_VALUE //The program will return a value');
      //returnValue := true;
    end;
  end;

  mainCF.writeLine('/* Used by garbage collection process.*/');
  mainCF.writeLine(readFileAsString(configDir + pathSeparator + 'ADT_GarbageCollector.h'));

  if (globalObjects.size > 0) then
  begin
    mainCF.writeLine('ADT_GarbageCollector _global_GarbageCollector_instance_reserved_keyword ; ');
  end;

  mainCF.writeLine('/* Definition of some constants used by TIGCC.*/');
  mainCF.writeLine(readFileAsString(configDir + pathSeparator + 'define.default'));

  num := countUsedClasses();

  if not mainCl.ifs.contains('No_Instanciation') then
  begin

  (*
  if (isClass('Serializable')) then
  begin
  *)
    if (num > 0) then
    begin
      mainCF.writeLine('/* Used by the serialization and deserialization processes. */');
      //if (usedClassInherits('Serializable')) then
      if (vecCl.return('Serializable') <> nil) then
      begin
        mainCF.writeLine('void * * ProtArray; //An array of the object prototypes');
        mainCF.writeLine('#define PROT_NUM ' + intToStr(num) + '//The number of prototypes in the prototypes array');
      end;
    end;
  //end;

  end; //No_Instanciation

  (*mainCF.writeLine('/* Used by the interfacing processes. */');
  for i := 0 to vecCl.size - 1 do
  begin
    cl := vecCl.getClass(i);
    if cl.inter then
    begin
      for n := 0 to cl.meth.size - 1 do
      begin
        m := cl.meth.getMeth(n);
        if not m.stat then
        begin
          //mainCF.writeLine('void * * ' + cl.name + '_' + m.name + m.getMorph + '_ProtArray;');
          mainCF.writeLine(convertType(m.rType) + ' ( * * ' + cl.name + '_' + m.name + m.getMorph + '_ProtArray ) ( ' + m.listArgs(false, cl) + ' ) ;');
        end;
      end;
    end;
  end; *)

  (* 2004/07/03
  if mainCl.ifs.contains('Use_GarbageCollection') then
  begin
    mainCF.writeLine('/* Used for the garbage collection process. */');
    mainCF.writeLine('#define GarbageCollector_INCR 10');
    mainCF.writeLine('long int GarbageCollector_max = 10 ; ');
    mainCF.writeLine('long int GarbageCollector_size = 0 ; ');
    mainCF.writeLine('void * * GarbageCollector_array = NULL ; ');

    if (vecCl.return('System') <> nil) and ((vecCl.return('System').return('malloc_long_int') <> nil) or (vecCl.return('System').return('free_void_p') <> nil)) then
    begin
      mainCF.writeLine('#define GarbageCollector_INCRPTR 10');
      mainCF.writeLine('long int GarbageCollector_maxPtr = 10 ; ');
      mainCF.writeLine('long int GarbageCollector_sizePtr = 0 ; ');
      mainCF.writeLine('void * * GarbageCollector_arrayPtr = NULL ; ');
    end;
  end;
  *)
  
  if (isClass('GEM')) then
  begin
    mainCF.writeLine('/* These lines are required by the Graphic Environment Manager. */');
    mainCF.writeLine(readFileAsString(configDir + pathSeparator + 'define.gem'));
  end;

  mainCF.writeLine('#include "packages.h" //Include the packages.h file');

  mainCF.writeLine(readFileAsString(configDir + pathSeparator + 'define2.default'));

  mMeth := TMethode.Create('/*' + newLine + ' * The entry point of the program, will ultimatly start the Graphic Environment Manager or call the main method of the main class.' + newLine + ' */');

  mMeth.name := 'main';
  mMeth.rType := 'void';

  if (mainCl.ifs.contains('No_Instanciation')) then
  begin

    mMeth.writeLine(mainStr);
    
    mainCF.writeLine(mMeth.comment);

    mainCF.writeLine(readFileAsString(configDir + pathSeparator + 'main.default') + ' { ');

    mainCF.writeLine(mMeth.text);

    mainCF.writeLine('} ');
  end
  else
  begin

  (* 2004/03/07
  if not mainCl.ifs.contains('No_SaveScreen') then
  begin
    mMeth.writeLine(#9 + 'systemScrSaveBuffer = malloc ( LCD_SIZE ) ; ');
    mMeth.writeLine(#9 + 'LCD_save ( systemScrSaveBuffer ) ; ');
  end;

  if isClass('System') then
  begin
    cl := vecCl.return('System');
    if systemEntriesUsed then
    begin
      mMeth.writeLine(#9 + 'System_ENTRIES = TIOS_entries ; ')
    end;
    if (cl.attr.return('AMS') <> nil) then
    begin
      mMeth.writeLine(#9 + 'System_AMS = ( ( System_ENTRIES == 972 ) ? System_AMS_1 : System_AMS_2 ) ; ');
    end;
    if systemCalculatorUsed then
    begin
      mMeth.writeLine(#9 + 'System_CALCULATOR = CALCULATOR ; ');
    end;
    if (cl.attr.return('ROM_BASE') <> nil) then
    begin
      mMeth.writeLine(#9 + 'System_ROM_BASE = ( ( System_CALCULATOR != System_CALCULATOR_TI92PLUS ) ? ( void * ) 0x200000 : ( void * ) 0x400000 ) ; ');
    end;
    if (cl.attr.return('KEY_DIAMOND') <> nil) then
    begin
		  mMeth.writeLine(#9 + 'System_KEY_DIAMOND = KEY_DIAMOND ; ');
    end;
    if (cl.attr.return('KEY_DOWN') <> nil) or (cl.attr.return('KEY_DOWNRIGHT') <> nil) then
    begin
  		mMeth.writeLine(#9 + 'System_KEY_DOWN = KEY_DOWN ; ');
    end;
    if (cl.attr.return('KEY_DOWN_LEFT') <> nil) then
    begin
  		mMeth.writeLine(#9 + 'System_KEY_DOWNLEFT = KEY_DOWNLEFT ; ');
    end;
    if (cl.attr.return('KEY_LEFT') <> nil) then
    begin
		  mMeth.writeLine(#9 + 'System_KEY_LEFT = KEY_LEFT ; ');
    end;
    if (cl.attr.return('KEY_RIGHT') <> nil) then
    begin
  		mMeth.writeLine(#9 + 'System_KEY_RIGHT = KEY_RIGHT ; ');
    end;
    if (cl.attr.return('KEY_SHIFT') <> nil) then
    begin
  		mMeth.writeLine(#9 + 'System_KEY_SHIFT = KEY_SHIFT ; ');
    end;
    if (cl.attr.return('KEY_UP') <> nil) or (cl.attr.return('KEY_UPLEFT') <> nil) then
    begin
		  mMeth.writeLine(#9 + 'System_KEY_UP = KEY_UP ; ');
    end;
    if (cl.attr.return('AMS') <> nil) then
    begin
		  mMeth.writeLine(#9 + 'System_KEY_UPRIGHT = KEY_UPRIGHT ; ');
    end;
    if (cl.attr.return('KEY_UPLEFT') <> nil) then
    begin
		  mMeth.writeLine(#9 + 'System_KEY_UPLEFT = ( ( unsigned short ) System_KEY_UP ) | ( ( unsigned short )System_KEY_LEFT) ; ');
    end;
    if (cl.attr.return('KEY_DOWNRIGHT') <> nil) then
    begin
  		mMeth.writeLine(#9 + 'System_KEY_DOWNRIGHT = ( ( unsigned short ) System_KEY_DOWN ) | ( ( unsigned short )System_KEY_RIGHT) ; ');
    end;
  end;

  if isClass('Graphics') then
  begin
    cl := vecCl.return('Graphics');
    if (cl.attr.return('uScrRect') <> nil) then
    begin
      mMeth.writeLine(#9 + 'Graphics_uScrRect = malloc ( sizeof ( SCR_RECT ) ) ; ');
      mMeth.writeLine(#9 + '* Graphics_uScrRect = ( SCR_RECT ) { { 0 , 0 , 239 , 127 } } ; ');
    end;
  end;

  if isClass('GEM') then
  begin
    cl := vecCl.return('GEM');
    if GEMLCDUsed then
    begin
  		mMeth.writeLine(#9 + 'if ( System_CALCULATOR == System_CALCULATOR_TI89 ) { ');
      if (cl.attr.return('LCD_HEIGHT') <> nil) then
      begin
  	   	mMeth.writeLine(#9 + #9 + 'GEM_LCD_HEIGHT = 100 ; ');
      end;
      if (cl.attr.return('LCD_LINE_BYTES') <> nil) then
      begin
    		mMeth.writeLine(#9 + #9 + 'GEM_LCD_LINE_BYTES = 20 ; ');
      end;
      if (cl.attr.return('LCD_WIDTH') <> nil) then
      begin
	    	mMeth.writeLine(#9 + #9 + 'GEM_LCD_WIDTH = 160 ; ');
      end;
		  mMeth.writeLine(#9 + '} ');
  		mMeth.writeLine(#9 + 'else { ');
      if (cl.attr.return('LCD_HEIGHT') <> nil) then
      begin
	  	  mMeth.writeLine(#9 + #9 + 'GEM_LCD_HEIGHT = 128 ; ');
      end;
      if (cl.attr.return('LCD_LINE_BYTES') <> nil) then
      begin
  		  mMeth.writeLine(#9 + #9 + 'GEM_LCD_LINE_BYTES = 30 ; ');
      end;
      if (cl.attr.return('LCD_WIDTH') <> nil) then
      begin
    		mMeth.writeLine(#9 + #9 + 'GEM_LCD_WIDTH = 240 ; ');
      end;
	   	mMeth.writeLine(#9 + '} ');
      if (cl.attr.return('USABLE_HEIGHT') <> nil) then
      begin
    		mMeth.writeLine(#9 + 'GEM_USABLE_HEIGHT = GEM_LCD_HEIGHT - 6 ; ');
      end;
    end;
    if (cl.attr.return('vScrRect') <> nil) then
    begin
      if isClass('Graphics') and (vecCl.return('Graphics').attr.return('uScrRect') <> nil) then
      begin
        mMeth.writeLine(#9 + 'GEM_vScrRect = Graphics_uScrRect ; ');
      end
	  	else
      begin
			  mMeth.writeLine(#9 + 'GEM_vScrRect = malloc ( sizeof ( SCR_RECT ) ) ; ');
  			mMeth.writeLine(#9 + '* GEM_vScrRect = ( SCR_RECT ) { { 0 , 0 , 239 , 127 } } ; ');
      end;
    end;
  end;

  if mainCl.ifs.contains('Use_GarbageCollection') then
  begin
    mMeth.writeLine(#9 + 'GarbageCollector_array = malloc ( sizeof ( void * ) * ( GarbageCollector_max ) ) ; ');

    if (vecCl.return('System') <> nil) and ((vecCl.return('System').return('malloc_long_int') <> nil) or (vecCl.return('System').return('free_void_p') <> nil)) then
    begin
      mMeth.writeLine(#9 + 'GarbageCollector_arrayPtr = malloc ( sizeof ( void * ) * ( GarbageCollector_maxPtr ) ) ; ');
    end;
  end;
  *)

  //if usedClassInherits('Serializable') then
  if (vecCl.return('Serializable') <> nil) then
  begin
  if (num > 0) then
  begin
    mMeth.writeLine(#9 + 'ProtArray = malloc ( sizeof ( TObject * ) * ' + intToStr(num) + ' ) ; ');
  end;
  end;

  for i := 0 to vecCl.size - 1 do
  begin
    cl := vecCl.getClass(i);
    if cl.inter then
    begin
      for n := 0 to cl.meth.size - 1 do
      begin
        m := cl.meth.getMeth(n);
        if not m.stat then
        begin
          mMeth.writeLine(#9 + cl.name + '_' + m.name + m.getMorph + '_ProtArray = malloc ( sizeof ( TObject * ) * ' + intToStr(num) + ' ) ; ');
        end;
      end;
    end;
  end;

  num := 0;

  for i := 0 to vecCl.size - 1 do
  begin
    cl := vecCl.getClass(i);
    if cl.hasValuedStat then
    begin
      for n := 0 to cl.attr.size - 1 do
      begin
        a := cl.attr.getAttr(n);
        if  not a.fin and a.stat and (a.value.size > 0) then
        begin
          mMeth.writeLine(#9 + cl.name + '_' + a.name + ' = ' + a.text + ' ; ');
          //mMeth.writeLine(#9 + cl.name + '_' + a.name + ' = ' + a.value.toString + ' ; ');
        end;
      end;
    end;

    m := cl.return('static_');
    if (m <> nil) then
    begin
      //mMeth.writeLine(m.text);
      mMeth.writeLine(#9 + cl.name + '_static_ ( ) ; ');
    end;

    if not cl.inter then
    begin
      if not (cl.abst and cl.fin) then
      begin
        //if (usedClassInherits('Serializable')) then
        if (vecCl.return('Serializable') <> nil) then
        begin
          mMeth.writeString(#9 + 'ProtArray [ ' + intToStr(num) + ' ] = ');
        end;
        num := num + 1;
      end
      else
      begin
        //mMeth.writeString(#9);
      end;

      if cl.name = 'GEM' then
      begin
        mMeth.writeLine('GEM = TGEM_ ( ) ; ');
      end
      else if not (cl.abst and cl.fin) then
      begin
        (*if cl.hasValuedAttr then
        begin
          mMeth.writeLine(cl.name + ' = ' + 'T' + cl.name + '_ ( ) ; ');
        end
        else
        begin*)
          mMeth.writeLine(cl.name + ' = ' + 'T' + cl.name + '0 ( ) ; ');
          //mMeth.writeLine(cl.name + ' = malloc ( sizeof ( T' + cl.name + ' ) ) ; ');
          //mMeth.writeLine(#9 + 'T' + cl.name + '0 ( ' + cl.name + ' ) ; ');
        //end;
      end;
    end;
  end;

  for i := 0 to vecCl.size - 1 do
  begin
    cl := vecCl.getClass(i);
    if cl.inter then
    begin
      for n := 0 to cl.meth.size - 1 do
      begin
        m := cl.meth.getMeth(n);
        if not m.stat then
        begin
          num := 0;

          for z := 0 to vecCl.size - 1 do
          begin
            if (vecCl.getClass(z).used) and not vecCl.getClass(z).inter and not (vecCl.getClass(z).abst and vecCl.getClass(z).fin) then
            begin
              if (vecCl.getClass(z).returnAll(m.name + m.getMorph) <> nil) and vecCl.getClass(z).implAll(cl.name) then
              begin
                mMeth.writeLine(#9 + cl.name + '_' + m.name + m.getMorph + '_ProtArray [ ' + inttostr(num) + ' ] = ' + vecCl.getClass(z).name + ' -> ' + m.name + m.getMorph + ' ; ');
              end;
              num := num + 1;
            end;
          end;
        end;
      end;
    end;
  end;   

  (*
  mMeth.writeLine(#9 + 'atexit ( finalize ) ; ');

  if isClass('GEM') then
  begin
    mMeth.writeLine(#9 + 'GEM_gem = GEM ; ');
    mMeth.writeLine(#9 + 'xStartFunc = ' + mainCl.name + '_main_ ; ');
    mMeth.writeLine(#9 + 'GEM_gem -> setStarted_BOOL ( GEM_gem , TRUE ) ; ');
    mMeth.writeLine(#9 + 'GEM_gem -> setStarted_BOOL ( GEM_gem , FALSE ) ; ');
  end
  else
  begin
    mMeth.writeLine(#9 + mainCl.name + '_main_ ( ) ; ');
  end;

  if returnValue then
  begin
    mMeth.writeLine(#9 + 'TRY');
    mMeth.writeLine(#9 + #9 + 'while (GetArgType (top_estack) != END_TAG)');
    mMeth.writeLine(#9 + #9 + #9 + 'top_estack = next_expression_index (top_estack);');
    mMeth.writeLine(#9 + #9 + 'top_estack--;');
    mMeth.writeLine(#9 + 'ONERR');
    mMeth.writeLine(#9 + 'ENDTRY');

    mMeth.writeLine(#9 + 'push_longint ( 0 ) ; ');
  end;
  *)

  mainCF.writeLine(mMeth.comment);

  mainCF.writeLine(readFileAsString(configDir + pathSeparator + 'main.default') + ' { ');

  mainCF.writeLine(readFileAsString(configDir + pathSeparator + 'main.method'));

  mainCF.writeLine(mMeth.text);

  mainCF.writeLine(readFileAsString(configDir + pathSeparator + 'main2.method'));

  mainCF.writeLine('} ');


  mainCF.writeLine(readFileAsString(configDir + pathSeparator + 'funcs'));

  mainCF.writeLine(readFileAsString(configDir + pathSeparator + 'ADT_GarbageCollector.c'));

  (*if mainCl.ifs.contains('Use_GarbageCollection') then
  begin
    mainCF.writeLine('void GarbageCollector_add_Object ( void * obj ) { ');
    mainCF.writeLine(#9 + 'void * * buf ; ');
    mainCF.writeLine(#9 + 'if ( GarbageCollector_size < GarbageCollector_max ) ');
    mainCF.writeLine(#9 + #9 + 'GarbageCollector_array [ GarbageCollector_size ] = obj ; ');
    mainCF.writeLine(#9 + 'else { ');
    mainCF.writeLine(#9 + #9 + 'GarbageCollector_max += GarbageCollector_INCR ; ');
    mainCF.writeLine(#9 + #9 + 'buf = malloc ( sizeof ( void * ) * ( GarbageCollector_max ) ) ; ');
    mainCF.writeLine(#9 + #9 + 'memcpy ( buf , GarbageCollector_array, GarbageCollector_size * sizeof ( void * ) ) ; ');
    mainCF.writeLine(#9 + #9 + 'buf [ GarbageCollector_size ] = obj ; ');
    mainCF.writeLine(#9 + #9 + 'free ( GarbageCollector_array ) ; ');
    mainCF.writeLine(#9 + #9 + 'GarbageCollector_array = buf ; ' );
    mainCF.writeLine(#9 + '} ');
    mainCF.writeLine(#9 + 'GarbageCollector_size ++ ; ');
    mainCF.writeLine('} ');

    mainCF.writeLine('void GarbageCollector_rem_Object ( void * obj ) { ');
    mainCF.writeLine(#9 + 'long int i ; ');
    mainCF.writeLine(#9 + 'for ( i = 0 ; i < GarbageCollector_size ; i ++ ) { ');
    mainCF.writeLine(#9 + #9 + 'if ( obj == GarbageCollector_array [ i ] ) break ; ');
    mainCF.writeLine(#9 + '}');
    mainCF.writeLine(#9 + 'if ( i < GarbageCollector_size ) GarbageCollector_rem_long_int ( i ) ; ');
    mainCF.writeLine('} ');

    mainCF.writeLine('void GarbageCollector_rem_long_int ( long int pos ) { ');
    mainCF.writeLine(#9 + 'memmove ( GarbageCollector_array + pos, GarbageCollector_array + pos + 1, ( GarbageCollector_size - pos - 1 ) * sizeof ( void * ) ) ; ');
    mainCF.writeLine(#9 + 'GarbageCollector_size -- ; ');
    mainCF.writeLine('} ');

    if (vecCl.return('System') <> nil) and ((vecCl.return('System').return('malloc_long_int') <> nil) or (vecCl.return('System').return('free_void_p') <> nil)) then
    begin
      mainCF.writeLine('void GarbageCollector_addPtr_void_p ( void * obj ) { ');
      mainCF.writeLine(#9 + 'void * * buf ; ');
      mainCF.writeLine(#9 + 'if ( GarbageCollector_sizePtr < GarbageCollector_maxPtr ) ');
      mainCF.writeLine(#9 + #9 + 'GarbageCollector_arrayPtr [ GarbageCollector_sizePtr ] = obj ; ');
      mainCF.writeLine(#9 + 'else { ');
      mainCF.writeLine(#9 + #9 + 'GarbageCollector_maxPtr += GarbageCollector_INCRPTR ; ');
      mainCF.writeLine(#9 + #9 + 'buf = malloc ( sizeof ( void * ) * ( GarbageCollector_maxPtr ) ) ; ');
      mainCF.writeLine(#9 + #9 + 'memcpy ( buf , GarbageCollector_arrayPtr, GarbageCollector_sizePtr * sizeof ( void * ) ) ; ');
      mainCF.writeLine(#9 + #9 + 'buf [ GarbageCollector_sizePtr ] = obj ; ');
      mainCF.writeLine(#9 + #9 + 'free ( GarbageCollector_arrayPtr ) ; ');
      mainCF.writeLine(#9 + #9 + 'GarbageCollector_arrayPtr = buf ; ' );
      mainCF.writeLine(#9 + '} ');
      mainCF.writeLine(#9 + 'GarbageCollector_sizePtr ++ ; ');
      mainCF.writeLine('} ');

      mainCF.writeLine('void GarbageCollector_remPtr_void_p ( void * obj ) { ');
      mainCF.writeLine(#9 + 'long int i ; ');
      mainCF.writeLine(#9 + 'for ( i = 0 ; i < GarbageCollector_sizePtr ; i ++ ) { ');
      mainCF.writeLine(#9 + #9 + 'if ( obj == GarbageCollector_arrayPtr [ i ] ) break ; ');
      mainCF.writeLine(#9 + '}');
      mainCF.writeLine(#9 + 'if ( i < GarbageCollector_sizePtr ) GarbageCollector_remPtr_long_int ( i ) ; ');
      mainCF.writeLine('} ');

      mainCF.writeLine('void GarbageCollector_remPtr_long_int ( long int pos ) { ');
      mainCF.writeLine(#9 + 'memmove ( GarbageCollector_arrayPtr + pos, GarbageCollector_arrayPtr + pos + 1, ( GarbageCollector_sizePtr - pos - 1 ) * sizeof ( void * ) ) ; ');
      mainCF.writeLine(#9 + 'GarbageCollector_sizePtr -- ; ');
      mainCF.writeLine('} ');
    end
  end;*)

  finalMeth := TMethode.Create('/*' + newLine + ' * This function is called when the program exits.' + newLine + ' * It frees the ressources used by the prototypes of the objects.' + newLine + ' */');

  if (globalObjects.size > 0) then
  begin
    finalMeth.writeLine('ADT_GarbageCollector_clearObjects ( & _global_GarbageCollector_instance_reserved_keyword ) ; ');
  end;


  //if usedClassInherits('Serializable') then
  if (vecCl.return('Serializable') <> nil) then
  begin

    if (num > 0) then
    begin
      finalMeth.writeLine(#9 + 'if ( ProtArray ) ');
      finalMeth.writeLine(#9 + #9 + 'free ( ProtArray ) ; ');
    end;
  end;



  for i := 0 to vecCl.size - 1 do
  begin
    cl := vecCl.getClass(i);
    if cl.inter then
    begin
      for n := 0 to cl.meth.size - 1 do
      begin
        m := cl.meth.getMeth(n);
        if not m.stat then
        begin
          finalMeth.writeLine(#9 + 'free ( ' + cl.name + '_' + m.name + m.getMorph + '_ProtArray ) ; ');
        end;
      end;
    end;
  end;

  for i := 0 to vecCl.size - 1 do
  begin
    cl := vecCl.getClass(i);
    if not cl.inter then
    begin
      if (cl.name = 'GEM') then
      begin
        finalMeth.writeLine(#9 + 'GEM -> finalize_ ( GEM ) ; ');
      end
      else if not (cl.abst and cl.fin) then
      begin
        (* if cl.hasValuedAttr then
        begin
          finalMeth.writeLine(#9 + cl.name + ' -> finalize_ ( ' + cl.name + ' ) ; ');
        end
        else
        begin *)
          finalMeth.writeLine(#9 + 'free ( ' + cl.name + ' ) ; ');
          if mainCl.ifs.contains('Use_GarbageCollection') then
          begin
            finalMeth.writeLine(#9 + 'GarbageCollector_rem_Object ( ' + cl.name + ' ) ; ');
          end;
        //end;
      end;
      m := TMethode.Create('');
      m.name := 'finally';
      if cl.meth.contains(m) then
      begin
        finalMeth.writeLine(#9 + cl.name + '_finally_ ( ) ; ');
      end;
    end;
  end;

  mainCF.writeLine(finalMeth.comment);

  mainCF.writeLine(readFileAsString(configDir + pathSeparator + 'finalize.default') + ' { ');

  mainCF.writeLine(readFileAsString(configDir + pathSeparator + 'finalize.method'));

  mainCF.writeLine(finalMeth.text);

  (* 2004/03/07
  if isClass('GEM') and vecCl.return('GEM').attr.contains('vScrRect') then
  begin
    mainCF.writeLine(#9 + 'free ( GEM_vScrRect ) ; ');
  end
  else if isClass('Graphics') and vecCl.return('Graphics').attr.contains('uScrRect') then
  begin
    mainCF.writeLine(#9 + 'free ( Graphics_uScrRect ) ; ');
  end;

  if not mainCl.ifs.contains('No_SaveScreen') then
  begin
    mainCF.writeLine(#9 + 'LCD_restore ( systemScrSaveBuffer ) ; ');
    mainCF.writeLine(#9 + 'free ( systemScrSaveBuffer ) ; ');
  end;
  *)

  (*if mainCl.ifs.contains('Use_GarbageCollection') then
  begin
    mainCF.writeLine(#9 + 'while ( GarbageCollector_size ) ( ( TObject * ) GarbageCollector_array [ 0 ] ) -> finalize_ ( ( TObject * ) GarbageCollector_array [ 0 ] ) ; ');
    mainCF.writeLine(#9 + 'free ( GarbageCollector_array ) ; ');

    if (vecCl.return('System') <> nil) and ((vecCl.return('System').return('malloc_long_int') <> nil) or (vecCl.return('System').return('free_void_p') <> nil)) then
    begin
      mainCF.writeLine(#9 + 'while ( GarbageCollector_sizePtr ) System_free_void_p ( GarbageCollector_arrayPtr [ 0 ] ) ; ');
      mainCF.writeLine(#9 + 'free ( GarbageCollector_arrayPtr ) ; ');
    end;
  end; *)

  mainCF.writeLine(readFileAsString(configDir + pathSeparator + 'finalize2.method'));

  mainCF.writeLine('} ');

  end;

  writeStringToFile(mainCF.outText, dirOut + pathSeparator + mainCl.name + '.c');

  writeStringToFile(featF.outText, dirOut + pathSeparator + 'features.h');
  writeStringToFile(messF.outText, dirOut + pathSeparator + 'messages.h');

  projF := TFileLinked.Create;

  projF.writeLine('[Settings]');
  projF.writeLine(readFileAsString(configDir + pathSeparator + 'tigcc_project.default'));
  projF.writeLine('[Included Files]');
  projF.writeLine('C File 1=' + mainCl.name + '.c');

  cpt := 2;

  for i := 0 to vecCl.size - 1 do
  begin
    cl := vecCl.getClass(i);
    for n := 0 to vecCl.size - 1 do
    begin
      if strEndsWith(cl.inclu.get(n), '.c') then
      begin
        projF.writeLine('C File ' + intToStr(cpt) + '=' + extractFile(cl.inclu.get(n)));
        cpt := cpt + 1;
      end;
    end;
  end;

  projF.writeLine('Header File 1=features.h');
  projF.writeLine('Header File 2=packages.h');
  projF.writeLine('Header File 3=messages.h');
  for i := 0 to vecPk.size - 1 do
  begin
    projF.writeLine('Header File ' + intToStr(i + 4) + '=' + vecPk.getPack(i).name + '.h');
  end;
  for i := 0 to vecCl.size - 1 do
  begin
    projF.writeLine('Header File ' + intToStr(i + vecPk.size +  4) + '=T' + vecCl.getClass(i).name + '.h');
  end;

  cpt := vecPk.size + vecCl.size +  4;

  for i := 0 to vecCl.size - 1 do
  begin
    cl := vecCl.getClass(i);
    for n := 0 to cl.inclu.size - 1 do
    begin
      if strEndsWith(cl.inclu.getStr(n), '.h') then
      begin
        projF.writeLine('Header File ' + intToStr(cpt) + '=' + extractFile(cl.inclu.getStr(n)));
        cpt := cpt + 1;
      end;
    end;
  end;

  writeStringToFile(projF.outText, dirOut + pathSeparator + mainCl.name + '.tpr');
end;

function countUsedClasses: Longint;
var
  i: Longint;
  count: Longint;
  cl :TClasse;
begin
  count := 0;

  for i := 0 to vecCl.size - 1 do
  begin
    cl := vecCl.getClass(i);
    if (cl.used) and not cl.inter and not (cl.abst and cl.fin) then
    begin
      count := count + 1;
    end;
  end;

  countUsedClasses := count;
end;

function countUsedSerializable: Longint;
var
  i: Longint;
  count: Longint;
  cl: TClasse;
begin
  count := 0;

  for i := 0 to vecCl.size - 1 do
  begin
    cl := vecCl.getClass(i);
    if cl.used and not (cl.abst and cl.fin) and (cl.ext('Serializable') or (cl.name = 'Serializable')) then
    begin
      count := count + 1;
    end;
  end;

  countUsedSerializable := count;
end;

procedure copyHeaders;
var
  i: Longint;
  n: Longint;
  vecStr: TStringVector;
  str: AnsiString;
begin
      //vecStr := getFilesVector(dirProj, '*.h');

      for i := 0 to vecCl.size - 1 do
      begin
        vecStr := vecCl.getClass(i).inclu;
        for  n := 0 to vecStr.size - 1 do
        begin
          str := vecStr.getStr(n);
          writeStringToFile(readFileAsString(str), dirOut + pathSeparator + extractFile(str));
        end;
      end;
end;

end.
