;-----------------------------------------------------
;
;			Attente Clavier
;
;-----------------------------------------------------

AttendPressionClavier:
	movem.l		d1-d7/a0-a6,-(a7)
RetourTrap4:
	CALL		OSTimerRestart
	move.w		#75,-(a7)
	CALL		OSInitKeyInitDelay
	move.w		#20,(a7)
	CALL		OSInitBetweenKeyDelay
	addq.l		#2,a7
	CALL		ngetchx
	cmp.w		#267,d0
	bne		PasON
	trap		#4
	bra		RetourTrap4
PasON:
	movem.l		(a7)+,d1-d7/a0-a6
	rts




;-----------------------------------------------------
;
;			Nettoyage Ecran
;
;-----------------------------------------------------

NettoyeEcranGray:
	movem.l		a0,-(a7)
	move.l		Plane0,a0
	bsr		NettoyeEcran
	move.l		Plane1,a0
	bsr		NettoyeEcran	
	movem.l		(a7)+,a0
	rts

NettoyeEcran:
	movem.l		d0,-(a7)
	move.w		#959,d0
BoucleNettoyeEcran:
	clr.l		(a0)+
	dbra		d0,BoucleNettoyeEcran
	movem.l		(a7)+,d0
	rts



;-----------------------------------------------------
;
;			Affichage Grosse Image
;			Entres :
;				- a0.l -> plane0
;				- a1.l -> plane1
;				- a2.l -> premier_plan_image
;				- a3.l -> second_plan_image
;				- d0.w -> x
;				- d1.w -> y
;				- d2.w -> largeur_plan_en_bits
;				- d3.w -> 0 = affiche en ecrasant, autre = affichage conservant
;
;-----------------------------------------------------

AfficheGrosseImage2:
	movem.l		d3-d5,-(a7)				; sauvegarde les registres
	mulu.w		d2,d1					; multiplie y par la largeur du plan
	add.w		d0,d1					; ajoute le decallage de d0 octets
	adda		d1,a0					; et ajoute le tout au plan 0
	adda		d1,a1					; puis au plan 1
	move.w		d4,d0
	bra		ContinueAfficheGrosseImage

AfficheGrosseImage:
	movem.l		d3-d5,-(a7)				; sauvegarde les registres
	mulu.w		d2,d1					; multiplie y par la largeur du plan
	add.w		d0,d1					; ajoute le decallage de d0 octets
	adda		d1,a0					; et ajoute le tout au plan 0
	adda		d1,a1					; puis au plan 1
	lea		4(a3),a3				; saute l'entete
	move.w		(a2)+,d0				; hauteur en lignes du sprite
	move.w		(a2)+,d5				; largeur en octets du sprite

ContinueAfficheGrosseImage:
	move.w		d2,d4					; largeur du plan dans d4
	sub.w		d5,d4					; d4 = largeur du plan - largeur en octets du sprite
	sub.w		#1,d5					; pour les dbra
	sub.w		#1,d0					; idem
	tst.w		d3
	bne		BoucleAffichageConservant1
BoucleAfficheEcrasant1:
	move.w		d5,d1					; reinitialise d1 grace a d5
BoucleAfficheEcrasant2:
	move.b		(a2)+,(a0)+				; copie un bit de l'image0 sur le premier plan
	move.b		(a3)+,(a1)+				; copie un bit de l'image1 sur le second plan
	dbra		d1,BoucleAfficheEcrasant2
	adda		d4,a0					; decallage en fonction de la taille de l'image
	adda		d4,a1					; idem sur le second plan
	dbra		d0,BoucleAfficheEcrasant1
	movem.l		(a7)+,d3-d5				; restaure les registres
	rts

BoucleAffichageConservant1:
	move.w		d5,d1					; reinitialise d1 grace a d5
BoucleAffichageConservant2:
	clr.l		d2
	clr.l		d3
	move.b		(a3)+,d3
	not.b		d3
	and.b		d3,(a0)
	not.b		d3
	move.b		(a2)+,d2
	or.b		d2,(a0)+				; copie un bit de l'image0 sur le premier plan
	not.b		d2
	and.b		d2,(a1)
	or.b		d3,(a1)+				; copie un bit de l'image1 sur le second plan
	dbra		d1,BoucleAffichageConservant2
	adda		d4,a0					; decallage en fonction de la taille de l'image
	adda		d4,a1					; idem sur le second plan
	dbra		d0,BoucleAffichageConservant1
	movem.l		(a7)+,d3-d5				; restaure les registres
	rts



;-----------------------------------------------------
;
;			Conversion Nombre Chaine
;
;-----------------------------------------------------

ConversionNombreChaine:
	movem.l		d0-d2,-(a7)
	clr.b		(a0)
RepeteConversion:
	divu		#10,d0
	move.l		d0,d2
	swap		d2
	add.b		#48,d2
	move.b		d2,-(a0)
	subq		#1,d1
	and.l		#$FFFF,d0
	bne		RepeteConversion
	tst.w		d1
	beq		ConversionTerminee
	subq		#1,d1
RemplitEspaces:
	move.b		#32,-(a0)
	dbra		d1,RemplitEspaces
ConversionTerminee:
	movem.l		(a7)+,d0-d2
	rts




;-----------------------------------------------------
;
;			Gestion Interruptions
;
;-----------------------------------------------------

DetourneInterruptions:
	move.w		#$700,d0
	trap		#1
	bclr.b		#2,$600001
	move.w		d0,-(a7)
	move.l		$64,old_int1
	move.l		$78,old_int6
	move.l		#new_int1,$64
	move.l		#new_int6,$78
	bset.b		#2,$600001
	move.w		(a7),d0
	lea		2(a7),a7
	trap		#1
	rts

RetablitInterruptions:
	move.w		#$700,d0
	trap		#1
	bclr.b		#2,$600001
	move.l		old_int1,$64
	move.l		old_int6,$78
	bset.b		#2,$600001
	trap		#1
	rts

old_int1		dc.l	0
old_int6		dc.l	0

new_int1:
	rte

new_int6:
	rte
	
		


;-----------------------------------------------------
;
;			Attend Relachement Clavier
;
;-----------------------------------------------------

AttendRelachementClavier:
	movem.l		d0-d2,-(a7)
TouchePressee:
	move.w		#$FFFE,d0
	moveq		#9,d1
BoucleAttendClavier:
	move.w		d0,$600018
	moveq		#20,d2
AttenteHardWareRelache:
	dbf		d2,AttenteHardWareRelache
	cmp.b		#$FF,$60001B
	bne		TouchePressee
	rol.w		#1,d0
	dbra		d1,BoucleAttendClavier
	movem.l		(a7)+,d0-d2
	rts



;-----------------------------------------------------
;
;			Synchronisation d'affichage
;
;-----------------------------------------------------
SynchronisationVerticale:
	move.w		#1,GrayFlag
Attente:
	tst.w		GrayFlag
	bne		Attente
	rts



;-----------------------------------------------------
;
;			Selectionne Calculatrice
;
;-----------------------------------------------------

SelectionneCalculatrice:
	cmp.b		#CALC_TI89,CALCULATOR
	bne		Selectionne92PlusProfile
	move.w		#0,OctetsDecallageX
	move.w		#0,NbLignesDecallage
	move.w		#0,NbColDecallage
	move.w		#NombreLignes89,NombreLignes
	move.w		#LargeurEcran89,LargeurEcran
	move.w		#ToucheHaut89,ToucheHaut
	move.w		#ToucheBas89,ToucheBas
	move.w		#ToucheGauche89,ToucheGauche
	move.w		#ToucheDroite89,ToucheDroite
	move.w		#ToucheRapideHaut89,ToucheRapideHaut
	move.w		#ToucheRapideBas89,ToucheRapideBas
	move.l		#$200000,AdresseArchive
	move.l		#chaine_ti89,a0
	move.l		a0,AdresseChaineCalc
	rts

Selectionne92PlusProfile:
	move.w		#5,OctetsDecallageX
	move.w		#14,NbLignesDecallage
	move.w		#40,NbColDecallage
	move.w		#NombreLignes92,NombreLignes
	move.w		#LargeurEcran92,LargeurEcran
	move.w		#ToucheHaut92,ToucheHaut
	move.w		#ToucheBas92,ToucheBas
	move.w		#ToucheGauche92,ToucheGauche
	move.w		#ToucheDroite92,ToucheDroite
	move.w		#ToucheRapideHaut92,ToucheRapideHaut
	move.w		#ToucheRapideBas92,ToucheRapideBas
	move.l		#$400000,AdresseArchive
	move.l		#chaine_ti92plus,a0
	cmp.b		#CALC_V200,CALCULATOR
	bne		FinSelectionProfil
	move.l		#chaine_v200,a0
FinSelectionProfil:
	move.l		a0,AdresseChaineCalc
	rts



;-----------------------------------------------------
;
;			Detection HardWare
;
;-----------------------------------------------------

DetectionHardWare:
	move.l		$C8,a0
	move.b		#CALC_TI92,CALCULATOR
	move.l		a0,d1
	and.l		#$400000,d1
	bne		CalculatriceDetectee
	move.b		#CALC_TI89,CALCULATOR
	move.l		ScrRect*4(a0),a1
	cmp.b		#200,2(a1)
	bcs		CalculatriceDetectee
	move.b		#CALC_V200,CALCULATOR

CalculatriceDetectee:
	move.l		$C8,a5
	move.l		a5,d0
	and.l		#$E00000,d0
	move.l		d0,a0
	move.l		$104(a0),a0
	moveq		#1,d7
	sub.l		a0,d0
	cmp.l		#-$10000,d0
	bls.b		HardWareDecte
	cmp.w		#$16,(a0)
	bls.b		HardWareDecte
	move.l		$16(a0),d7
HardWareDecte:
	move.w		d7,HARDWARE
	rts



;-----------------------------------------------------
;
;			Cherche un fichier dans la VAT
;				Entree : a5=nom du fichier
;				Sortie : a0=debut du fichier
;
;-----------------------------------------------------

ChercheFichier:
	movem.l		d1-d7/a1-a6,-(a7)

	move.l		(a5)+,d3
	move.l		(a5),d4

	move.w		FolderListHandle,-(a7)
	CALL		HeapDeref
	addq.l		#2,a7
	lea		2(a0),a6
	move.w		(a6),d7					; nombre de folders
	subq.w		#1,d7
	BoucleFolder:
		lea		14(a6),a6			; passe au prochain folder
		move.w		(a6),-(a7)
		CALL		HeapDeref
		addq.l		#2,a7
		addq.l		#2,a0
		move.w		(a0)+,d6
		beq		FolderVide
		subq.w		#1,d6
		BoucleFichier:
			cmp.l		(a0),d3
			bne		Suivant
			cmp.l		4(a0),d4
			bne		Suivant

			tst.w		d0
			beq		Suivant

			move.l		a0,a5
			move.w		12(a0),-(a7)
			CALL		HeapDeref
			addq.l		#2,a7

			bra		FichierTrouve

		Suivant:
			lea		14(a0),a0
			dbra		d6,BoucleFichier
	FolderVide:
		dbra		d7,BoucleFolder

	clr.l		d0
FichierTrouve:
	movem.l		(a7)+,d1-d7/a1-a6
	rts




ChercheFichierDansRep:
	movem.l		d1-d7/a1-a6,-(a7)
	move.l		a0,-(a7)			; Entre l'adresse du nom du fichier
	CALL		SymFind				; On va chercher le Handle, stock dans d0
	lea		4(a7),a7			; Restaure la pile

	tst.w		d0
	beq		FichierDansRepNonTrouve

	move.l		d0,-(a7)
	CALL		DerefSym
	add		#4,a7
	move.w		12(a0),d0

	move.w		d0,-(a7)
	CALL		HeapUnlock
	lea		2(a7),a7
FichierDansRepNonTrouve:
	movem.l		(a7)+,d1-d7/a1-a6
	rts



ChargeParametres:

	pea		VarStr(pc)
	CALL		SymFind						;On va chercher le Handle
	lea		4(a7),a7
	tst.w		d0
	bne		FichierExistant					;Si il existe deja, on ne cree pas le fichier

	pea		VarStr(pc)
	add.l		#TailleParametres+1+1+3+1+1-1,(a7)		;Tag (STR)
	move.w		#TailleParametres+5+1,-(a7)			;Taille par dfaut
	move.w		#$4000,-(a7)					;C'est un Token
	pea		VarStr(pc)					;Nom de la Var
	CALL		VarStore					;On enregistre
	CALL		SymFind						;On va chercher le Handle
	lea		12(a7),a7

	move.l		d0,-(a7)
	CALL		DerefSym
	add		#4,a7
	move.w		12(a0),d0

	move.w		d0,-(a7)
	CALL		HLock
	lea		2(a7),a7

	addq.l		#2,a0
	move.l		a0,AdresseParametres

	move.w		#TailleParametres-1,d0
	BoucleEffacement:
		clr.b		(a0)+
		dbra		d0,BoucleEffacement

	bra		ChargeValeurs

FichierExistant:
	move.l		d0,-(a7)
	CALL		DerefSym
	add		#4,a7
	move.w		12(a0),d0

	move.w		d0,-(a7)
	CALL		HLock
	lea		2(a7),a7

	addq.l		#2,a0
	move.l		a0,AdresseParametres

ChargeValeurs:
	move.l		AdresseParametres,a0
	rts


SauvegardeParametres:
	move.l		AdresseParametres,a0
	rts
