;-----------------------------------------------------
;-----------------------------------------------------
;-----------------------------------------------------
;
;			Boucle principale de la navigation
;
;	PositionFolder.w :		0 --> Liste des dossiers
;					1 --> Liste des fichiers
;					2 --> Execution de fichiers
;
;	RepertoireSelectionne.w :	Numero du fichier selectionne
;
;-----------------------------------------------------
;-----------------------------------------------------
;-----------------------------------------------------

BouclePrincipale:
	bsr		AttendPressionClavier

;-----------------------------------------------------
;
;			On quitte ?
;
;-----------------------------------------------------

	cmp.b		#ToucheESC,d0
	beq		AbandonneNavigation


;-----------------------------------------------------
;
;			On se deplace ?
;
;-----------------------------------------------------

	cmp.w		ToucheBas,d0
	bne		PasBas
	bsr		DescendDansLaListe
	bra		FinLectureClavier
PasBas:
	cmp.w		ToucheHaut,d0
	bne		PasHaut
	bsr		MonteDansLaListe
	bra		FinLectureClavier
PasHaut:

	cmp.w		ToucheRapideBas,d0
	bne		PasBasRapide
	move.w		NombreLignes,d7
	sub.w		#2,d7
	BoucleDeplacementRapideHaut:
		move.w		d7,-(a7)
		bsr		DescendDansLaListe
		move.w		(a7)+,d7
		dbra		d7,BoucleDeplacementRapideHaut		
	bra		FinLectureClavier
PasBasRapide:
	cmp.w		ToucheRapideHaut,d0
	bne		PasHautRapide
	move.w		NombreLignes,d7
	sub.w		#2,d7
	BoucleDeplacementRapideBas:
		move.w		d7,-(a7)
		bsr		MonteDansLaListe
		move.w		(a7)+,d7
		dbra		d7,BoucleDeplacementRapideBas		
	bra		FinLectureClavier
PasHautRapide:



;-----------------------------------------------------
;
;			On change de fenetre ?
;
;-----------------------------------------------------

	cmp.w		ToucheGauche,d0
	bne		PasGauche
	tst.w		PositionFolder
	beq		PasGauche
	clr.w		PositionFolder
	move.w		RepertoireSelectionne,d0
	sub.w		OldPositionListeEcran,d0
	move.w		d0,PositionBarre
	move.w		OldPositionListeEcran,d0
	move.w		d0,PositionListeEcran
	bsr		InitialiseEcran
	bra		FinLectureClavier
PasGauche:
	cmp.w		ToucheDroite,d0
	bne		PasDroite
	cmp.w		#1,PositionFolder
	beq		PasDroite
	move.w		#1,PositionFolder
	bra		EntreDansUnDossier
PasDroite:

	cmp.b		#ToucheENTER,d0
	bne		PasEnter
	add.w		#1,PositionFolder
	cmp.w		#1,PositionFolder
	bne		FinLectureClavier
EntreDansUnDossier:
	move.w		FolderListHandle,-(a7)
	CALL		HeapDeref
	addq.l		#2,a7
	lea		2(a0),a0
	move.w		PositionBarre,d0
	add.w		PositionListeEcran,d0
	mulu.w		#14,d0
	add.w		d0,a0
	move.w		14(a0),-(a7)
	CALL		HeapDeref
	addq.l		#2,a7
	lea		2(a0),a2
	tst.w		(a2)
	beq		DossierVide

	move.w		PositionBarre,d0
	add.w		PositionListeEcran,d0
	move.w		d0,RepertoireSelectionne
	move.w		PositionListeEcran,d0
	move.w		d0,OldPositionListeEcran
	clr.w		PositionBarre
	clr.w		PositionListeEcran
	bsr		InitialiseEcran
	bra		FinLectureClavier
PasEnter:




FinLectureClavier:

;-----------------------------------------------------
;
;			On execute le fichier ?
;
;-----------------------------------------------------

	cmp.w		#2,PositionFolder
	blt		PasDExecution
ExecuteFichier:
	move.w		#1,PositionFolder
	bsr		Exec
PasDExecution:

	bra		BouclePrincipale





;-----------------------------------------------------
;-------------Fin de la boucle principale-------------
;-----------------------------------------------------



;-----------------------------------------------------
;-----------------------------------------------------
;-----------------------------------------------------
;
;			Gestion du deplacement / Scrolling
;
;-----------------------------------------------------
;-----------------------------------------------------
;-----------------------------------------------------

DescendDansLaListe:
	move.w		PositionBarre,d0
	add.w		#1,d0
	move.w		d0,d1
	add.w		PositionListeEcran,d0
	cmp.w		NombreItems,d0
	bge		FinDeplacementListe
	cmp.w		NombreLignes,d1
	bge		ScrollListeVersLeHaut
	bsr		InverseBarre
	add.w		#1,PositionBarre
	bsr		InverseBarre
	bra		FinDeplacementListe
ScrollListeVersLeHaut:
	move.w		PositionListeEcran,d0
	add.w		PositionBarre,d0
	cmp.w		NombreItems,d0
	bge		FinDeplacementListe
	add.w		#1,PositionListeEcran

	bsr		InverseBarre
	move.l		Plane0,a0
	bsr		ScrollHaut
	move.l		Plane1,a0
	bsr		ScrollHaut

	move.w		PositionListeEcran,d0
	bsr		AfficheListing2
	move.w		d0,PositionListeEcran
	bsr		SelectionneCalculatrice

	bsr		InverseBarre

	rts

MonteDansLaListe:
	tst.w		PositionBarre
	beq		ScrollListeVersLeBas
	bsr		InverseBarre
	sub.w		#1,PositionBarre
	bsr		InverseBarre
	bra		FinDeplacementListe
ScrollListeVersLeBas:
	tst.w		PositionListeEcran
	ble		FinDeplacementListe
	sub.w		#1,PositionListeEcran

	bsr		InverseBarre
	move.l		Plane0,a0
	bsr		ScrollBas
	move.l		Plane1,a0
	bsr		ScrollBas

	move.w		#1,NombreLignes
	bsr		AfficheListing
	bsr		SelectionneCalculatrice

	bsr		InverseBarre

FinDeplacementListe:
	rts



DossierVide:
	clr.w		PositionFolder
	bra		FinLectureClavier



;-----------------------------------------------------
;
;			On pointe sur le fichier selectionne
;
;			--> renvoie l'adresse du fichier dans a0
;
;-----------------------------------------------------

PointeSurFichier:
	bsr		PointeSurLeHandleDuFichier
	move.w		12(a0),-(a7)			; Et on pointe dessus
	CALL		HeapDeref
	addq.l		#2,a7
	rts

PointeSurLeHandleDuFichier:
	bsr		PointeSurLeHandleDuDossier
	move.w		14(a0),-(a7)			; On pointe sur le bon dossier
	CALL		HeapDeref
	addq.l		#2,a7
	lea		4(a0),a0
	move.w		PositionBarre,d0		; Dans le dossier, on se dirige sur le fichier selectionne
	add.w		PositionListeEcran,d0
	mulu.w		#14,d0
	add.w		d0,a0
	rts


PointeSurLeHandleDuDossier:
	move.w		FolderListHandle,-(a7)
	CALL		HeapDeref
	addq.l		#2,a7
	lea		2(a0),a0			; On pointe sur la liste des dossiers
	move.w		RepertoireSelectionne,d0	; En fonction de la selection, on se dirige vers un des dossiers
	mulu.w		#14,d0
	add.w		d0,a0
	rts

;-----------------------------------------------------
;
;			Abandon de la navigation
;
;-----------------------------------------------------

AbandonneNavigation:
	rts
