;-----------------------------------------------------
;
;			Initialisation de l'ecran, affichage du tableau et de la liste
;
;-----------------------------------------------------

InitialiseEcran:
	bsr		SynchronisationVerticale
	movem.l		d0-d7/a0-a6,-(a7)
	bsr		NettoyeEcranGray
	bsr		AfficheToolBarre
	bsr		AfficheListing
	bsr		InverseBarre
	movem.l		(a7)+,d0-d7/a0-a6
	rts



;-----------------------------------------------------
;
;			Affichage de la barre du titre
;
;-----------------------------------------------------

AfficheToolBarre:
	move.w		#29,d7
	BoucleAffichageToolBarre:
		GrosseImage	#barre_hautp0,#barre_hautp1,Plane0,Plane1,#30,#0,d7,#0
		dbra		d7,BoucleAffichageToolBarre
	GrosseImage	#barre_haut_gauchep0,#barre_haut_gauchep1,Plane0,Plane1,#30,#0,#0,#0

	move.l		#barre_haut_droitep0,a2			; image premier plan
	move.l		#barre_haut_droitep1,a3			; image second plan
	move.l		Plane0,a0				; plan 1
	move.l		Plane1,a1				; plan 2
	move.w		#30,d2					; largeur du plan en bits
	clr.w		d3					; mode
	clr.w		d1					; y
	move.w		#30-2,d0				; x
	move.w		#11,d4
	cmp.b		#CALC_TI89,CALCULATOR
	bne		AffichageToolBarreFin
	move.w		#20-2,d0				; x
	move.w		#6,d4
AffichageToolBarreFin:
	bsr		AfficheGrosseImage

;	SetFont		#2
	move.w		#4,-(a7)				; Couleur
	move.l		#chaine_explorer,-(a7)			; Chaine
	move.w		#3,-(a7)				; y
	move.w		#11,-(a7)				; x
	CALL		DrawStrXY
	bsr		PortSetPlane1
	clr.w		8(a7)
	CALL		DrawStrXY

	move.l		AdresseChaineCalc,a0
	tst.w		PositionFolder
	beq		AfficheDeuxiemePartieToolBarre
	bsr		PointeSurLeHandleDuDossier
	lea		2(a0),a0
AfficheDeuxiemePartieToolBarre:	
	clr.w		-(a7)					; Couleur
	move.l		a0,-(a7)				; Chaine
	move.w		#3,-(a7)				; y
	move.w		#11+6*11,-(a7)				; x
	CALL		DrawStrXY
	bsr		PortSetPlane0
	move.w		#4,8(a7)
	CALL		DrawStrXY
	lea		20(a7),a7
;	SetFont		#1
	rts



;-----------------------------------------------------
;
;			Affiche la liste des dossiers/fichiers
;
;-----------------------------------------------------

InverseBarre:
	move.w		PositionBarre,d0
	mulu.w		#PasDecalageListeY,d0
	add.w		#YListeDepart,d0
	mulu.w		#30,d0
	move.l		Plane1,a0
	add.w		d0,a0
	bsr		InverseBitsBarre
	rts


InverseBitsBarre:
	eor.b		#%00000111,1*30(a0)
	eor.b		#%00001111,2*30(a0)
	eor.b		#%00001111,3*30(a0)
	eor.b		#%00001111,4*30(a0)
	eor.b		#%00001111,5*30(a0)
	eor.b		#%00000111,6*30(a0)
	eor.b		#%00000001,7*30(a0)
	eor.b		#%00000001,(a0)+

	move.w		LargeurEcran,d1
	sub.w		#3,d1
	BoucleInversionBitsBarre:
		not.b		1*30(a0)
		not.b		2*30(a0)
		not.b		3*30(a0)
		not.b		4*30(a0)
		not.b		5*30(a0)
		not.b		6*30(a0)
		not.b		7*30(a0)
		not.b		(a0)+
		dbra		d1,BoucleInversionBitsBarre

	eor.b		#%10000000,0*30(a0)
	eor.b		#%11100000,1*30(a0)
	eor.b		#%11110000,2*30(a0)
	eor.b		#%11110000,3*30(a0)
	eor.b		#%11110000,4*30(a0)
	eor.b		#%11110000,5*30(a0)
	eor.b		#%11100000,6*30(a0)
	eor.b		#%10000000,7*30(a0)

	rts




;-----------------------------------------------------
;
;			Scrolling
;
;-----------------------------------------------------

ScrollHaut:
	move.w		NombreLignes,d0
	sub.w		#2,d0
	lea		YListeDepart*30(a0),a0
	BoucleScrollHaut:
		move.w		#PasDecalageListeY-1,d1
		BoucleScrollHaut2:
			move.l		00+PasDecalageListeY*30(a0),00(a0)
			move.l		04+PasDecalageListeY*30(a0),04(a0)
			move.l		08+PasDecalageListeY*30(a0),08(a0)
			move.l		12+PasDecalageListeY*30(a0),12(a0)
			move.l		16+PasDecalageListeY*30(a0),16(a0)
			move.l		20+PasDecalageListeY*30(a0),20(a0)
			move.l		24+PasDecalageListeY*30(a0),24(a0)
			move.w		28+PasDecalageListeY*30(a0),28(a0)
			lea		30(a0),a0
			dbra		d1,BoucleScrollHaut2
		dbra		d0,BoucleScrollHaut
	bsr		SupprimeLigne
	rts

ScrollBas:
	move.w		NombreLignes,d0
	sub.w		#2,d0
	lea		YListeDepart*30(a0),a0
	move.w		NombreLignes,d1
	mulu.w		#PasDecalageListeY*30,d1
	add.w		d1,a0
	BoucleScrollBas:
		move.w		#PasDecalageListeY-1,d1
		BoucleScrollBas2:
			move.l		-(04+PasDecalageListeY*30)(a0),-04(a0)
			move.l		-(08+PasDecalageListeY*30)(a0),-08(a0)
			move.l		-(12+PasDecalageListeY*30)(a0),-12(a0)
			move.l		-(16+PasDecalageListeY*30)(a0),-16(a0)
			move.l		-(20+PasDecalageListeY*30)(a0),-20(a0)
			move.l		-(24+PasDecalageListeY*30)(a0),-24(a0)
			move.l		-(28+PasDecalageListeY*30)(a0),-28(a0)
			move.w		-(30+PasDecalageListeY*30)(a0),-30(a0)
			lea		-30(a0),a0
			dbra		d1,BoucleScrollBas2
		dbra		d0,BoucleScrollBas
	lea		-30*PasDecalageListeY(a0),a0
	bsr		SupprimeLigne
	rts


SupprimeLigne:
	move.w		#PasDecalageListeY-1,d0
	BoucleSuppressionLigne:
		move.w		LargeurEcran,d1
		sub.w		#3,d1
		move.l		a0,a1
		lea		1(a0),a0
		BoucleSuppressionLigne2:
			clr.b		(a0)+
			dbra		d1,BoucleSuppressionLigne2
		move.l		a1,a0
		lea		30(a0),a0
		dbra		d0,BoucleSuppressionLigne
	rts



;-----------------------------------------------------
;
;			Affiche la liste des dossiers/fichiers
;
;-----------------------------------------------------

AfficheListing2:
	movem.l		d0-d7/a0-a6,-(a7)
	move.w		NombreLignes,d5
	add.w		d5,PositionListeEcran
	sub.w		#1,PositionListeEcran
	sub.w		#1,d5
	mulu.w		#PasDecalageListeY,d5
	add.w		#YListeDepart,d5
	move.w		#1,NombreLignes
	tst.w		PositionFolder
	bne		AfficheListeFichiers2
	bra		AfficheListeFolders2

AfficheListing:
	tst.w		PositionFolder
	bne		AfficheListeFichiers

;-----------------------------------------------------
;
;			Affiche les dossiers
;
;-----------------------------------------------------

AfficheListeFolders:
	movem.l		d0-d7/a0-a6,-(a7)

	move.w		#YListeDepart,d5

AfficheListeFolders2:
	move.w		LargeurEcran,d4
	lsl.w		#3,d4
	sub.w		#6*5+8,d4				; Coordonnee X du nb correspondant a la taille/nb fichiers

	move.w		FolderListHandle,-(a7)
	CALL		HeapDeref
	addq.l		#2,a7

	lea		2(a0),a2
	move.w		(a2),d7					; nombre de folders
	move.w		d7,NombreItems
	cmp.w		NombreLignes,d7
	blt		PasseReajustementAffichageFolders
	move.w		NombreLignes,d7
PasseReajustementAffichageFolders:
	move.w		PositionListeEcran,d0
	mulu.w		#14,d0
	add.w		d0,a2
	subq.w		#1,d7
	BoucleAffichageFolders:
		lea		2(a2),a3			; nom du dossier
		move.w		#1,-(a7)
		move.l		a3,-(a7)
		move.w		d5,-(a7)
		move.w		#7,-(a7)
		CALL		DrawStrXY
		bsr		PortSetPlane1
		CALL		DrawStrXY
		lea		10(a7),a7

		move.w		14(a2),-(a7)
		CALL		HeapDeref
		addq.l		#2,a7
		addq.l		#2,a0
		move.w		(a0)+,d6			; nombre de fichiers par dossier

		sub.w		#6*6-2,d4
		move.w		d6,d0				; Nombre a afficher
		moveq		#5,d1				; Largeur du nombre en caracteres
		lea		FinChaineTemporaire(PC),a0
		bsr		ConversionNombreChaine
		move.w		#1,-(a7)			; Couleur
		move.l		a0,-(a7)			; Chaine contenant le nombre
		move.w		d5,-(a7)			; y
		move.w		d4,-(a7)			; x
		bsr		PortSetPlane0
		CALL		DrawStrXY
		lea		10(a7),a7

		add.w		#6*6-2,d4
		move.w		#1,-(a7)			; Couleur
		move.l		#chaine_files,-(a7)		; Chaine contenant le nombre
		move.w		d5,-(a7)			; y
		move.w		d4,-(a7)			; x
		CALL		DrawStrXY
		lea		10(a7),a7

		lea		14(a2),a2			; passe au prochain dossier
		add.w		#PasDecalageListeY,d5		; on passe a la ligne suivante

		dbra		d7,BoucleAffichageFolders
	movem.l		(a7)+,d0-d7/a0-a6
	rts


;-----------------------------------------------------
;
;			Affiche les fichiers
;
;-----------------------------------------------------

AfficheListeFichiers:
	movem.l		d0-d7/a0-a6,-(a7)

	move.w		#YListeDepart,d5			; premiere ligne d affichage
AfficheListeFichiers2:

	move.w		LargeurEcran,d4
	lsl.w		#3,d4
	sub.w		#6*5+8,d4				; Coordonnee X du nb correspondant a la taille/nb fichiers

	move.w		FolderListHandle,-(a7)
	CALL		HeapDeref
	addq.l		#2,a7
	lea		2(a0),a0

	move.w		RepertoireSelectionne,d0
	mulu.w		#14,d0
	add.w		d0,a0

	move.w		14(a0),-(a7)
	CALL		HeapDeref
	addq.l		#2,a7

	lea		2(a0),a2
	move.w		(a2)+,d7
	move.w		d7,NombreItems
	beq		AucunFichierAAfficher			; si le dossier est vide, on n'affiche rien
	cmp.w		NombreLignes,d7
	blt		PasseReajustementAffichageFichiers
	move.w		NombreLignes,d7
PasseReajustementAffichageFichiers:
	move.w		PositionListeEcran,d0
	mulu.w		#14,d0
	add.w		d0,a2
	subq.w		#1,d7
	BoucleAffichageFichiers:
		move.w		#1,-(a7)			; affiche le nom du fichier
		move.l		a2,-(a7)
		move.w		d5,-(a7)
		move.w		#7+2*6+2,-(a7)
		CALL		DrawStrXY
		bsr		PortSetPlane1
		CALL		DrawStrXY
		lea		10(a7),a7

		move.w		12(a2),-(a7)			; affiche la taille du fichier
		CALL		HeapDeref
		addq.l		#2,a7
		clr.l		d6
		move.w		(a0),d6
		move.l		a0,a6

		lea		1(a0,d6.l),a4			; le genre
		cmp.b		#TypeAutre,(a4)
		bne		PasTypeAutre
		move.l		#FinChaineTemporaire-1,a3
		clr.b		-(a3)
		subq.l		#1,a4
	RemplitTypeAutre:
		move.b		-(a4),-(a3)
		tst.b		(a4)
		bne		RemplitTypeAutre
		lea		1(a3),a3
		bra		AfficheType
	PasTypeAutre:
		move.l		#Extensions,a3
		cmp.b		#TypeASM,(a4)
		bne		PasTypeASM
		cmp.l		#'68kL',6(a0)
		bne		AfficheType
		add.l		#01*5,a3
		bra		AfficheType
	PasTypeASM:
		add.l		#02*5,a3
		cmp.b		#TypeDATA,(a4)
		beq		AfficheType
	PasTypeDATA:
		add.l		#01*5,a3
		cmp.b		#TypeFIG,(a4)
		beq		AfficheType
	PasTypeFIG:
		add.l		#01*5,a3
		cmp.b		#TypeGDB,(a4)
		beq		AfficheType
	PasTypeGDB:
		add.l		#01*5,a3
		cmp.b		#TypeSTR,(a4)
		bne		PasTypeSTR
		cmp.w		#'CP',2(a0)
		bne		AfficheType
;		cmp.b		#'P',3(a0)
;		bne		AfficheType
		cmp.b		#'k',4(a0)
		bne		AfficheType
		add.l		#01*5,a3
		bra		AfficheType
	PasTypeSTR:
		add.l		#02*5,a3
		cmp.b		#TypeLIST,(a4)
		bne		PasTypeLIST
		cmp.b		#TypeLIST,-1(a4)
		bne		AfficheType
		add.l		#01*5,a3
		bra		AfficheType
	PasTypeLIST:
		add.l		#02*5,a3
		cmp.b		#TypeMACR,(a4)
		beq		AfficheType
	PasTypeMACR:
		add.l		#01*5,a3
		cmp.b		#TypePIC,(a4)
		beq		AfficheType
	PasTypePIC:
		add.l		#01*5,a3
		cmp.b		#TypeFUNC,(a4)
		bne		PasTypeFUNC
		cmp.b		#$19,-6(a4)
		bne		AfficheType
		cmp.b		#$E4,-5(a4)
		bne		AfficheType
		cmp.b		#$E5,-4(a4)
		bne		AfficheType
		add.l		#01*5,a3
		bra		AfficheType
	PasTypeFUNC:
		add.l		#02*5,a3
		cmp.b		#TypeTEXT,(a4)
		beq		AfficheType
	PasTypeTEXT:
		add.l		#01*5,a3
		bra		AfficheType
	AfficheType:
		move.w		d4,d0
		sub.w		#8*4-3,d0
		move.w		#1,-(a7)			; Couleur
		move.l		a3,-(a7)			; Chaine contenant le type
		move.w		d5,-(a7)			; y
		move.w		d0,-(a7)			; x
		CALL		DrawStrXY
		lea		10(a7),a7

		move.l		#ChaineTemporaire,a0
		clr.l		(a0)
		cmp.l		AdresseArchive,a6
		blt		FichierNonArchive
		move.b		#164,(a0)
	FichierNonArchive:
		move.w		#1,-(a7)			; Couleur
		move.l		a0,-(a7)			; Chaine contenant le nombre
		move.w		d5,-(a7)			; y
		move.w		#7,-(a7)			; x
		bsr		PortSetPlane1
		CALL		DrawStrXY
		lea		10(a7),a7

		add.w		#2,d6
		move.w		d6,d0				; Nombre a afficher
		moveq		#5,d1				; Largeur du nombre en caracteres
		lea		FinChaineTemporaire(PC),a0
		bsr		ConversionNombreChaine
		move.w		#1,-(a7)			; Couleur
		move.l		a0,-(a7)			; Chaine contenant le nombre
		move.w		d5,-(a7)			; y
		move.w		d4,-(a7)			; x
		bsr		PortSetPlane0
		CALL		DrawStrXY
		lea		10(a7),a7


		lea		14(a2),a2			; on passe au prochain fichier
		add.w		#PasDecalageListeY,d5		; et a la ligne suivante
		dbra		d7,BoucleAffichageFichiers
	AucunFichierAAfficher:

	movem.l		(a7)+,d0-d7/a0-a6
	rts
