;-----------------------------------------------------
;
;			Explorer
;
;
;			 2001 Par Flavien Racine
;			http://flashz.multimania.com/
;
;			v1.00, le 02/12/2001
;
;-----------------------------------------------------
;
; Pour lire ce source, le mieux est d'utiliser TI-GCC IDE
; avec une tabulation de 8 caracteres de large.
;
;-----------------------------------------------------


_nostub
_ti92plus
_ti89
_v200

	xdef		_nostub
	xdef		_ti92plus				; Pour TI-92+
	xdef		_ti89					; Pour TI-89
	xdef		_v200

	movem.l		d0-d7/a0-a6,-(a7)

	

;-----------------------------------------------------
;
;			On saute jusqu'au depart du programme
;
;-----------------------------------------------------

	bra		DepartProgramme


;-----------------------------------------------------
;
;			Fichiers includes, code pur
;
;-----------------------------------------------------

	include		"macros.h"
	include		"equates.h"
	even
	include		"routines.h"
	even
	include		"graylib.h"
	even
	include		"graphics.h"
	even
	include		"main.h"
	even
	include		"exec.h"
	even


DepartProgramme:

;-----------------------------------------------------
;
;			Sauvegarde de l'ecran et le nettoye
;
;-----------------------------------------------------

	move.l		#3840,-(a7)		; Taille de l'ecran a sauver
	CALL		HeapAlloc		;
	addq.l		#4,a7			;
	move.w		d0,HandleSauvegardeEcran
	beq		ErreurMemoire0
	move.w		d0,-(a7)
	CALL		HeapDeref
	lea		2(a7),a7

	move.w		#959,d0
	move.l		#$4C00,a1
BoucleSauvegardeEcran:
	move.l		(a1),(a0)+
	clr.l		(a1)+
	dbra		d0,BoucleSauvegardeEcran

;-----------------------------------------------------
;
;			Initialisation
;
;-----------------------------------------------------

	bsr		DetectionHardWare
	bsr		SelectionneCalculatrice


	bsr		GrayScalesOn
	tst.w		d0
	beq		ErreurMemoire1

	pea		HSymMain(pc)		; On met l'argument 'main' dans la pile
	CALL		SymFindHome		; On appelle la ROM_CALL
	move.l		d0,(a7)			; On met l'argument (qui est le rsultat) dans la pile
	swap		d0			; on change les deux parties de 16 bits de d0
	move.w		d0,FolderListHandle	; pour prendre le handle qui se trouvait dans le .l
	addq.w		#4,a7			; On restaure la pile 

	SetFont		#1
	clr.w		PositionFolder
	clr.w		PositionBarre
	clr.w		RepertoireSelectionne
	clr.w		OldPositionListeEcran
	clr.w		PositionListeEcran
	bsr		InitialiseEcran


;-----------------------------------------------------
;
;			On lance l'exploration (moteur situe dans main.h)
;
;-----------------------------------------------------
	
	bsr		BouclePrincipale

;-----------------------------------------------------
;
;			Restitution du systeme
;
;-----------------------------------------------------

QuitteExplorer:
	bsr		GrayScalesOff
	move.w		#336,-(a7)
	CALL		OSInitKeyInitDelay
	move.w		#48,(a7)
	CALL		OSInitBetweenKeyDelay
	addq.l		#2,a7

;-----------------------------------------------------
;
;			On restaure l'ecran
;
;-----------------------------------------------------

ErreurMemoire1:
	move.w		HandleSauvegardeEcran,-(a7)
	CALL		HeapDeref
	lea		2(a7),a7

	move.w		#959,d0
	move.l		#$4C00,a1
BoucleRestaurationEcran:
	move.l		(a0)+,(a1)+
	dbra		d0,BoucleRestaurationEcran

	move.w		HandleSauvegardeEcran,-(a7)
	CALL		HeapFree
	addq.l		#2,a7

;-----------------------------------------------------
;
;			... puis les registres, et on quitte
;
;-----------------------------------------------------

ErreurMemoire0:
	movem.l		(a7)+,d0-d7/a0-a6
	rts




;-----------------------------------------------------
;
;			Autres includes, donnees et images
;
;-----------------------------------------------------

	even
	include		"barre_haut.h"
	even
	include		"barre_haut_gauche.h"
	even
	include		"barre_haut_droite.h"
	even
	include		"donnees.h"
	even
	include		"chaines.h"


	end
