/******************************************************************************
*
* project name:    TIGCC Tools Suite
* file name:       ttunpack.h
* initial date:    01/02/2001
* authors:         thomas.nussbaumer@gmx.net
*                  samuel@nyall.net
*
* description:     defines for exepack functionalities including unpack routine
*                  (complete rewrite of TIGCC Tools Suite header file)
*
*   This is a 100% assembly version of the ttunpack routine, which is
*   based on code by Pasi 'Albert' Ojala, albert@cs.tut.fi, then
*   reduced by Thomas Nussbaumer to fit his needs.  For a full details
*   on the algorithm see:
*
*	  http://www.cs.tut.fi/~albert/Dev/pucrunch/index.html
*
*
* Liscense:
*
*   The liscense is quite similar to that of the origional version in c.
*
*   The code may be freely used in any non commercial application.  If
*   you do use it please give credit to tict (http://tict.ticalc.org) and
*   myself (Samuel Stearley).  I state this as a request but it is actually
*   not.
*
*   The author(s) (Samuel/Tict/Any other contributor) make no
*   representations or warranties about the suitability of the software,
*   either express or implied. The author(s) shall not be liable for
*   any damages suffered as a result of using or distributing this
*   software.
*
*   If you distribute this file on a website or as part of
*   the source of a project do not remove the liscense from this file.
*
*
* $Id: ttunpack.h,v 2.0 2004/08/30 12:00:00 Samuel Stearley Exp $
*
******************************************************************************/
#ifndef __TTUNPACK_H__
#define __TTUNPACK_H__

typedef struct {
    unsigned char  osize_lo;   // original size lowbyte
    unsigned char  osize_hi;   // original size highbyte
    unsigned char  magic1;     // must be equal to TTUNPACK_MAGIC1
    unsigned char  magic2;     // must be equal to TTUNPACK_MAGIC2
    unsigned char  csize_lo;   // compressed size lowbyte
    unsigned char  csize_hi;   // compressed size lowbyte
    unsigned char  esc1;       // escape >> (8-escBits)
    unsigned char  notused3;
    unsigned char  notused4;
    unsigned char  esc2;       // escBits
    unsigned char  gamma1;     // maxGamma + 1
    unsigned char  gamma2;     // (1<<maxGamma)
    unsigned char  extralz;    // extraLZPosBits
    unsigned char  notused1;
    unsigned char  notused2;
    unsigned char  rleentries; // rleUsed
} TTUNPACK_HEADER;

#define TTUNPACK_MAGIC1 0x54
#define TTUNPACK_MAGIC2 0x50

#define ttunpack_size(_p_)  ((unsigned short)(((TTUNPACK_HEADER*)(_p_))->osize_lo | (((TTUNPACK_HEADER*)(_p_))->osize_hi << 8)))
#define ttunpack_valid(_p_) (((TTUNPACK_HEADER*)(_p_))->magic1 == TTUNPACK_MAGIC1 && ((TTUNPACK_HEADER*)(_p_))->magic2 == TTUNPACK_MAGIC2)

#define TTUNPACK_OKAY             0
#define TTUNPACK_NOESCFOUND     248
#define TTUNPACK_ESCBITS        249
#define TTUNPACK_MAXGAMMA       250
#define TTUNPACK_EXTRALZP       251
#define TTUNPACK_NOMAGIC        252
#define TTUNPACK_OUTBUFOVERRUN  253
#define TTUNPACK_LZPOSUNDERRUN  254

#define GREG_UNPACK_HEXARRAY

#define ttunpack_decompress ((unsigned short(*)(unsigned char*,unsigned char*))(unsigned short[])\
{\
0x48e7,0x1f3e,0x2c6f,0x002c,0x2a6f,0x0030,0x47ee,0x000f,0x7a00,0x1a2e,\
0x0006,0x7e07,0x70fc,0x0c2e,0x0054,0x0002,0x6640,0x0c2e,0x0050,0x0003,\
0x6638,0x7808,0x70fa,0xb82e,0x000a,0x662e,0x0c2e,0x0080,0x000b,0x6626,\
0x70f9,0x7200,0x122e,0x0009,0x2841,0x5101,0x6418,0x70fb,0x122e,0x000c,\
0x2241,0x5b01,0x6e0c,0x984c,0x1213,0x4df6,0x1010,0x6018,0x7000,0x0240,\
0x00ff,0x4cdf,0x7cf8,0x4e75,0x320c,0x613a,0xc145,0x3204,0x613a,0x1ac0,\
0x320c,0x6706,0x612c,0xb005,0x66f0,0x6132,0x3600,0x5340,0x673c,0x612a,\
0x5200,0x67d0,0x5500,0x3209,0x611a,0x7207,0x6114,0x4600,0x4680,0x41f5,\
0x0800,0x1ad8,0x51cb,0xfffc,0x60ce,0x7000,0x6002,0x614a,0x51c9,0xfffc,\
0x4e75,0x7206,0x6140,0x57c9,0xfffc,0x4441,0x5c41,0x7001,0x60ea,0x6132,\
0x67cc,0x612e,0x679e,0x61e6,0x7600,0x1600,0x6a0c,0x6122,0x3f00,0x61da,\
0x5300,0x1e80,0x361f,0x61d2,0x0c00,0x0020,0x6406,0x1033,0x0000,0x6004,\
0x7202,0x61ba,0x204d,0x1ac0,0x60aa,0xd040,0x0f16,0x56c2,0x9002,0x5307,\
0x6404,0x7e07,0x528e,0x4a02,0x4e75})

#endif

//=============================================================================
// Revision History
//=============================================================================
//
// $Log: ttunpack.h,v $
//
// Revision 2.0  2004/08/30 12:00:00  Samuel Stearley
// New extraction routine in 100% asm.
//
// Revision 1.4  2002/03/28 21:17:28  tnussb
// project name in header changed to TIGCC Tools Suite
//
// Revision 1.3  2002/03/13 15:09:58  tnussb
// new exepack decompression function generated from old/unpack.c added
// (its a little bit smaller now). The new function should work as the old one,
// but if there are problems I will leave the old hexcode array here, too
//
// Revision 1.2  2001/02/05 20:33:01  Thomas Nussbaumer
// (1) magic of ttunpack header splitted again into 2 bytes to prevent address errors
// (2) new (stable?) pc-relative version of unpacking routine
//
//


 